/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.wiring.BlockLuminatorMultipart;
import ic2.core.block.wiring.TileEntityCable;
import ic2.core.block.wiring.TileEntityLuminatorMultipart;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class RenderBlockLuminatorMultipart
implements ISimpleBlockRenderingHandler {
    public static int renderId = RenderingRegistry.getNextAvailableRenderId();

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        RenderingRegistry.instance().renderInventoryBlock(renderer, Block.func_149634_a((Item)Ic2Items.luminator.func_77973_b()), 0, IC2.platform.getRenderId("luminator"));
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileEntityLuminatorMultipart)) {
            return true;
        }
        BlockLuminatorMultipart part = (BlockLuminatorMultipart)block;
        TileEntityLuminatorMultipart multi = (TileEntityLuminatorMultipart)tile;
        int type = multi.cable != null ? multi.cable.func_77960_j() : 1;
        float thickness = TileEntityCable.getCableThickness(type);
        BlockLuminatorMultipart.renderPass = 1;
        renderer.func_147782_a(0.5 - (double)(thickness /= 2.0f), 0.5 - (double)thickness, 0.5 - (double)thickness, 0.5 + (double)thickness, 0.5 + (double)thickness, 0.5 + (double)thickness);
        renderer.func_147784_q(block, x, y, z);
        for (int i = 0; i < 6; ++i) {
            boolean lamp = multi.hasSide(i);
            boolean cable = multi.canConnect(i);
            if (lamp) {
                cable = false;
                BlockLuminatorMultipart.renderPass = 0;
                BlockLuminatorMultipart.side = i;
                float[] array = BlockLuminatorMultipart.getBoundingBoxForSide(i);
                block.func_149676_a(array[0], array[1], array[2], array[3], array[4], array[5]);
                renderer.func_147775_a(block);
                renderer.func_147784_q(block, x, y, z);
                BlockLuminatorMultipart.side = -1;
            }
            if (!lamp && !cable) continue;
            BlockLuminatorMultipart.renderPass = 1;
            this.renderSide(i, cable, lamp, thickness, block, renderer, x, y, z);
        }
        block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return true;
    }

    private void renderSide(int side, boolean canConnect, boolean lamp, float thickness, Block block, RenderBlocks render, int x, int y, int z) {
        float min;
        float f = canConnect ? 0.0f : (min = lamp ? 0.0625f : 0.0f);
        float max = canConnect ? 1.0f : (lamp ? 0.9375f : 1.0f);
        float[] array = this.getRenderBounds(side, min, max, thickness);
        block.func_149676_a(array[0], array[1], array[2], array[3], array[4], array[5]);
        render.func_147775_a(block);
        render.func_147784_q(block, x, y, z);
    }

    private float[] getRenderBounds(int side, float min, float max, float half) {
        switch (side) {
            case 0: {
                return new float[]{0.5f - half, min, 0.5f - half, 0.5f + half, 0.5f - half, 0.5f + half};
            }
            case 1: {
                return new float[]{0.5f - half, 0.5f + half, 0.5f - half, 0.5f + half, max, 0.5f + half};
            }
            case 2: {
                return new float[]{0.5f - half, 0.5f - half, min, 0.5f + half, 0.5f + half, 0.5f - half};
            }
            case 3: {
                return new float[]{0.5f - half, 0.5f - half, 0.5f + half, 0.5f + half, 0.5f + half, max};
            }
            case 4: {
                return new float[]{min, 0.5f - half, 0.5f - half, 0.5f - half, 0.5f + half, 0.5f + half};
            }
            case 5: {
                return new float[]{0.5f + half, 0.5f - half, 0.5f - half, max, 0.5f + half, 0.5f + half};
            }
        }
        return new float[]{min, min, min, max, max, max};
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return renderId;
    }
}

