/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyContainer;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMachineUpgradeItem;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.api.tile.IMachine;
import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.IC2DamageSource;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.machine.tileentity.FakeMachine;
import ic2.core.block.personal.IPersonalBlock;
import ic2.core.block.personal.IPersonalInventory;
import ic2.core.block.personal.PersonalInventory;
import ic2.core.block.wiring.ContainerChargePad;
import ic2.core.block.wiring.EntityChargePadAuraFX;
import ic2.core.block.wiring.TileEntityChargePadHV;
import ic2.core.block.wiring.TileEntityChargePadLV;
import ic2.core.block.wiring.TileEntityChargePadMV;
import ic2.core.block.wiring.TileEntityChargePadNuclear;
import ic2.core.item.ItemChargePadUpgrade;
import ic2.core.util.IElectricHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityChargePad
extends TileEntityBlock
implements IEnergySink,
IPersonalBlock,
INetworkTileEntityEventListener,
IHasGui,
IEnergyContainer {
    public int defaultMaxEnergy;
    public int defaultTier;
    public int defaultMaxInput;
    public int maxEnergy;
    public int storedEnergy = 0;
    public int tier;
    public int maxInput;
    public int transferlimit;
    public int extraRange;
    public int activeTime = 0;
    public boolean isForcedOff;
    public int forcedTicker;
    FakeMachine fake = null;
    public boolean[] installedUpgrades = new boolean[PadUpgrade.values().length];
    public ChargePadType type;
    public PersonalInventory inv;
    public boolean Enet = false;

    public TileEntityChargePad(ChargePadType type) {
        this.type = type;
        this.defaultMaxEnergy = this.maxEnergy = type.getMaxEnergy();
        this.defaultTier = this.tier = type.getTier();
        this.defaultMaxInput = this.maxInput = (int)EnergyNet.instance.getPowerFromTier(this.tier);
        this.transferlimit = this.maxInput;
        this.inv = new PersonalInventory(this, "Inventory", 1 + type.getUpgradeSlots() + (type == ChargePadType.LV ? 0 : 2));
        this.addNetworkFields("type", "installedUpgrades", "extraRange");
        this.addGuiFields("storedEnergy", "maxEnergy", "maxInput", "transferlimit");
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return direction == ForgeDirection.DOWN;
    }

    @Override
    public double getDemandedEnergy() {
        return this.maxEnergy - this.storedEnergy;
    }

    @Override
    public int getSinkTier() {
        return this.tier;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (amount > (double)this.maxInput) {
            return 0.0;
        }
        this.storedEnergy = (int)((double)this.storedEnergy + amount);
        int re = 0;
        if (this.storedEnergy > this.maxEnergy) {
            re = this.storedEnergy - this.maxEnergy;
            this.storedEnergy = this.maxEnergy;
        }
        this.getNetwork().updateTileGuiField(this, "storedEnergy");
        return re;
    }

    @Override
    public boolean canAccess(EntityPlayer p0) {
        return true;
    }

    @Override
    public boolean canAccess(UUID player) {
        return true;
    }

    @Override
    public IPersonalInventory getInventory(EntityPlayer player) {
        return null;
    }

    @Override
    public IPersonalInventory getInventory(UUID player) {
        return null;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating()) {
            this.updateUpgrades();
        }
        if (!this.Enet && this.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.Enet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isSimulating() && this.Enet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.Enet = false;
        }
        super.onUnloaded();
    }

    @Override
    public boolean canUpdate() {
        return this.isSimulating();
    }

    public void func_145845_h() {
        boolean drain;
        int toSend;
        boolean invUpdate;
        super.func_145845_h();
        if (this.getDemandedEnergy() > 1.0 && (invUpdate = this.provideEnergy())) {
            this.func_70296_d();
        }
        if (!this.getActive()) {
            if (this.isForcedOff && this.forcedTicker > 0) {
                --this.forcedTicker;
                if (this.forcedTicker <= 0) {
                    this.isForcedOff = false;
                }
            }
            return;
        }
        if (this.activeTime > 0) {
            --this.activeTime;
            if (this.activeTime <= 0) {
                this.deactiveChargePad();
                return;
            }
        }
        if ((toSend = Math.min((drain = this.tier > 2 && this.installedUpgrades[PadUpgrade.Drain.ordinal()] && IC2.platform.isPVP()) ? this.maxEnergy - this.storedEnergy : this.storedEnergy, this.transferlimit)) <= 0) {
            this.setForcedOff(20);
            this.activeTime = 0;
            return;
        }
        List<EntityLivingBase> list = this.getEntitiesInRange();
        if (list.isEmpty()) {
            this.deactiveChargePad();
            return;
        }
        if (this.installedUpgrades[PadUpgrade.Damage.ordinal()] && IC2.platform.isPVP()) {
            this.damageEntities(list);
            this.storedEnergy -= toSend;
            this.getNetwork().updateTileGuiField(this, "storedEnergy");
            return;
        }
        List<ItemStack> toCharge = new ArrayList();
        for (EntityLivingBase base : list) {
            int amount;
            if (base == null || base.field_70128_L || !(base instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)base;
            if (this.installedUpgrades[PadUpgrade.ArmorPriority.ordinal()]) {
                amount = toCharge.size();
                this.addPlayerArmor(player, toCharge, drain);
                if (amount != toCharge.size()) continue;
                this.addPlayerHotbar(player, toCharge, drain);
                continue;
            }
            amount = toCharge.size();
            this.addPlayerHotbar(player, toCharge, drain);
            if (amount != toCharge.size()) continue;
            this.addPlayerArmor(player, toCharge, drain);
        }
        int size = toCharge.size();
        if (size <= 0) {
            this.setForcedOff(20);
            this.activeTime = 0;
            return;
        }
        if (size > 1) {
            Collections.shuffle(toCharge);
        }
        if (toSend < size) {
            toCharge = toCharge.subList(0, toSend);
        }
        size = toCharge.size();
        for (ItemStack target : toCharge) {
            int toAdd = (int)Math.ceil(toSend / size--);
            int change = drain ? (int)ElectricItem.manager.discharge(target, toAdd, this.tier, true, false, false) : (int)ElectricItem.manager.charge(target, toAdd, this.tier, true, false);
            if (change <= 0) continue;
            this.storedEnergy -= change;
            toSend -= change;
            this.getNetwork().updateTileGuiField(this, "storedEnergy");
        }
    }

    protected void damageEntities(List<EntityLivingBase> list) {
        for (EntityLivingBase base : list) {
            if (base == null || base.field_70128_L) continue;
            base.func_70097_a((DamageSource)IC2DamageSource.electricity, 1.0f);
            if (base.func_70644_a(Potion.field_76436_u)) continue;
            base.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, this.type.ordinal() * 20, this.type.ordinal() * 10));
        }
    }

    protected void addPlayerArmor(EntityPlayer player, List<ItemStack> list, boolean drain) {
        IInventory inv;
        ItemStack[] armor = player.field_71071_by.field_70460_b;
        for (int i = 0; i < armor.length; ++i) {
            if (!this.canTransferEnergy(armor[i], drain)) continue;
            list.add(armor[i]);
        }
        if (IC2.modul.containsKey("Baubles Modul") && (inv = ((IElectricHelper)((Object)IC2.modul.get("Baubles Modul"))).getBaublesInventory(player)) != null) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack item = inv.func_70301_a(i);
                if (!this.canTransferEnergy(item, drain)) continue;
                list.add(item);
            }
        }
    }

    protected void addPlayerHotbar(EntityPlayer player, List<ItemStack> list, boolean drain) {
        int start;
        int end = start = player.field_71071_by.field_70461_c;
        if (this.installedUpgrades[PadUpgrade.Proximity.ordinal()]) {
            start = Math.max(0, start - 1);
            end = Math.min(8, end + 1);
        } else if (this.installedUpgrades[PadUpgrade.WideBand.ordinal()]) {
            start = 0;
            end = 8;
        }
        if (start < 0 || end > 8) {
            return;
        }
        for (int i = start; i <= end; ++i) {
            ItemStack item = player.field_71071_by.func_70301_a(i);
            if (!this.canTransferEnergy(item, drain)) continue;
            list.add(item);
        }
    }

    protected boolean canTransferEnergy(ItemStack item, boolean drain) {
        IElectricItem eItem;
        if (item == null) {
            return false;
        }
        if (this.isElectricItem(item) ? (eItem = (IElectricItem)item.func_77973_b()).getTier(item) > this.tier : !this.isIndirectElectricItem(item)) {
            return false;
        }
        double transfered = 0.0;
        transfered = drain ? ElectricItem.manager.discharge(item, 2.147483647E9, this.tier, true, false, true) : ElectricItem.manager.charge(item, 2.147483647E9, this.tier, true, true);
        return transfered > 0.0;
    }

    public boolean isIndirectElectricItem(ItemStack item) {
        if (item == null) {
            return false;
        }
        return ElectricItem.getBackupManager(item) != null;
    }

    protected boolean isElectricItem(ItemStack item) {
        return item != null && item.func_77973_b() instanceof IElectricItem;
    }

    public List<EntityLivingBase> getEntitiesInRange() {
        return this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)((double)this.field_145848_d + 0.25), (double)(this.field_145849_e + 1)).func_72314_b((double)this.extraRange, this.getFieldHeight(), (double)this.extraRange));
    }

    public double getFieldHeight() {
        return 0.5;
    }

    public void setForcedOff(int ticks) {
        this.isForcedOff = true;
        this.forcedTicker = ticks;
        this.deactiveChargePad();
    }

    public FakeMachine getMachine() {
        if (this.fake == null) {
            this.fake = new FakeMachine(this, new ArrayList<IMachine.UpgradeType>(Arrays.asList(IMachine.UpgradeType.MachineModifierA, IMachine.UpgradeType.MachineModifierB)));
        }
        return this.fake;
    }

    public void updateUpgrades() {
        this.getMachine();
        int extraProcessTime = 0;
        double processTimeMultiplier = 1.0;
        int extraEnergyStorage = 0;
        double energyStorageMultiplier = 1.0;
        int extraTier = 0;
        this.installedUpgrades = new boolean[PadUpgrade.values().length];
        for (int i = 1; i < this.inv.func_70302_i_(); ++i) {
            PadUpgrade up;
            ItemStack stack = this.inv.func_70301_a(i);
            if (stack == null) continue;
            Item item = stack.func_77973_b();
            if (item instanceof IMachineUpgradeItem) {
                IMachineUpgradeItem mach = (IMachineUpgradeItem)item;
                mach.onInstalling(stack, this.fake);
                extraProcessTime += mach.getExtraProcessTime(stack, this.fake) * stack.field_77994_a;
                processTimeMultiplier *= Math.pow(mach.getProcessTimeMultiplier(stack, this.fake), stack.field_77994_a);
                extraEnergyStorage += mach.getExtraEnergyStorage(stack, this.fake) * stack.field_77994_a;
                energyStorageMultiplier *= Math.pow(mach.getEnergyStorageMultiplier(stack, this.fake), stack.field_77994_a);
                extraTier += mach.getExtraTier(stack, this.fake) * stack.field_77994_a;
                continue;
            }
            if (!(item instanceof ItemChargePadUpgrade) || (up = ((ItemChargePadUpgrade)item).getUpgrade(stack)) == null) continue;
            this.installedUpgrades[up.ordinal()] = true;
        }
        int newTransfer = TileEntityChargePad.applyModifier(this.defaultMaxInput, extraProcessTime, processTimeMultiplier);
        this.setMaxEnergy(TileEntityChargePad.applyModifier(this.defaultMaxEnergy, extraEnergyStorage, energyStorageMultiplier));
        this.tier = this.defaultTier + extraTier;
        this.maxInput = (int)EnergyNet.instance.getPowerFromTier(this.tier);
        this.transferlimit = newTransfer;
        this.getNetwork().updateTileGuiField(this, "maxInput");
        this.getNetwork().updateTileGuiField(this, "transferlimit");
        this.extraRange = 0;
        List<PadUpgrade> range = Arrays.asList(PadUpgrade.FieldExpI, PadUpgrade.FieldExpII, PadUpgrade.FieldExpIII);
        for (int i = 0; i < range.size(); ++i) {
            if (!this.installedUpgrades[range.get(i).ordinal()]) continue;
            this.extraRange += 1 + i;
        }
        this.getNetwork().updateTileEntityField(this, "extraRange");
        this.getNetwork().updateTileEntityField(this, "installedUpgrades");
    }

    private void setMaxEnergy(int max) {
        this.maxEnergy = max;
        this.getNetwork().updateTileGuiField(this, "maxEnergy");
    }

    static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    public void deactiveChargePad() {
        this.setActive(false);
        this.getNetwork().initiateTileEntityEvent(this, 0, true);
        for (ForgeDirection dir : ForgeDirection.values()) {
            if (!this.field_145850_b.func_72899_e(this.field_145851_c + dir.offsetZ, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ)) continue;
            this.field_145850_b.func_147460_e(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, this.func_145838_q());
        }
    }

    @Override
    public void onNetworkEvent(int event) {
        if (event == 0) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.25, (double)this.field_145849_e + 0.5, "random.click", 0.3f, 0.5f);
        } else if (event == 1) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.25, (double)this.field_145849_e + 0.5, "random.click", 0.3f, 0.6f);
        }
    }

    public boolean provideEnergy() {
        boolean ret = false;
        if (this.inv.func_70301_a(0) == null) {
            return false;
        }
        Item item = this.inv.func_70301_a(0).func_77973_b();
        if (item instanceof IElectricItem) {
            if (!((IElectricItem)item).canProvideEnergy(this.inv.func_70301_a(0))) {
                return false;
            }
            int transfer = (int)ElectricItem.manager.discharge(this.inv.func_70301_a(0), this.maxEnergy - this.storedEnergy, this.tier, false, true, false);
            this.storedEnergy += transfer;
            if (transfer > 0) {
                this.getNetwork().updateTileGuiField(this, "storedEnergy");
            }
            return ret || transfer > 0;
        }
        if (item == Items.field_151137_ax) {
            this.storedEnergy += this.maxEnergy;
            ItemStack itemStack = this.inv.func_70301_a(0);
            --itemStack.field_77994_a;
            if (this.inv.func_70301_a((int)0).field_77994_a <= 0) {
                this.inv.func_70299_a(0, null);
            }
            this.getNetwork().updateTileGuiField(this, "storedEnergy");
            return true;
        }
        if (item == Ic2Items.suBattery.func_77973_b()) {
            this.storedEnergy += 1000;
            ItemStack itemStack2 = this.inv.func_70301_a(0);
            --itemStack2.field_77994_a;
            if (this.inv.func_70301_a((int)0).field_77994_a <= 0) {
                this.inv.func_70299_a(0, null);
            }
            this.getNetwork().updateTileGuiField(this, "storedEnergy");
            return true;
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticals(Random rand) {
        float multPos = (float)(this.extraRange * 2) + 0.9f;
        int blockX = this.field_145851_c - this.extraRange;
        int blockZ = this.field_145849_e - this.extraRange;
        boolean swirl = this.type == ChargePadType.Nuclear;
        EffectRenderer er = Minecraft.func_71410_x().field_71452_i;
        for (int i = 1 + this.extraRange * 2; i > 0; --i) {
            for (int k = this.getParticalAmount(rand); k > 0; --k) {
                double x = (float)blockX + 0.05f + rand.nextFloat() * multPos;
                double y = (float)this.field_145848_d + 0.2f + rand.nextFloat() * 0.2f;
                double z = (float)blockZ + 0.05f + rand.nextFloat() * multPos;
                double[] velocity = this.getParticleVelocity(rand);
                if (k < 4) {
                    velocity[2] = velocity[2] * 0.55;
                }
                float[] colour = this.getParticalColour(rand);
                er.func_78873_a((EntityFX)new EntityChargePadAuraFX(this.field_145850_b, x, y, z, this.getMaxParticalAge(), velocity, colour, swirl));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract int getMaxParticalAge();

    @SideOnly(value=Side.CLIENT)
    protected abstract float[] getParticalColour(Random var1);

    @SideOnly(value=Side.CLIENT)
    protected abstract double[] getParticleVelocity(Random var1);

    @SideOnly(value=Side.CLIENT)
    protected abstract int getParticalAmount(Random var1);

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public abstract ItemStack getWrenchDrop(EntityPlayer var1);

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.activeTime = nbt.func_74762_e("ActiveTime");
        this.forcedTicker = nbt.func_74762_e("ForcedTime");
        this.storedEnergy = nbt.func_74762_e("StoredEnergy");
        this.isForcedOff = nbt.func_74767_n("ForcedOff");
        this.inv.readFromNBT(nbt.func_74775_l("Inventory"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("ActiveTime", this.activeTime);
        nbt.func_74768_a("ForcedTime", this.forcedTicker);
        nbt.func_74768_a("StoredEnergy", this.storedEnergy);
        nbt.func_74757_a("ForcedOff", this.isForcedOff);
        NBTTagCompound data = new NBTTagCompound();
        this.inv.writeToNBT(data);
        nbt.func_74782_a("Inventory", (NBTBase)data);
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer p0) {
        return new ContainerChargePad(this, p0.field_71071_by);
    }

    @Override
    public String getGuiClassName(EntityPlayer p0) {
        return "block.wiring.GuiChargePad";
    }

    @Override
    public void onGuiClosed(EntityPlayer p0) {
    }

    @Override
    public int getStoredEnergy() {
        return this.storedEnergy;
    }

    @Override
    public int getEnergyCapacity() {
        return this.maxEnergy;
    }

    @Override
    public int getEnergyUsage() {
        return this.transferlimit;
    }

    @Override
    public int getEnergyProduction() {
        return 0;
    }

    @Override
    public int getMaxEnergyInput() {
        return this.maxInput;
    }

    public static enum ChargePadType {
        LV(40, 1, 1, 3.5f, TileEntityChargePadLV.class, "tile.chargePadLV.name"),
        MV(600, 2, 2, 2.5f, TileEntityChargePadMV.class, "tile.chargePadMV.name"),
        HV(10000, 3, 3, 1.5f, TileEntityChargePadHV.class, "tile.chargePadHV.name"),
        Nuclear(150000, 4, 3, 1.5f, TileEntityChargePadNuclear.class, "tile.chargePadNuclear.name");

        int maxEnergy;
        int tier;
        int upgradeSlots;
        float maxImpact;
        String name;
        Class<? extends TileEntityChargePad> clz;

        private ChargePadType(int par1, int par2, int par3, float par4, Class<? extends TileEntityChargePad> par5, String par6) {
            this.maxEnergy = par1 * 1000;
            this.tier = par2;
            this.upgradeSlots = par3;
            this.maxImpact = par4;
            this.clz = par5;
            this.name = par6;
        }

        public int getMaxEnergy() {
            return this.maxEnergy;
        }

        public int getTier() {
            return this.tier;
        }

        public int getUpgradeSlots() {
            return this.upgradeSlots;
        }

        public float getMaxImpact() {
            return this.maxImpact;
        }

        public TileEntityChargePad createPad() {
            if (this.clz == null) {
                return null;
            }
            try {
                return this.clz.newInstance();
            }
            catch (Exception exception) {
                return null;
            }
        }

        public static ChargePadType getType(int meta) {
            ChargePadType[] types = ChargePadType.values();
            if (meta >= 0 && meta < types.length) {
                return types[meta];
            }
            return null;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum PadUpgrade {
        Damage(false, true, 2),
        Drain(false, false, 2),
        Proximity(true, false, 2),
        WideBand(true, true, 2),
        ArmorPriority(false, false, 2),
        FieldExpI(true, false, 2),
        FieldExpII(true, false, 3),
        FieldExpIII(true, true, 3);

        public boolean isProject;
        public boolean isRare;
        public int requiredTier;

        private PadUpgrade(boolean par1, boolean par2, int par3) {
            this.isProject = par1;
            this.isRare = par2;
            this.requiredTier = par3;
        }
    }
}

