/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy;

import ic2.api.Direction;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.NodeStats;
import ic2.api.energy.PacketStat;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.energy.tile.IMetaDelegate;
import ic2.api.energy.tile.IMultiEnergySource;
import ic2.core.ExplosionIC2;
import ic2.core.IC2;
import ic2.core.IC2DamageSource;
import ic2.core.energy.EnergyTransferList;
import ic2.core.util.FilteredList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyNetLocal {
    public static double minConductionLoss = 1.0E-4;
    private static Direction[] directions = Direction.values();
    public static EnergyTransferList list;
    private World world;
    private EnergyPathMap energySourceToEnergyPathMap = new EnergyPathMap();
    private Map<EntityLivingBase, Integer> entityLivingToShockEnergyMap = new HashMap<EntityLivingBase, Integer>();
    private Map<ChunkCoordinates, IEnergyTile> registeredTiles = new HashMap<ChunkCoordinates, IEnergyTile>();
    private Map<ChunkCoordinates, IEnergySource> sources = new HashMap<ChunkCoordinates, IEnergySource>();
    private WaitingList waitingList = new WaitingList();
    private UnloadingList unloading = new UnloadingList();

    EnergyNetLocal(World world) {
        this.world = world;
    }

    public void addTile(TileEntity par1) {
        if (par1 instanceof IMetaDelegate) {
            List<TileEntity> tiles = ((IMetaDelegate)par1).getSubTiles();
            for (TileEntity tile : tiles) {
                this.addTileEntity(EnergyNetLocal.coords(tile), par1);
            }
            if (par1 instanceof IEnergySource) {
                this.sources.put(EnergyNetLocal.coords(tiles.get(0)), (IEnergySource)par1);
            }
        } else {
            this.addTileEntity(EnergyNetLocal.coords(par1), par1);
        }
    }

    public void addTileEntity(ChunkCoordinates coords, TileEntity tile) {
        if (!(tile instanceof IEnergyTile) || this.registeredTiles.containsKey(coords) && !this.unloading.contains(coords)) {
            return;
        }
        this.registeredTiles.put(coords, (IEnergyTile)tile);
        this.update(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
        if (tile instanceof IEnergyAcceptor) {
            this.waitingList.onTileEntityAdded(this.getValidReceivers(tile, true), tile);
            this.unloading.onLoaded(coords);
        }
        if (tile instanceof IEnergySource && !(tile instanceof IMetaDelegate)) {
            this.sources.put(coords, (IEnergySource)tile);
        }
    }

    public void removeTile(TileEntity par1) {
        if (par1 instanceof IMetaDelegate) {
            List<TileEntity> tiles = ((IMetaDelegate)par1).getSubTiles();
            for (TileEntity tile : tiles) {
                this.removeTileEntity(EnergyNetLocal.coords(tile), par1);
            }
        } else {
            this.removeTileEntity(EnergyNetLocal.coords(par1), par1);
        }
    }

    public void removeTileEntity(ChunkCoordinates coords, TileEntity tile) {
        if (!(tile instanceof IEnergyTile) || !this.registeredTiles.containsKey(coords)) {
            boolean alreadyRemoved;
            boolean bl = alreadyRemoved = !this.registeredTiles.containsKey(coords);
            if (!alreadyRemoved) {
                IC2.log.warn("removing " + tile + " from the EnergyNet failed, already removed: " + alreadyRemoved);
            }
            return;
        }
        if (tile instanceof IEnergyAcceptor) {
            this.waitingList.onTileEntityRemoved(tile);
            this.unloading.onUnloaded(this.getValidReceivers(tile, true), coords, tile);
        }
        if (tile instanceof IEnergySource) {
            this.sources.remove(coords);
            this.energySourceToEnergyPathMap.remove((IEnergySource)tile);
            if (!(tile instanceof IEnergyAcceptor)) {
                this.registeredTiles.remove(coords);
                this.update(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
            }
        }
    }

    public List<PacketStat> getSendedPackets(TileEntity tileEntity) {
        LinkedHashMap<Integer, EnergyPacket> totalPackets = new LinkedHashMap<Integer, EnergyPacket>();
        if (tileEntity instanceof IEnergyConductor || tileEntity instanceof IEnergySink) {
            for (EnergyPath energyPath : this.energySourceToEnergyPathMap.getPaths((IEnergyAcceptor)tileEntity)) {
                if (energyPath.backupEnergyPackets.isEmpty() && !energyPath.mesuredEnergyPackets.isEmpty()) {
                    energyPath.backupEnergyPackets.putAll(energyPath.mesuredEnergyPackets);
                    energyPath.mesuredEnergyPackets.clear();
                }
                this.addPackets(totalPackets, energyPath.backupEnergyPackets);
            }
        }
        if (tileEntity instanceof IEnergySource && this.energySourceToEnergyPathMap.containsKey(tileEntity)) {
            for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(tileEntity)) {
                if (energyPath.backupEnergyPackets.isEmpty() && !energyPath.mesuredEnergyPackets.isEmpty()) {
                    energyPath.backupEnergyPackets.putAll(energyPath.mesuredEnergyPackets);
                    energyPath.mesuredEnergyPackets.clear();
                }
                this.addPackets(totalPackets, energyPath.backupEnergyPackets);
            }
        }
        ArrayList<PacketStat> packets = new ArrayList<PacketStat>();
        for (Map.Entry entry : totalPackets.entrySet()) {
            packets.add(new PacketStat((Integer)entry.getKey(), ((EnergyPacket)entry.getValue()).getAmount()));
        }
        Collections.sort(packets);
        return packets;
    }

    public List<PacketStat> getTotalSendedPackets(TileEntity tileEntity) {
        LinkedHashMap<Integer, EnergyPacket> totalPackets = new LinkedHashMap<Integer, EnergyPacket>();
        if (tileEntity instanceof IEnergyConductor || tileEntity instanceof IEnergySink) {
            for (EnergyPath energyPath : this.energySourceToEnergyPathMap.getPaths((IEnergyAcceptor)tileEntity)) {
                this.addPackets(totalPackets, energyPath.totalEnergyPackets);
            }
        }
        if (tileEntity instanceof IEnergySource && this.energySourceToEnergyPathMap.containsKey(tileEntity)) {
            for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(tileEntity)) {
                this.addPackets(totalPackets, energyPath.totalEnergyPackets);
            }
        }
        ArrayList<PacketStat> packets = new ArrayList<PacketStat>();
        for (Map.Entry entry : totalPackets.entrySet()) {
            packets.add(new PacketStat((Integer)entry.getKey(), ((EnergyPacket)entry.getValue()).getAmount()));
        }
        Collections.sort(packets);
        return packets;
    }

    public double getTotalEnergyEmitted(TileEntity tileEntity) {
        double ret = 0.0;
        if (tileEntity instanceof IEnergyConductor) {
            for (EnergyPath energyPath : this.energySourceToEnergyPathMap.getPaths((IEnergyAcceptor)tileEntity)) {
                ret += (double)energyPath.totalEnergyConducted;
            }
        }
        if (tileEntity instanceof IEnergySource && this.energySourceToEnergyPathMap.containsKey(tileEntity)) {
            for (EnergyPath energyPath2 : this.energySourceToEnergyPathMap.get(tileEntity)) {
                ret += (double)energyPath2.totalEnergyConducted;
            }
        }
        return ret;
    }

    public double getTotalEnergySunken(TileEntity tileEntity) {
        double ret = 0.0;
        if (tileEntity instanceof IEnergyConductor || tileEntity instanceof IEnergySink) {
            for (EnergyPath energyPath : this.energySourceToEnergyPathMap.getPaths((IEnergyAcceptor)tileEntity)) {
                ret += (double)energyPath.totalEnergyConducted;
            }
        }
        return ret;
    }

    public int emitEnergyFrom(ChunkCoordinates coords, IEnergySource energySource, int amount) {
        List<EnergyPath> paths;
        if (!this.registeredTiles.containsKey(coords)) {
            IC2.log.warn("EnergyNet.emitEnergyFrom: " + energySource + " is not added to the enet");
            return amount;
        }
        if (!this.energySourceToEnergyPathMap.containsKey(energySource)) {
            this.energySourceToEnergyPathMap.put(energySource, this.discover((TileEntity)energySource, false, EnergyTransferList.getMaxEnergy(energySource, amount)));
        }
        if ((paths = this.energySourceToEnergyPathMap.get(energySource)).isEmpty()) {
            return amount;
        }
        double totalInvLoss = 0.0;
        ArrayList<EnergyPath> activeEnergyPaths = new ArrayList<EnergyPath>(paths.size());
        for (EnergyPath energyPath : paths) {
            assert (energyPath.target instanceof IEnergySink);
            IEnergySink energySink = (IEnergySink)energyPath.target;
            if (energySink.getDemandedEnergy() <= 0.0 || energyPath.loss >= (double)amount || IC2.enableIC2EasyMode && this.conductorToWeak(energyPath, amount)) continue;
            totalInvLoss += 1.0 / energyPath.loss;
            activeEnergyPaths.add(energyPath);
        }
        if (activeEnergyPaths.isEmpty()) {
            return amount;
        }
        Collections.shuffle(activeEnergyPaths);
        for (int i = activeEnergyPaths.size() - amount; i > 0; --i) {
            EnergyPath removedEnergyPath = (EnergyPath)activeEnergyPaths.remove(activeEnergyPaths.size() - 1);
            totalInvLoss -= 1.0 / removedEnergyPath.loss;
        }
        double source = EnergyNet.instance.getPowerFromTier(energySource.getSourceTier());
        LinkedHashMap<EnergyPath, Integer> suppliedEnergyPaths = new LinkedHashMap<EnergyPath, Integer>();
        while (!activeEnergyPaths.isEmpty() && amount > 0) {
            int energyConsumed = 0;
            double newTotalInvLoss = 0.0;
            ArrayList<EnergyPath> currentActiveEnergyPaths = activeEnergyPaths;
            activeEnergyPaths = new ArrayList(currentActiveEnergyPaths.size());
            for (EnergyPath energyPath2 : currentActiveEnergyPaths) {
                int n;
                IEnergySink energySink2 = (IEnergySink)energyPath2.target;
                int energyProvided = (int)Math.floor((double)Math.round((double)amount / totalInvLoss / energyPath2.loss * 100000.0) / 100000.0);
                if (energyProvided > (n = (int)Math.floor(energyPath2.loss))) {
                    double providing = energyProvided - n;
                    double adding = Math.min(providing, energySink2.getDemandedEnergy());
                    if (adding <= 0.0 && EnergyTransferList.hasOverrideInput(energySink2)) {
                        adding = EnergyTransferList.getOverrideInput(energySink2);
                    }
                    if (adding <= 0.0) continue;
                    int accepting = (int)EnergyNet.instance.getPowerFromTier(energySink2.getSinkTier());
                    if (accepting <= 0) {
                        accepting = Integer.MAX_VALUE;
                    }
                    if (providing > (double)accepting) {
                        if (IC2.enableIC2EasyMode) continue;
                        this.explodeTiles(energySink2);
                        continue;
                    }
                    double energyReturned = energySink2.injectEnergy(energyPath2.targetDirection.toForgeDirection(), adding, source);
                    if (energyReturned == 0.0) {
                        if (energySink2.getDemandedEnergy() >= 1.0) {
                            activeEnergyPaths.add(energyPath2);
                            newTotalInvLoss += 1.0 / energyPath2.loss;
                        }
                    } else if (energyReturned >= (double)(energyProvided - n)) {
                        energyReturned = energyProvided - n;
                        IC2.log.warn("API ERROR: " + energySink2 + " didn't implement demandsEnergy() properly, no energy from injectEnergy accepted although demandsEnergy() returned true.");
                    }
                    energyConsumed = (int)((double)energyConsumed + (adding - energyReturned + (double)n));
                    int energyInjected = (int)(adding - energyReturned);
                    if (!suppliedEnergyPaths.containsKey(energyPath2)) {
                        suppliedEnergyPaths.put(energyPath2, energyInjected);
                        continue;
                    }
                    suppliedEnergyPaths.put(energyPath2, energyInjected + (Integer)suppliedEnergyPaths.get(energyPath2));
                    continue;
                }
                activeEnergyPaths.add(energyPath2);
                newTotalInvLoss += 1.0 / energyPath2.loss;
            }
            if (energyConsumed == 0 && !activeEnergyPaths.isEmpty()) {
                EnergyPath removedEnergyPath2 = (EnergyPath)activeEnergyPaths.remove(activeEnergyPaths.size() - 1);
                newTotalInvLoss -= 1.0 / removedEnergyPath2.loss;
            }
            totalInvLoss = newTotalInvLoss;
            amount -= energyConsumed;
        }
        for (Map.Entry entry : suppliedEnergyPaths.entrySet()) {
            EnergyPath energyPath3 = (EnergyPath)entry.getKey();
            int energyInjected2 = (Integer)entry.getValue();
            EnergyPath energyPath4 = energyPath3;
            energyPath4.totalEnergyConducted += (long)energyInjected2;
            this.addPacket(energyPath4, energyInjected2);
            if (energyInjected2 > energyPath3.minInsulationEnergyAbsorption) {
                HashMap<EntityLivingBase, Integer> shocks = new HashMap<EntityLivingBase, Integer>();
                List entitiesNearEnergyPath = this.world.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(energyPath3.minX - 1), (double)(energyPath3.minY - 1), (double)(energyPath3.minZ - 1), (double)(energyPath3.maxX + 2), (double)(energyPath3.maxY + 2), (double)(energyPath3.maxZ + 2)));
                for (IEnergyConductor iEnergyConductor : energyPath3.conductors) {
                    int shockAbsorbing = (int)iEnergyConductor.getInsulationEnergyAbsorption();
                    if (shockAbsorbing >= energyInjected2) continue;
                    ChunkCoordinates coord = EnergyNetLocal.coords((TileEntity)iEnergyConductor);
                    AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(coords.field_71574_a - 1), (double)(coords.field_71572_b - 1), (double)(coords.field_71573_c - 1), (double)(coords.field_71574_a + 2), (double)(coords.field_71572_b + 2), (double)(coords.field_71573_c + 2));
                    for (EntityLivingBase entity : entitiesNearEnergyPath) {
                        int shockEnergy;
                        if (!entity.field_70121_D.func_72326_a(box) || (shockEnergy = energyInjected2 - shockAbsorbing) < 0) continue;
                        if (shocks.containsKey(entity)) {
                            int oldValue = (Integer)shocks.get(entity);
                            if (shockEnergy <= oldValue) continue;
                            shocks.put(entity, shockEnergy);
                            continue;
                        }
                        shocks.put(entity, shockEnergy);
                    }
                }
                if (shocks.size() > 0) {
                    for (Map.Entry entry2 : shocks.entrySet()) {
                        EntityLivingBase base = (EntityLivingBase)entry2.getKey();
                        if (this.entityLivingToShockEnergyMap.containsKey(base)) {
                            this.entityLivingToShockEnergyMap.put(base, (Integer)entry2.getValue() + this.entityLivingToShockEnergyMap.get(base));
                            continue;
                        }
                        this.entityLivingToShockEnergyMap.put(base, (Integer)entry2.getValue());
                    }
                }
                if (energyInjected2 >= energyPath3.minInsulationBreakdownEnergy) {
                    for (IEnergyConductor iEnergyConductor : energyPath3.conductors) {
                        if (!((double)energyInjected2 >= iEnergyConductor.getInsulationBreakdownEnergy())) continue;
                        iEnergyConductor.removeInsulation();
                        if (iEnergyConductor.getInsulationEnergyAbsorption() >= (double)energyPath3.minInsulationEnergyAbsorption) continue;
                        energyPath3.minInsulationEnergyAbsorption = (int)iEnergyConductor.getInsulationEnergyAbsorption();
                    }
                }
            }
            if (energyInjected2 < energyPath3.minConductorBreakdownEnergy || IC2.enableIC2EasyMode) continue;
            for (IEnergyConductor energyConductor3 : energyPath3.conductors) {
                if (!((double)energyInjected2 >= energyConductor3.getConductorBreakdownEnergy())) continue;
                energyConductor3.removeConductor();
            }
        }
        return amount;
    }

    private FilteredList<EnergyPath> discover(TileEntity emitter, boolean reverse, int lossLimit) {
        HashMap<TileEntity, EnergyBlockLink> reachedTileEntities = new HashMap<TileEntity, EnergyBlockLink>();
        LinkedList<TileEntity> tileEntitiesToCheck = new LinkedList<TileEntity>();
        tileEntitiesToCheck.add(emitter);
        int totalSinks = 0;
        while (!tileEntitiesToCheck.isEmpty()) {
            TileEntity currentTileEntity = (TileEntity)tileEntitiesToCheck.remove();
            if (currentTileEntity.func_145837_r()) continue;
            double currentLoss = 0.0;
            if (this.registeredTiles.get(EnergyNetLocal.coords(currentTileEntity)) != null && this.registeredTiles.get(EnergyNetLocal.coords(currentTileEntity)) != emitter && reachedTileEntities.containsKey(currentTileEntity)) {
                currentLoss = ((EnergyBlockLink)reachedTileEntities.get((Object)currentTileEntity)).loss;
            }
            List<EnergyTarget> validReceivers = this.getValidReceivers(currentTileEntity, reverse);
            for (EnergyTarget validReceiver : validReceivers) {
                if (validReceiver.tileEntity == emitter) continue;
                double additionalLoss = 0.0;
                if (validReceiver.tileEntity instanceof IEnergyConductor) {
                    additionalLoss = ((IEnergyConductor)validReceiver.tileEntity).getConductionLoss();
                    if (additionalLoss < 1.0E-4) {
                        additionalLoss = 1.0E-4;
                    }
                    if (currentLoss + additionalLoss >= (double)lossLimit) continue;
                }
                if (reachedTileEntities.containsKey(validReceiver.tileEntity) && ((EnergyBlockLink)reachedTileEntities.get((Object)validReceiver.tileEntity)).loss <= currentLoss + additionalLoss) continue;
                reachedTileEntities.put(validReceiver.tileEntity, new EnergyBlockLink(validReceiver.direction, currentLoss + additionalLoss));
                if (validReceiver.tileEntity instanceof IEnergySink) {
                    ++totalSinks;
                }
                if (!(validReceiver.tileEntity instanceof IEnergyConductor)) continue;
                tileEntitiesToCheck.remove(validReceiver.tileEntity);
                tileEntitiesToCheck.add(validReceiver.tileEntity);
            }
        }
        if (totalSinks < 10) {
            totalSinks = 10;
        }
        FilteredList<EnergyPath> energyPaths = new FilteredList<EnergyPath>(totalSinks);
        for (Map.Entry entry : reachedTileEntities.entrySet()) {
            TileEntity tileEntity = (TileEntity)entry.getKey();
            if ((reverse || !(tileEntity instanceof IEnergySink)) && (!reverse || !(tileEntity instanceof IEnergySource))) continue;
            EnergyBlockLink energyBlockLink = (EnergyBlockLink)entry.getValue();
            EnergyPath energyPath = new EnergyPath();
            energyPath.loss = energyBlockLink.loss > 0.1 ? energyBlockLink.loss : 0.1;
            energyPath.target = tileEntity;
            energyPath.targetDirection = energyBlockLink.direction;
            if (!reverse && emitter instanceof IEnergySource) {
                while ((tileEntity = EnergyNet.instance.getNeighbor(tileEntity, energyBlockLink.direction.toForgeDirection())) != emitter && tileEntity instanceof IEnergyConductor) {
                    IEnergyConductor energyConductor = (IEnergyConductor)tileEntity;
                    if (tileEntity.field_145851_c < energyPath.minX) {
                        energyPath.minX = tileEntity.field_145851_c;
                    }
                    if (tileEntity.field_145848_d < energyPath.minY) {
                        energyPath.minY = tileEntity.field_145848_d;
                    }
                    if (tileEntity.field_145849_e < energyPath.minZ) {
                        energyPath.minZ = tileEntity.field_145849_e;
                    }
                    if (tileEntity.field_145851_c > energyPath.maxX) {
                        energyPath.maxX = tileEntity.field_145851_c;
                    }
                    if (tileEntity.field_145848_d > energyPath.maxY) {
                        energyPath.maxY = tileEntity.field_145848_d;
                    }
                    if (tileEntity.field_145849_e > energyPath.maxZ) {
                        energyPath.maxZ = tileEntity.field_145849_e;
                    }
                    energyPath.conductors.add(energyConductor);
                    if (energyConductor.getInsulationEnergyAbsorption() < (double)energyPath.minInsulationEnergyAbsorption) {
                        energyPath.minInsulationEnergyAbsorption = (int)energyConductor.getInsulationEnergyAbsorption();
                    }
                    if (energyConductor.getInsulationBreakdownEnergy() < (double)energyPath.minInsulationBreakdownEnergy) {
                        energyPath.minInsulationBreakdownEnergy = (int)energyConductor.getInsulationBreakdownEnergy();
                    }
                    if (energyConductor.getConductorBreakdownEnergy() < (double)energyPath.minConductorBreakdownEnergy) {
                        energyPath.minConductorBreakdownEnergy = (int)energyConductor.getConductorBreakdownEnergy();
                    }
                    if ((energyBlockLink = (EnergyBlockLink)reachedTileEntities.get(tileEntity)) != null) continue;
                    IC2.platform.displayError("An energy network pathfinding entry is corrupted.\nThis could happen due to incorrect Minecraft behavior or a bug.\n\n(Technical information: energyBlockLink, tile entities below)\nE: " + emitter + " (" + emitter.field_145851_c + "," + emitter.field_145848_d + "," + emitter.field_145849_e + ")\nC: " + tileEntity + " (" + tileEntity.field_145851_c + "," + tileEntity.field_145848_d + "," + tileEntity.field_145849_e + ")\nR: " + energyPath.target + " (" + energyPath.target.field_145851_c + "," + energyPath.target.field_145848_d + "," + energyPath.target.field_145849_e + ")");
                }
            }
            energyPaths.add(energyPath);
        }
        return energyPaths;
    }

    public List<TileEntity> discoverTargets(TileEntity emitter, boolean reverse, int lossLimit) {
        FilteredList<EnergyPath> paths = this.discover(emitter, reverse, lossLimit);
        ArrayList<TileEntity> targets = new ArrayList<TileEntity>();
        for (EnergyPath path : paths) {
            targets.add(path.target);
        }
        return targets;
    }

    private List<EnergyTarget> getValidReceivers(TileEntity emitter, boolean reverse) {
        ArrayList<EnergyTarget> validReceivers = new ArrayList<EnergyTarget>();
        for (Direction direction : directions) {
            IEnergyAcceptor receiver;
            IEnergyEmitter sender;
            if (emitter instanceof IMetaDelegate) {
                IMetaDelegate meta = (IMetaDelegate)emitter;
                List<TileEntity> targets = meta.getSubTiles();
                for (TileEntity tile : targets) {
                    IEnergyAcceptor receiver2;
                    IEnergyEmitter sender2;
                    TileEntity target = EnergyNet.instance.getNeighbor(tile, direction.toForgeDirection());
                    if (target == emitter || !(target instanceof IEnergyTile) || !this.registeredTiles.containsKey(EnergyNetLocal.coords(target))) continue;
                    Direction inverseDirection = direction.getInverse();
                    if (reverse) {
                        if (!(emitter instanceof IEnergyAcceptor) || !(target instanceof IEnergyEmitter)) continue;
                        sender2 = (IEnergyEmitter)target;
                        receiver2 = (IEnergyAcceptor)emitter;
                        if (!sender2.emitsEnergyTo(emitter, inverseDirection.toForgeDirection()) || !receiver2.acceptsEnergyFrom(target, direction.toForgeDirection())) continue;
                        validReceivers.add(new EnergyTarget(target, inverseDirection));
                        continue;
                    }
                    if (!(emitter instanceof IEnergyEmitter) || !(target instanceof IEnergyAcceptor)) continue;
                    sender2 = (IEnergyEmitter)emitter;
                    receiver2 = (IEnergyAcceptor)target;
                    if (!sender2.emitsEnergyTo(target, direction.toForgeDirection()) || !receiver2.acceptsEnergyFrom(emitter, inverseDirection.toForgeDirection())) continue;
                    validReceivers.add(new EnergyTarget(target, inverseDirection));
                }
                continue;
            }
            TileEntity target = EnergyNet.instance.getNeighbor(emitter, direction.toForgeDirection());
            if (!(target instanceof IEnergyTile) || !this.registeredTiles.containsKey(EnergyNetLocal.coords(target))) continue;
            Direction inverseDirection = direction.getInverse();
            if (reverse) {
                if (!(emitter instanceof IEnergyAcceptor) || !(target instanceof IEnergyEmitter)) continue;
                sender = (IEnergyEmitter)target;
                receiver = (IEnergyAcceptor)emitter;
                if (!sender.emitsEnergyTo(emitter, inverseDirection.toForgeDirection()) || !receiver.acceptsEnergyFrom(target, direction.toForgeDirection())) continue;
                validReceivers.add(new EnergyTarget(target, inverseDirection));
                continue;
            }
            if (!(emitter instanceof IEnergyEmitter) || !(target instanceof IEnergyAcceptor)) continue;
            sender = (IEnergyEmitter)emitter;
            receiver = (IEnergyAcceptor)target;
            if (!sender.emitsEnergyTo(target, direction.toForgeDirection()) || !receiver.acceptsEnergyFrom(emitter, inverseDirection.toForgeDirection())) continue;
            validReceivers.add(new EnergyTarget(target, inverseDirection));
        }
        return validReceivers;
    }

    private boolean conductorToWeak(EnergyPath path, int energyToSend) {
        if (path.minConductorBreakdownEnergy > energyToSend) {
            return false;
        }
        boolean flag = false;
        for (IEnergyConductor cond : path.conductors) {
            if (!(cond.getConductorBreakdownEnergy() <= (double)energyToSend)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public List<IEnergySource> discoverFirstPathOrSources(TileEntity par1) {
        HashSet<TileEntity> reached = new HashSet<TileEntity>();
        ArrayList<IEnergySource> result = new ArrayList<IEnergySource>();
        LinkedList<TileEntity> workList = new LinkedList<TileEntity>();
        workList.add(par1);
        while (workList.size() > 0) {
            TileEntity tile = (TileEntity)workList.remove();
            if (tile.func_145837_r()) continue;
            List<EnergyTarget> targets = this.getValidReceivers(tile, true);
            for (int i = 0; i < targets.size(); ++i) {
                TileEntity target = targets.get((int)i).tileEntity;
                if (target == par1 || reached.contains(target)) continue;
                reached.add(target);
                if (target instanceof IEnergySource) {
                    result.add((IEnergySource)target);
                }
                if (!(target instanceof IEnergyConductor)) continue;
                workList.add(target);
            }
        }
        return result;
    }

    public static ChunkCoordinates coords(TileEntity par1) {
        if (par1 == null) {
            return null;
        }
        return new ChunkCoordinates(par1.field_145851_c, par1.field_145848_d, par1.field_145849_e);
    }

    void addPacket(EnergyPath link, int energy) {
        EnergyPacket totalPackets;
        if (link.backupEnergyPackets.size() > 0) {
            link.backupEnergyPackets = new HashMap();
        }
        if ((totalPackets = link.totalEnergyPackets.get(energy)) == null) {
            totalPackets = new EnergyPacket();
            link.totalEnergyPackets.put(energy, totalPackets);
        }
        totalPackets.add();
        EnergyPacket mesurePackets = link.mesuredEnergyPackets.get(energy);
        if (mesurePackets == null) {
            mesurePackets = new EnergyPacket();
            link.totalEnergyPackets.put(energy, mesurePackets);
        }
        mesurePackets.add();
    }

    private void addPackets(Map<Integer, EnergyPacket> input, Map<Integer, EnergyPacket> ref) {
        for (Map.Entry<Integer, EnergyPacket> entry : ref.entrySet()) {
            int key = entry.getKey();
            EnergyPacket result = input.get(key);
            if (result == null) {
                result = new EnergyPacket();
                input.put(key, result);
            }
            result.combine(entry.getValue());
        }
    }

    public void onTickStart() {
        for (Map.Entry<EntityLivingBase, Integer> entry : this.entityLivingToShockEnergyMap.entrySet()) {
            EntityLivingBase target = entry.getKey();
            int damage = (entry.getValue() + 63) / 64;
            if (!target.func_70089_S() || damage <= 0) continue;
            target.func_70097_a((DamageSource)IC2DamageSource.electricity, (float)damage);
        }
        this.entityLivingToShockEnergyMap.clear();
    }

    public void onTickEnd() {
        if (this.unloading.hasWork()) {
            this.energySourceToEnergyPathMap.clearSources(this.unloading.getWork());
            List<ChunkCoordinates> coords = this.unloading.getWorkEnd();
            for (ChunkCoordinates coord : coords) {
                this.registeredTiles.remove(coord);
                this.update(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c);
            }
            this.unloading.clear();
        }
        if (this.waitingList.hasWork()) {
            List<TileEntity> tiles = this.waitingList.getPathTiles();
            for (TileEntity tile : tiles) {
                List<IEnergySource> sources = this.discoverFirstPathOrSources(tile);
                if (sources.size() <= 0) continue;
                this.energySourceToEnergyPathMap.removeAll(sources);
            }
            this.waitingList.clear();
        }
        Iterator<Map.Entry<ChunkCoordinates, IEnergySource>> iter = new LinkedHashMap<ChunkCoordinates, IEnergySource>(this.sources).entrySet().iterator();
        int z = 0;
        while (iter.hasNext()) {
            int offer;
            IEnergySource source;
            Map.Entry<ChunkCoordinates, IEnergySource> entry = iter.next();
            if (entry != null && this.sources.containsKey(entry.getKey()) && (source = entry.getValue()) != null && (offer = (int)source.getOfferedEnergy()) >= 1) {
                if (source instanceof IMultiEnergySource && ((IMultiEnergySource)source).sendMultibleEnergyPackets()) {
                    int removed;
                    IMultiEnergySource multi = (IMultiEnergySource)source;
                    int counts = multi.getMultibleEnergyPacketAmount();
                    for (int i = 0; i < counts && (offer = (int)source.getOfferedEnergy()) >= 1 && (removed = offer - this.emitEnergyFrom(entry.getKey(), source, offer)) > 0; ++i) {
                        source.drawEnergy(removed);
                    }
                } else {
                    int removed = offer - this.emitEnergyFrom(entry.getKey(), source, offer);
                    if (removed > 0) {
                        source.drawEnergy(removed);
                    }
                }
            }
            ++z;
        }
    }

    public void explodeTiles(IEnergySink sink) {
        this.removeTile((TileEntity)sink);
        if (sink instanceof IMetaDelegate) {
            IMetaDelegate meta = (IMetaDelegate)((Object)sink);
            for (TileEntity tile : meta.getSubTiles()) {
                this.explodeMachineAt(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
            }
        } else {
            this.explodeMachineAt(((TileEntity)sink).field_145851_c, ((TileEntity)sink).field_145848_d, ((TileEntity)sink).field_145849_e);
        }
    }

    public TileEntity getTileEntity(int x, int y, int z) {
        ChunkCoordinates coords = new ChunkCoordinates(x, y, z);
        if (this.registeredTiles.containsKey(coords)) {
            return (TileEntity)this.registeredTiles.get(coords);
        }
        return null;
    }

    public NodeStats getNodeStats(TileEntity tile) {
        double emitted = this.getTotalEnergyEmitted(tile);
        double received = this.getTotalEnergySunken(tile);
        double volt = Math.max(EnergyNet.instance.getTierFromPower(emitted), EnergyNet.instance.getTierFromPower(received));
        return new NodeStats(received, emitted, volt);
    }

    void explodeMachineAt(int x, int y, int z) {
        this.world.func_147468_f(x, y, z);
        ExplosionIC2 explosion = new ExplosionIC2(this.world, null, 0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z, 2.5f, 0.75f, 0.75f);
        explosion.doExplosion();
    }

    void update(int x, int y, int z) {
        for (ForgeDirection dir : ForgeDirection.values()) {
            if (!this.world.func_72899_e(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) continue;
            this.world.func_147460_e(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, Blocks.field_150350_a);
        }
    }

    public void onUnload() {
        this.energySourceToEnergyPathMap.clear();
        this.registeredTiles.clear();
        this.sources.clear();
        this.entityLivingToShockEnergyMap.clear();
        this.unloading.clear();
        this.waitingList.clear();
    }

    public List<AxisAlignedBB> getBoxes() {
        List<BoundingBox> boxes = this.energySourceToEnergyPathMap.getBoxes();
        HashSet<AxisAlignedBB> result = new HashSet<AxisAlignedBB>();
        for (BoundingBox box : boxes) {
            result.add(box.toAxis());
        }
        return new ArrayList<AxisAlignedBB>(result);
    }

    static class BoundingBox {
        int minX;
        int minY;
        int minZ;
        int maxX;
        int maxY;
        int maxZ;
        Set<IEnergyConductor> conductors = new HashSet<IEnergyConductor>();
        Set<IEnergySink> sink = new HashSet<IEnergySink>();

        public BoundingBox(EnergyPath par1) {
            this.minX = par1.minX;
            this.minY = par1.minY;
            this.minZ = par1.minZ;
            this.maxX = par1.maxX;
            this.maxY = par1.maxY;
            this.maxZ = par1.maxZ;
        }

        public BoundingBox(EnergyPath par1, IEnergySource par2) {
            this.minX = par1.minX;
            this.minY = par1.minY;
            this.minZ = par1.minZ;
            this.maxX = par1.maxX;
            this.maxY = par1.maxY;
            this.maxZ = par1.maxZ;
            TileEntity tile = (TileEntity)par2;
            if (tile.field_145851_c < this.minX) {
                this.minX = tile.field_145851_c;
            }
            if (tile.field_145848_d < this.minY) {
                this.minY = tile.field_145848_d;
            }
            if (tile.field_145849_e < this.minZ) {
                this.minZ = tile.field_145849_e;
            }
            if (tile.field_145851_c > this.maxX) {
                this.maxX = tile.field_145851_c;
            }
            if (tile.field_145848_d > this.maxY) {
                this.maxY = tile.field_145848_d;
            }
            if (tile.field_145849_e > this.maxZ) {
                this.maxZ = tile.field_145849_e;
            }
            tile = par1.target;
            if (tile.field_145851_c < this.minX) {
                this.minX = tile.field_145851_c;
            }
            if (tile.field_145848_d < this.minY) {
                this.minY = tile.field_145848_d;
            }
            if (tile.field_145849_e < this.minZ) {
                this.minZ = tile.field_145849_e;
            }
            if (tile.field_145851_c > this.maxX) {
                this.maxX = tile.field_145851_c;
            }
            if (tile.field_145848_d > this.maxY) {
                this.maxY = tile.field_145848_d;
            }
            if (tile.field_145849_e > this.maxZ) {
                this.maxZ = tile.field_145849_e;
            }
        }

        public BoundingBox(List<ChunkCoordinates> coords, EnergyNetLocal local) {
            this.minX = Integer.MAX_VALUE;
            this.minY = Integer.MAX_VALUE;
            this.minZ = Integer.MAX_VALUE;
            this.maxX = Integer.MIN_VALUE;
            this.maxY = Integer.MIN_VALUE;
            this.maxZ = Integer.MIN_VALUE;
            for (ChunkCoordinates coord : coords) {
                TileEntity tile;
                if (this.minX > coord.field_71574_a) {
                    this.minX = coord.field_71574_a;
                }
                if (this.minY > coord.field_71572_b) {
                    this.minY = coord.field_71572_b;
                }
                if (this.minZ > coord.field_71573_c) {
                    this.minZ = coord.field_71573_c;
                }
                if (this.maxX < coord.field_71574_a) {
                    this.maxX = coord.field_71574_a;
                }
                if (this.maxY < coord.field_71572_b) {
                    this.maxY = coord.field_71572_b;
                }
                if (this.maxZ < coord.field_71573_c) {
                    this.maxZ = coord.field_71573_c;
                }
                if ((tile = local.getTileEntity(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c)) instanceof IEnergySink) {
                    this.sink.add((IEnergySink)tile);
                }
                if (!(tile instanceof IEnergyConductor)) continue;
                this.conductors.add((IEnergyConductor)tile);
            }
        }

        public boolean intersectsWith(BoundingBox par1) {
            return !(par1.maxX < this.minX && par1.minX > this.maxX || par1.maxY < this.minY && par1.minY > this.maxY || par1.maxZ < this.minZ && par1.minZ > this.maxZ);
        }

        public boolean intersectsWith(TileEntity tile) {
            return !(tile.field_145851_c < this.minX && tile.field_145851_c > this.maxX || tile.field_145848_d < this.minY && tile.field_145848_d > this.maxY || tile.field_145849_e < this.minZ && tile.field_145849_e > this.maxZ);
        }

        public AxisAlignedBB toAxis() {
            return AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ).func_72321_a(1.0, 1.0, 1.0);
        }

        public String toString() {
            return "Min: " + this.minX + ":" + this.minY + ":" + this.minZ + " Max: " + this.maxX + ":" + this.maxY + ":" + this.maxZ;
        }
    }

    static class EnergyPacket {
        long count;

        EnergyPacket() {
        }

        public void clear() {
            this.count = 0L;
        }

        public void add() {
            this.add(1L);
        }

        public void add(long amount) {
            this.count += amount;
        }

        public void combine(EnergyPacket other) {
            this.count += other.count;
        }

        public long getAmount() {
            return this.count;
        }
    }

    class UnloadLogic {
        List<ChunkCoordinates> coords = new FilteredList<ChunkCoordinates>();

        UnloadLogic() {
        }

        public boolean contains(ChunkCoordinates par1) {
            return this.coords.contains(par1);
        }

        public void add(ChunkCoordinates par1) {
            this.coords.add(par1);
        }

        public void remove(ChunkCoordinates par1) {
            this.coords.remove(par1);
        }

        public void clear() {
            this.coords.clear();
        }

        public List<ChunkCoordinates> getAll() {
            return this.coords;
        }
    }

    class UnloadingList {
        List<UnloadLogic> logics = new ArrayList<UnloadLogic>();

        UnloadingList() {
        }

        public void onLoaded(ChunkCoordinates coords) {
            int i;
            if (this.logics.isEmpty()) {
                return;
            }
            ArrayList<ChunkCoordinates> toRecalculate = new ArrayList<ChunkCoordinates>();
            for (i = 0; i < this.logics.size(); ++i) {
                UnloadLogic logic = this.logics.get(i);
                if (!logic.contains(coords)) continue;
                logic.remove(coords);
                toRecalculate.addAll(logic.getAll());
                this.logics.remove(i--);
            }
            for (i = 0; i < toRecalculate.size(); ++i) {
                ChunkCoordinates coord = (ChunkCoordinates)toRecalculate.get(i);
                TileEntity tile = EnergyNetLocal.this.getTileEntity(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c);
                if (tile == null) continue;
                this.onUnloaded(EnergyNetLocal.this.getValidReceivers(tile, true), coord, tile);
            }
        }

        public void onUnloaded(List<EnergyTarget> around, ChunkCoordinates coords, TileEntity tile) {
            if (around.isEmpty() || this.logics.isEmpty()) {
                this.createNewPath(coords);
                return;
            }
            boolean found = false;
            ArrayList<UnloadLogic> combine = new ArrayList<UnloadLogic>();
            block0: for (int i = 0; i < this.logics.size(); ++i) {
                UnloadLogic logic = this.logics.get(i);
                if (logic.contains(coords)) {
                    found = true;
                    if (!(tile instanceof IEnergyConductor)) continue;
                    combine.add(logic);
                    continue;
                }
                for (EnergyTarget target : around) {
                    if (logic.contains(coords)) {
                        found = true;
                        if (!(tile instanceof IEnergyConductor)) continue block0;
                        combine.add(logic);
                        continue block0;
                    }
                    if (!logic.contains(EnergyNetLocal.coords(target.tileEntity))) continue;
                    found = true;
                    logic.add(coords);
                    if (!(target.tileEntity instanceof IEnergyConductor)) continue block0;
                    combine.add(logic);
                    continue block0;
                }
            }
            if (combine.size() > 1 && tile instanceof IEnergyConductor) {
                UnloadLogic newLogic = new UnloadLogic();
                for (UnloadLogic logic : combine) {
                    this.logics.remove(logic);
                    for (ChunkCoordinates toMove : logic.getAll()) {
                        if (newLogic.contains(toMove)) continue;
                        newLogic.add(toMove);
                    }
                    logic.clear();
                }
                this.logics.add(newLogic);
            }
            if (!found) {
                this.createNewPath(coords);
            }
        }

        public void createNewPath(ChunkCoordinates coords) {
            UnloadLogic logic = new UnloadLogic();
            logic.add(coords);
            this.logics.add(logic);
        }

        public boolean contains(ChunkCoordinates coords) {
            if (this.logics.isEmpty()) {
                return false;
            }
            for (UnloadLogic logic : this.logics) {
                if (!logic.contains(coords)) continue;
                return true;
            }
            return false;
        }

        public void clear() {
            if (this.logics.isEmpty()) {
                return;
            }
            for (int i = 0; i < this.logics.size(); ++i) {
                this.logics.get(i).clear();
            }
            this.logics.clear();
        }

        public List<BoundingBox> getWork() {
            ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>(this.logics.size());
            for (UnloadLogic logic : this.logics) {
                boxes.add(new BoundingBox(logic.getAll(), EnergyNetLocal.this));
            }
            return boxes;
        }

        public List<ChunkCoordinates> getWorkEnd() {
            HashSet<ChunkCoordinates> coords = new HashSet<ChunkCoordinates>();
            for (UnloadLogic logic : this.logics) {
                coords.addAll(logic.getAll());
            }
            return new ArrayList<ChunkCoordinates>(coords);
        }

        public boolean hasWork() {
            return this.logics.size() > 0;
        }
    }

    static class PathLogic {
        List<TileEntity> tiles = new FilteredList<TileEntity>();

        PathLogic() {
        }

        public boolean contains(TileEntity par1) {
            return this.tiles.contains(par1);
        }

        public void add(TileEntity par1) {
            this.tiles.add(par1);
        }

        public void remove(TileEntity par1) {
            this.tiles.remove(par1);
        }

        public void clear() {
            this.tiles.clear();
        }

        public TileEntity getRepresentingTile() {
            if (this.tiles.isEmpty()) {
                return null;
            }
            return this.tiles.get(0);
        }
    }

    class WaitingList {
        List<PathLogic> paths = new ArrayList<PathLogic>();

        WaitingList() {
        }

        public void onTileEntityAdded(List<EnergyTarget> around, TileEntity tile) {
            if (around.isEmpty() || this.paths.isEmpty()) {
                this.createNewPath(tile);
                return;
            }
            boolean found = false;
            ArrayList<PathLogic> logics = new ArrayList<PathLogic>();
            block0: for (int i = 0; i < this.paths.size(); ++i) {
                PathLogic logic = this.paths.get(i);
                if (logic.contains(tile)) {
                    found = true;
                    if (!(tile instanceof IEnergyConductor)) continue;
                    logics.add(logic);
                    continue;
                }
                for (EnergyTarget target : around) {
                    if (logic.contains(tile)) {
                        found = true;
                        if (!(tile instanceof IEnergyConductor)) continue block0;
                        logics.add(logic);
                        continue block0;
                    }
                    if (!logic.contains(target.tileEntity)) continue;
                    found = true;
                    logic.add(tile);
                    if (!(target.tileEntity instanceof IEnergyConductor)) continue block0;
                    logics.add(logic);
                    continue block0;
                }
            }
            if (logics.size() > 1 && tile instanceof IEnergyConductor) {
                PathLogic newLogic = new PathLogic();
                for (PathLogic logic : logics) {
                    this.paths.remove(logic);
                    for (TileEntity toMove : logic.tiles) {
                        if (newLogic.contains(toMove)) continue;
                        newLogic.add(toMove);
                    }
                    logic.clear();
                }
                this.paths.add(newLogic);
            }
            if (!found) {
                this.createNewPath(tile);
            }
        }

        public void onTileEntityRemoved(TileEntity par1) {
            int i;
            if (this.paths.isEmpty()) {
                return;
            }
            ArrayList<TileEntity> toRecalculate = new ArrayList<TileEntity>();
            for (i = 0; i < this.paths.size(); ++i) {
                PathLogic logic = this.paths.get(i);
                if (!logic.contains(par1)) continue;
                logic.remove(par1);
                toRecalculate.addAll(logic.tiles);
                this.paths.remove(i--);
            }
            for (i = 0; i < toRecalculate.size(); ++i) {
                TileEntity tile = (TileEntity)toRecalculate.get(i);
                this.onTileEntityAdded(EnergyNetLocal.this.getValidReceivers(tile, true), tile);
            }
        }

        public void createNewPath(TileEntity par1) {
            PathLogic logic = new PathLogic();
            logic.add(par1);
            this.paths.add(logic);
        }

        public void clear() {
            if (this.paths.isEmpty()) {
                return;
            }
            for (int i = 0; i < this.paths.size(); ++i) {
                this.paths.get(i).clear();
            }
            this.paths.clear();
        }

        public boolean hasWork() {
            return this.paths.size() > 0;
        }

        public List<TileEntity> getPathTiles() {
            ArrayList<TileEntity> tiles = new ArrayList<TileEntity>();
            for (int i = 0; i < this.paths.size(); ++i) {
                TileEntity tile = this.paths.get(i).getRepresentingTile();
                if (tile == null) continue;
                tiles.add(tile);
            }
            return tiles;
        }
    }

    static class EnergyPathMap {
        Map<IEnergySource, FilteredList<EnergyPath>> senderPath = new HashMap<IEnergySource, FilteredList<EnergyPath>>();
        Map<EnergyPath, IEnergySource> pathToSender = new HashMap<EnergyPath, IEnergySource>();

        EnergyPathMap() {
        }

        public void put(IEnergySource par1, FilteredList<EnergyPath> par2) {
            this.senderPath.put(par1, par2);
            for (int i = 0; i < par2.size(); ++i) {
                this.pathToSender.put((EnergyPath)par2.get(i), par1);
            }
        }

        public boolean containsKey(Object par1) {
            return this.senderPath.containsKey(par1);
        }

        public List<EnergyPath> get(Object par1) {
            return this.senderPath.get(par1);
        }

        public void remove(Object par1) {
            List paths = this.senderPath.remove(par1);
            if (paths != null) {
                for (int i = 0; i < paths.size(); ++i) {
                    this.pathToSender.remove(paths.get(i));
                }
            }
        }

        public void removeAll(List<IEnergySource> par1) {
            for (int i = 0; i < par1.size(); ++i) {
                this.remove(par1.get(i));
            }
        }

        public void clearSources(List<BoundingBox> boxes) {
            FilteredList<IEnergySource> sources = new FilteredList<IEnergySource>();
            block0: for (Map.Entry<EnergyPath, IEnergySource> entry : this.pathToSender.entrySet()) {
                if (sources.contains(entry.getValue())) continue;
                EnergyPath path = entry.getKey();
                BoundingBox pathBox = new BoundingBox(path, entry.getValue());
                for (BoundingBox box : boxes) {
                    if (!pathBox.intersectsWith(box)) continue;
                    if (box.sink.contains(path.target)) {
                        sources.add(entry.getValue());
                        continue block0;
                    }
                    boolean found = false;
                    for (IEnergyConductor con : box.conductors) {
                        if (!path.conductors.contains(con)) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    sources.add(entry.getValue());
                    continue block0;
                }
            }
            this.removeAll(sources);
        }

        public List<EnergyPath> getPaths(IEnergyAcceptor par1) {
            FilteredList<EnergyPath> paths = new FilteredList<EnergyPath>();
            for (IEnergySource source : this.getSources(par1)) {
                if (!this.containsKey(source)) continue;
                paths.addAll(this.get(source));
            }
            return paths;
        }

        public List<IEnergySource> getSources(IEnergyAcceptor par1) {
            FilteredList<IEnergySource> source = new FilteredList<IEnergySource>();
            for (Map.Entry<EnergyPath, IEnergySource> entry : this.pathToSender.entrySet()) {
                EnergyPath path;
                BoundingBox box;
                if (source.contains(entry.getValue()) || !(box = new BoundingBox(path = entry.getKey(), entry.getValue())).intersectsWith((TileEntity)par1) || (!(par1 instanceof IEnergyConductor) || !path.conductors.contains(par1)) && (!(par1 instanceof IEnergySink) || path.target != par1)) continue;
                source.add(entry.getValue());
            }
            return source;
        }

        public void clear() {
            this.senderPath.clear();
            this.pathToSender.clear();
        }

        public List<BoundingBox> getBoxes() {
            HashSet<BoundingBox> boxes = new HashSet<BoundingBox>();
            for (Map.Entry<EnergyPath, IEnergySource> path : this.pathToSender.entrySet()) {
                boxes.add(new BoundingBox(path.getKey(), path.getValue()));
            }
            return new ArrayList<BoundingBox>(boxes);
        }
    }

    static class EnergyPath {
        TileEntity target = null;
        Direction targetDirection;
        List<IEnergyConductor> conductors = new FilteredList<IEnergyConductor>();
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        double loss = 0.0;
        int minInsulationEnergyAbsorption = Integer.MAX_VALUE;
        int minInsulationBreakdownEnergy = Integer.MAX_VALUE;
        int minConductorBreakdownEnergy = Integer.MAX_VALUE;
        long totalEnergyConducted = 0L;
        HashMap<Integer, EnergyPacket> totalEnergyPackets = new HashMap();
        HashMap<Integer, EnergyPacket> mesuredEnergyPackets = new HashMap();
        HashMap<Integer, EnergyPacket> backupEnergyPackets = new HashMap();

        EnergyPath() {
        }
    }

    static class EnergyBlockLink {
        Direction direction;
        double loss;

        EnergyBlockLink(Direction direction, double loss) {
            this.direction = direction;
            this.loss = loss;
        }
    }

    static class EnergyTarget {
        TileEntity tileEntity;
        Direction direction;

        EnergyTarget(TileEntity tileEntity, Direction direction) {
            this.tileEntity = tileEntity;
            this.direction = direction;
        }
    }
}

