/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergySourceInfo;
import ic2.api.energy.tile.IEnergyTile;
import ic2.core.IC2;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;

public class EnergyTransferList {
    public static Map<String, Integer> values = new HashMap<String, Integer>();
    public static Map<String, Integer> acceptingOverride = new HashMap<String, Integer>();

    public EnergyTransferList() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        EnergyTransferList.init();
    }

    public static int getMaxEnergy(IEnergySource par1, int currentMax) {
        if (par1 instanceof IEnergySourceInfo) {
            IEnergySourceInfo info = (IEnergySourceInfo)par1;
            return info.getMaxEnergyAmount();
        }
        if (!values.containsKey(par1.getClass().getSimpleName())) {
            values.put(par1.getClass().getSimpleName(), currentMax);
        }
        if (values.containsKey(par1.getClass().getSimpleName())) {
            int newValue = values.get(par1.getClass().getSimpleName());
            if (newValue < currentMax) {
                values.put(par1.getClass().getSimpleName(), currentMax);
            }
            currentMax = values.get(par1.getClass().getSimpleName());
        }
        return currentMax;
    }

    public static void initIEnergySource(IEnergySource par1) {
        if (!values.containsKey(par1.getClass().getSimpleName())) {
            values.put(par1.getClass().getSimpleName(), 10);
        }
    }

    public static boolean hasOverrideInput(IEnergySink par1) {
        if (par1 == null) {
            return false;
        }
        Class<?> clz = par1.getClass();
        return acceptingOverride.containsKey(clz.getSimpleName());
    }

    public static int getOverrideInput(IEnergySink par1) {
        if (par1 == null || !EnergyTransferList.hasOverrideInput(par1)) {
            return 0;
        }
        Class<?> clz = par1.getClass();
        return acceptingOverride.get(clz.getSimpleName());
    }

    public static void init() {
        HashMap<String, Integer> list = new HashMap<String, Integer>();
        list.put("TileEntityEnergyOMat", 32);
        list.put("TileEntityNuclearReactorElectric", 1512 * IC2.energyGeneratorNuclear);
        list.put("TileEntityReactorChamberElectric", 240 * IC2.energyGeneratorNuclear);
        list.put("TileEntityWindGenerator", 10);
        list.put("TileEntityGenerator", IC2.energyGeneratorBase);
        list.put("TileEntityGeoGenerator", IC2.energyGeneratorGeo);
        list.put("TileEntitySolarGenerator", 1);
        list.put("TileEntityWaterGenerator", 2);
        list.put("TileEntityElectricBatBox", 32);
        list.put("TileEntityTransformerMV", 512);
        list.put("TileEntityTransformerLV", 128);
        list.put("TileEntityTransformerHV", 2048);
        list.put("TileEntityElectricMFSU", 512);
        list.put("TileEntityElectricMFE", 128);
        list.put("TileIC2MultiEmitterDelegate", 200);
        values.putAll(list);
        acceptingOverride.put("TileEntityMolecularTransformer", 4096);
    }

    @SubscribeEvent
    public void onEnergyInit(EnergyTileLoadEvent event) {
        IEnergyTile tile = event.energyTile;
        if (tile != null && tile instanceof IEnergySource && !(tile instanceof IEnergySourceInfo)) {
            EnergyTransferList.initIEnergySource((IEnergySource)event.energyTile);
        }
    }
}

