/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.block.wiring.TileEntityChargePad;
import ic2.core.block.wiring.TileEntityElectricMFE;
import ic2.core.block.wiring.TileEntityElectricMFSU;
import ic2.core.item.ItemIC2;
import ic2.core.util.IExtraData;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemChargePadUpgrade
extends ItemIC2
implements IExtraData {
    public ItemChargePadUpgrade(int index) {
        super(index);
        this.func_77627_a(true);
        this.func_77625_d(64);
        this.func_77655_b("itemChargePadUpgrade");
    }

    public TileEntityChargePad.PadUpgrade getUpgrade(ItemStack par1) {
        int meta = par1.func_77960_j();
        if (meta >= 4 && meta <= 11) {
            return TileEntityChargePad.PadUpgrade.values()[meta -= 4];
        }
        return null;
    }

    @Override
    public void init() {
        Ic2Items.crystalUpgradeKid = new ItemStack((Item)this, 1, 0);
        Ic2Items.mfsUpgradeKid = new ItemStack((Item)this, 1, 1);
        Ic2Items.lapotronicUpgradeKid = new ItemStack((Item)this, 1, 2);
        Ic2Items.fissionUpgradeKid = new ItemStack((Item)this, 1, 3);
        Ic2Items.padUpgradeDamage = new ItemStack((Item)this, 1, 4);
        Ic2Items.padUpgradeDrain = new ItemStack((Item)this, 1, 5);
        Ic2Items.padUpgradeProximity = new ItemStack((Item)this, 1, 6);
        Ic2Items.padUpgradeWideBand = new ItemStack((Item)this, 1, 7);
        Ic2Items.padUpgradeArmorPriorty = new ItemStack((Item)this, 1, 8);
        Ic2Items.padUpgradeBasicFieldUpgrade = new ItemStack((Item)this, 1, 9);
        Ic2Items.padUpgradeFieldUpgrade = new ItemStack((Item)this, 1, 10);
        Ic2Items.padUpgradeAdvFieldUpgrade = new ItemStack((Item)this, 1, 11);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        return Ic2Icons.getTexture(this.spriteID)[this.iconIndex + par1];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item p_150895_1_, CreativeTabs p_150895_2_, List list) {
        ItemStack stack;
        for (int meta = 0; meta <= Short.MAX_VALUE && this.func_77667_c(stack = new ItemStack((Item)this, 1, meta)) != null; ++meta) {
            list.add(stack);
        }
    }

    public String func_77667_c(ItemStack item) {
        switch (item.func_77960_j()) {
            case 0: {
                return "item.upgradeKit.crystalizor";
            }
            case 1: {
                return "item.upgradeKit.mfs";
            }
            case 2: {
                return "item.upgradeKit.lapotronic";
            }
            case 3: {
                return "item.upgradeKit.fission";
            }
            case 4: {
                return "item.padUpgrade.damage";
            }
            case 5: {
                return "item.padUpgrade.drain";
            }
            case 6: {
                return "item.padUpgrade.proximity";
            }
            case 7: {
                return "item.padUpgrade.widebad";
            }
            case 8: {
                return "item.padUpgrade.armorPriority";
            }
            case 9: {
                return "item.padUpgrade.fieldExp1";
            }
            case 10: {
                return "item.padUpgrade.fieldExp2";
            }
            case 11: {
                return "item.padUpgrade.fieldExp3";
            }
        }
        return null;
    }

    @Override
    public EnumRarity func_77613_e(ItemStack stack) {
        TileEntityChargePad.PadUpgrade upgrade = this.getUpgrade(stack);
        if (upgrade != null) {
            return upgrade.isRare ? EnumRarity.uncommon : EnumRarity.common;
        }
        int meta = stack.func_77960_j();
        if (meta == 2 || meta == 3 || meta == 1) {
            return EnumRarity.uncommon;
        }
        return super.func_77613_e(stack);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        int meta = stack.func_77960_j();
        if (meta < 4 && meta != 1) {
            TileEntity tile2 = world.func_147438_o(x, y, z);
            if (tile2 instanceof TileEntityChargePad) {
                TileEntityChargePad pad = (TileEntityChargePad)tile2;
                int newMeta = -1;
                switch (meta) {
                    case 0: {
                        if (pad.type != TileEntityChargePad.ChargePadType.LV) break;
                        newMeta = TileEntityChargePad.ChargePadType.MV.ordinal();
                        break;
                    }
                    case 2: {
                        if (pad.type != TileEntityChargePad.ChargePadType.MV) break;
                        newMeta = TileEntityChargePad.ChargePadType.HV.ordinal();
                        break;
                    }
                    case 3: {
                        if (pad.type != TileEntityChargePad.ChargePadType.HV) break;
                        newMeta = TileEntityChargePad.ChargePadType.Nuclear.ordinal();
                    }
                }
                if (newMeta == -1 || world.field_72995_K) {
                    return !world.field_72995_K;
                }
                if (!IC2.chargePadUpgradeAnySide && ForgeDirection.getOrientation((int)side) != ForgeDirection.DOWN) {
                    IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)"itemInfo.chargePadUpgradeKidwrongSide.name"));
                    return true;
                }
                ItemStack[] itemInv = new ItemStack[pad.inv.func_70302_i_()];
                for (int i = 0; i < itemInv.length; ++i) {
                    itemInv[i] = pad.inv.func_70301_a(i);
                }
                int storedEnergy = pad.storedEnergy;
                if (world.func_147465_d(x, y, z, Block.func_149634_a((Item)Ic2Items.lvChargePad.func_77973_b()), newMeta, 3)) {
                    TileEntity newTile = world.func_147438_o(x, y, z);
                    world.func_147459_d(x, y, z, Block.func_149634_a((Item)Ic2Items.lvChargePad.func_77973_b()));
                    if (newTile instanceof TileEntityChargePad) {
                        int src;
                        if (!player.field_71075_bZ.field_75098_d) {
                            --stack.field_77994_a;
                        }
                        TileEntityChargePad newPad = (TileEntityChargePad)newTile;
                        newPad.inv.func_70299_a(0, itemInv[0]);
                        if (pad.type.getTier() > 1) {
                            newPad.inv.func_70299_a(1, itemInv[1]);
                            newPad.inv.func_70299_a(2, itemInv[2]);
                        }
                        int n = src = pad.type.getTier() > 1 ? 3 : 1;
                        for (int dest = newPad.type.getTier() > 1 ? 3 : 1; src < itemInv.length && dest < newPad.inv.func_70302_i_(); ++src, ++dest) {
                            newPad.inv.func_70299_a(dest, itemInv[src]);
                            itemInv[src] = null;
                        }
                        newPad.setFacing(pad.getFacing());
                        newPad.updateUpgrades();
                        world.func_147471_g(x, y, z);
                        world.func_147459_d(x, y, z, Block.func_149634_a((Item)Ic2Items.lvChargePad.func_77973_b()));
                        newPad.storedEnergy = storedEnergy;
                        return true;
                    }
                }
            }
        } else if (meta == 1 && (tile = world.func_147438_o(x, y, z)) instanceof TileEntityElectricMFE) {
            TileEntity newTile;
            TileEntityElectricMFE mfe = (TileEntityElectricMFE)tile;
            int stored = mfe.energy;
            ItemStack[] items = mfe.inventory;
            mfe.inventory = new ItemStack[2];
            if (world.field_72995_K) {
                return false;
            }
            if (world.func_147465_d(x, y, z, Block.func_149634_a((Item)Ic2Items.mfsUnit.func_77973_b()), Ic2Items.mfsUnit.func_77960_j(), 3) && (newTile = world.func_147438_o(x, y, z)) instanceof TileEntityElectricMFSU) {
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                TileEntityElectricMFSU mfsu = (TileEntityElectricMFSU)newTile;
                mfsu.inventory = items;
                mfsu.energy = stored;
                mfsu.setFacing(mfe.getFacing());
                world.func_147471_g(x, y, z);
                world.func_147459_d(x, y, z, Block.func_149634_a((Item)Ic2Items.lvChargePad.func_77973_b()));
                return true;
            }
        }
        return super.onItemUseFirst(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }
}

