/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IMachineUpgradeItem;
import ic2.api.tile.IMachine;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.item.HandHeldUpgradeContainer;
import ic2.core.item.IHandHeldInventory;
import ic2.core.item.ItemIC2;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemUpgradeContainer
extends ItemIC2
implements IMachineUpgradeItem,
IHandHeldInventory {
    public ItemUpgradeContainer() {
        super(143);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, EntityPlayer player, List list, boolean adv) {
        if (GuiScreen.func_146272_n()) {
            ItemStack[] array = this.getItems(item);
            for (int i = 0; i < array.length; ++i) {
                ItemStack stack = array[i];
                if (stack == null) continue;
                list.add("" + stack.field_77994_a + "x " + stack.func_82833_r());
            }
            return;
        }
        list.add(StatCollector.func_74838_a((String)"itemInfo.upgradeContainerStored.name"));
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (IC2.platform.isSimulating()) {
            IC2.platform.launchGui(entityPlayer, this.getInventory(entityPlayer, itemStack));
        }
        return itemStack;
    }

    @Override
    public int getExtraProcessTime(ItemStack upgrade, IMachine machine) {
        int result = 0;
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            result += item.getExtraProcessTime(stack, machine) * stack.field_77994_a;
        }
        return result;
    }

    @Override
    public double getProcessTimeMultiplier(ItemStack upgrade, IMachine machine) {
        double result = 1.0;
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            result *= Math.pow(item.getProcessTimeMultiplier(stack, machine), stack.field_77994_a);
        }
        return result;
    }

    @Override
    public int getExtraEnergyDemand(ItemStack upgrade, IMachine machine) {
        int result = 0;
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            result += item.getExtraEnergyDemand(stack, machine) * stack.field_77994_a;
        }
        return result;
    }

    @Override
    public double getEnergyDemandMultiplier(ItemStack upgrade, IMachine machine) {
        double result = 1.0;
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            result *= Math.pow(item.getEnergyDemandMultiplier(stack, machine), stack.field_77994_a);
        }
        return result;
    }

    @Override
    public int getExtraEnergyStorage(ItemStack upgrade, IMachine machine) {
        int result = 0;
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            result += item.getExtraEnergyStorage(stack, machine) * stack.field_77994_a;
        }
        return result;
    }

    @Override
    public double getEnergyStorageMultiplier(ItemStack upgrade, IMachine machine) {
        double result = 1.0;
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            result *= Math.pow(item.getEnergyStorageMultiplier(stack, machine), stack.field_77994_a);
        }
        return result;
    }

    @Override
    public int getExtraTier(ItemStack upgrade, IMachine machine) {
        int result = 0;
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            result += item.getExtraTier(stack, machine) * stack.field_77994_a;
        }
        return result;
    }

    @Override
    public boolean onTick(ItemStack upgrade, IMachine machine) {
        boolean flag = false;
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            flag = item.onTick(stack, machine) || flag;
        }
        return flag;
    }

    @Override
    public void onProcessEnd(ItemStack upgrade, IMachine machine, List<ItemStack> results) {
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            item.onProcessEnd(stack, machine, results);
        }
    }

    @Override
    public boolean useRedstoneinverter(ItemStack upgrade, IMachine machine) {
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null || !item.useRedstoneinverter(stack, machine)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onInstalling(ItemStack upgrade, IMachine machine) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        ItemStack[] items = this.getItems(upgrade);
        for (int i = 0; i < items.length; ++i) {
            IMachineUpgradeItem item = this.getItem(items[i]);
            if (item == null) continue;
            IMachine.UpgradeType type = item.getType(items[i]);
            if (!machine.getSupportedTypes().contains((Object)type)) continue;
            ints.add(i);
        }
        for (Integer slot : ints) {
            IMachineUpgradeItem item = this.getItem(items[slot]);
            item.onInstalling(items[slot], machine);
        }
        int[] data = new int[ints.size()];
        for (int i = 0; i < ints.size(); ++i) {
            data[i] = (Integer)ints.get(i);
        }
        this.setValidSlots(upgrade, data);
    }

    @Override
    public float getSoundVolumeMultiplier(ItemStack upgrade, IMachine machine) {
        float result = 1.0f;
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            result = (float)((double)result * Math.pow(item.getEnergyStorageMultiplier(stack, machine), stack.field_77994_a));
        }
        return result;
    }

    public IMachineUpgradeItem getItem(ItemStack par1) {
        if (par1 == null || !(par1.func_77973_b() instanceof IMachineUpgradeItem)) {
            return null;
        }
        return (IMachineUpgradeItem)par1.func_77973_b();
    }

    @Override
    public IMachine.UpgradeType getType(ItemStack par1) {
        return IMachine.UpgradeType.Custom;
    }

    @Override
    public IHasGui getInventory(EntityPlayer p0, ItemStack p1) {
        return new HandHeldUpgradeContainer(p0, p1);
    }

    public void setValidSlots(ItemStack item, int[] par1) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(item);
        nbt.func_74783_a("ValidSlots", par1);
    }

    public int[] getValidSlots(ItemStack item) {
        return StackUtil.getOrCreateNbtData(item).func_74759_k("ValidSlots");
    }

    public ItemStack[] getValidItems(ItemStack par1) {
        int[] validSlots = this.getValidSlots(par1);
        ItemStack[] items = new ItemStack[validSlots.length];
        ItemStack[] possible = this.getItems(par1);
        for (int i = 0; i < validSlots.length; ++i) {
            items[i] = possible[validSlots[i]];
        }
        return items;
    }

    public ItemStack[] getItems(ItemStack par1) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(par1);
        NBTTagList list = nbt.func_150295_c("Items", 10);
        ItemStack[] items = new ItemStack[3];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound slotNBT = list.func_150305_b(i);
            byte slot = slotNBT.func_74771_c("Slot");
            if (slot < 0 || slot >= 3) continue;
            items[slot] = ItemStack.func_77949_a((NBTTagCompound)slotNBT);
        }
        return items;
    }
}

