/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricTool;
import ic2.core.IC2;
import ic2.core.IC2DamageSource;
import ic2.core.Ic2Icons;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.ISpecialArmor;

public abstract class ItemArmorElectric
extends ItemArmor
implements ISpecialArmor,
IElectricItem,
IElectricTool {
    public int maxCharge;
    public int transferLimit;
    public int tier;
    private int iconIndex;

    public ItemArmorElectric(int spriteIndex, int armorRendering, int armorType, int maxCharge, int transferLimit, int tier) {
        super(ItemArmor.ArmorMaterial.DIAMOND, armorRendering, armorType);
        this.iconIndex = spriteIndex;
        this.maxCharge = maxCharge;
        this.tier = tier;
        this.transferLimit = transferLimit;
        this.func_77656_e(27);
        this.func_77625_d(1);
        this.func_77637_a(IC2.tabIC2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        return Ic2Icons.getTexture("i2")[this.iconIndex];
    }

    public boolean isRepairable() {
        return false;
    }

    public abstract String getTextureName();

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        String name = this.getTextureName();
        if (slot == 2) {
            return "ic2:textures/models/armor/" + name + "_2.png";
        }
        return "ic2:textures/models/armor/" + name + "_1.png";
    }

    public void func_150895_a(Item i, CreativeTabs tabs, List itemList) {
        ItemStack charged = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(charged, 2.147483647E9, Integer.MAX_VALUE, true, false);
        itemList.add(charged);
        itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    public String getTextureFile() {
        return "/ic2/sprites/item_0.png";
    }

    public boolean isBlockingEverything() {
        return false;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c() && !this.isBlockingEverything()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        if (source == IC2DamageSource.electricity && IC2.enableSpecialElectricArmor) {
            if (!ItemArmorElectric.hasElectricBoots(player)) {
                return new ISpecialArmor.ArmorProperties(0, 1.0, this.maxCharge - (int)ElectricItem.manager.getCharge(armor));
            }
            return new ISpecialArmor.ArmorProperties(0, 1.0, this.maxCharge);
        }
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        double energyPerDamage = this.getEnergyPerDamage();
        int damageLimit = (int)(energyPerDamage > 0.0 ? 25.0 * ElectricItem.manager.discharge(armor, 2.147483647E9, Integer.MAX_VALUE, true, false, true) / (energyPerDamage *= (double)IC2.electricSuitEnergyCostModifier) : 0.0);
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio *= (double)IC2.electricSuitAbsorbtionScale, damageLimit);
    }

    public static boolean hasElectricBoots(EntityLivingBase par1) {
        ItemStack item;
        if (par1 instanceof EntityPlayer && (item = ((EntityPlayer)par1).field_71071_by.func_70440_f(0)) != null && item.func_77973_b() instanceof IElectricItem) {
            return !par1.field_70170_p.func_147437_c(MathHelper.func_76128_c((double)par1.field_70165_t), MathHelper.func_76128_c((double)(par1.field_70163_u - (double)0.2f - (double)par1.field_70129_M)), MathHelper.func_76128_c((double)par1.field_70161_v));
        }
        item = par1.func_71124_b(1);
        if (item != null && item.func_77973_b() instanceof IElectricItem) {
            return !par1.field_70170_p.func_147437_c(MathHelper.func_76128_c((double)par1.field_70165_t), MathHelper.func_76128_c((double)(par1.field_70163_u - (double)0.2f - (double)par1.field_70129_M)), MathHelper.func_76128_c((double)par1.field_70161_v));
        }
        return false;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio() * (double)IC2.electricSuitAbsorbtionScale);
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (source == IC2DamageSource.electricity && IC2.enableSpecialElectricArmor) {
            ElectricItem.manager.charge(stack, damage, Integer.MAX_VALUE, true, false);
            return;
        }
        ElectricItem.manager.use(stack, damage * (int)((float)this.getEnergyPerDamage() * IC2.electricSuitAbsorbtionScale), entity);
    }

    @Override
    public boolean canProvideEnergy(ItemStack par1) {
        return false;
    }

    public boolean func_77616_k(ItemStack p_77616_1_) {
        return false;
    }

    @Override
    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    @Override
    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    @Override
    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    @Override
    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    @Override
    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public abstract double getDamageAbsorptionRatio();

    public abstract int getEnergyPerDamage();

    private double getBaseAbsorptionRatio() {
        switch (this.field_77881_a) {
            case 0: {
                return 0.3;
            }
            case 1: {
                return 0.4;
            }
            case 2: {
                return 0.3;
            }
            case 3: {
                return 0.15;
            }
        }
        return 0.0;
    }

    @Override
    public EnumEnchantmentType getType(ItemStack item) {
        switch (this.field_77881_a) {
            case 0: {
                return EnumEnchantmentType.armor_head;
            }
            case 1: {
                return EnumEnchantmentType.armor_torso;
            }
            case 2: {
                return EnumEnchantmentType.armor_legs;
            }
            case 3: {
                return EnumEnchantmentType.armor_feet;
            }
        }
        return EnumEnchantmentType.armor;
    }

    @Override
    public boolean isSpecialSupport(ItemStack item, Enchantment ench) {
        return false;
    }

    @Override
    public boolean isExcluded(ItemStack item, Enchantment ench) {
        return ench == Enchantment.field_92091_k;
    }
}

