/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.crops.Crops;
import ic2.core.IC2;
import ic2.core.block.TileEntityCrop;
import ic2.core.item.block.ItemBlockRare;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemBlockCrop
extends ItemBlockRare {
    public ItemBlockCrop(Block block) {
        super(block);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advStats) {
        if (advStats && IC2.enableCropHelper) {
            int x = (int)player.field_70165_t;
            int y = (int)player.field_70163_u - 1;
            int z = (int)player.field_70161_v;
            list.add(StatCollector.func_74837_a((String)"itemInfo.cropAir.name", (Object[])new Object[]{this.getAirQuality(player.field_70170_p, x, y, z)}));
            list.add(StatCollector.func_74837_a((String)"itemInfo.cropHumidity.name", (Object[])new Object[]{this.getHumidity(player.field_70170_p, x, y, z)}));
            list.add(StatCollector.func_74837_a((String)"itemInfo.cropNutrient.name", (Object[])new Object[]{this.getNutrient(player.field_70170_p, x, y, z)}));
        }
    }

    public byte getAirQuality(World world, int xCoord, int yCoord, int zCoord) {
        int value = 0;
        int height = (yCoord - 64) / 15;
        if (height > 4) {
            height = 4;
        }
        if (height < 0) {
            height = 0;
        }
        value += height;
        int fresh = 9;
        for (int x = xCoord - 1; x < xCoord + 1 && fresh > 0; ++x) {
            for (int z = zCoord - 1; z < zCoord + 1 && fresh > 0; ++z) {
                if (!world.func_147445_c(x, yCoord, z, false) && !(world.func_147438_o(x, yCoord, z) instanceof TileEntityCrop)) continue;
                --fresh;
            }
        }
        value += fresh / 2;
        if (world.func_72937_j(xCoord, yCoord + 1, zCoord)) {
            value += 2;
        }
        return (byte)value;
    }

    public byte getHumidity(World world, int xCoord, int yCoord, int zCoord) {
        int value = Crops.instance.getHumidityBiomeBonus(world.func_72959_q().func_76935_a(xCoord, zCoord));
        if (world.func_147439_a(xCoord, yCoord - 1, zCoord) == Blocks.field_150458_ak && world.func_72805_g(xCoord, yCoord - 1, zCoord) >= 7) {
            value += 2;
        }
        return (byte)value;
    }

    public byte getNutrient(World world, int xCoord, int yCoord, int zCoord) {
        int value = Crops.instance.getNutrientBiomeBonus(world.func_72959_q().func_76935_a(xCoord, zCoord));
        for (int i = 2; i < 5 && world.func_147439_a(xCoord, yCoord - i, zCoord) == Blocks.field_150346_d; ++i) {
            ++value;
        }
        return (byte)value;
    }
}

