/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ICustomDamageItem;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorPlannerComponent;
import ic2.core.IC2;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.item.ItemIC2;
import ic2.core.util.IExtraData;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;

public class ItemReactorElectricVent
extends ItemIC2
implements ICustomDamageItem,
IReactorPlannerComponent,
IExtraData {
    Map<Integer, VentProperty> properties = new HashMap<Integer, VentProperty>();

    public ItemReactorElectricVent() {
        super(0);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77655_b("itemElectricVent");
    }

    @Override
    public void init() {
        this.properties.put(0, new VentProperty(48, 12, 0, "i3", 7, "reactorElectricVent"));
        this.properties.put(1, new VentProperty(49, 10, 10, "i3", 8, "reactorElectricVentCore"));
        this.properties.put(2, new VentProperty(50, 40, 72, "i3", 9, "reactorElectricVentGold"));
        this.properties.put(3, new VentProperty(51, 24, 0, "i3", 10, "reactorElectricVentDiamond"));
        Ic2Items.reactorElectricVent = new ItemStack((Item)this, 1, 0);
        Ic2Items.reactorElectricVentCore = new ItemStack((Item)this, 1, 1);
        Ic2Items.reactorElectricVentGold = new ItemStack((Item)this, 1, 2);
        Ic2Items.reactorElectricVentDiamond = new ItemStack((Item)this, 1, 3);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack p_77624_1_, EntityPlayer p_77624_2_, List p_77624_3_, boolean p_77624_4_) {
        p_77624_3_.add(StatCollector.func_74838_a((String)"itemInfo.electricHeatVent.name"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item p_150895_1_, CreativeTabs p_150895_2_, List list) {
        for (Integer ints : this.properties.keySet()) {
            list.add(new ItemStack((Item)this, 1, ints.intValue()));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        VentProperty prop = this.properties.get(par1);
        if (prop == null) {
            return super.func_77617_a(par1);
        }
        return prop.getIcon();
    }

    public String func_77667_c(ItemStack par1) {
        VentProperty prop = this.properties.get(par1.func_77960_j());
        if (prop != null) {
            return prop.getUnloclaizedName();
        }
        return super.func_77667_c(par1);
    }

    @Override
    public int getMaxCustomDamage(ItemStack stack) {
        return 10000;
    }

    @Override
    public int getCustomDamage(ItemStack stack) {
        return StackUtil.getOrCreateNbtData(stack).func_74762_e("Heat");
    }

    @Override
    public void setCustomDamage(ItemStack stack, int damage) {
        StackUtil.getOrCreateNbtData(stack).func_74768_a("Heat", damage);
    }

    @Deprecated
    public int getDisplayDamage(ItemStack stack) {
        return this.getCustomDamage(stack);
    }

    public boolean isDamaged(ItemStack stack) {
        return this.getCustomDamage(stack) > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)this.getCustomDamage(stack) / (double)this.getMaxCustomDamage(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getCustomDamage(stack) > 0;
    }

    @Override
    public boolean applyCustomDamage(ItemStack stack, int damage, EntityLivingBase src) {
        return false;
    }

    @Override
    public void processChamber(IReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun) {
        if (heatrun) {
            boolean produce = reactor.produceEnergy();
            VentProperty prop = this.properties.get(yourStack.func_77960_j());
            if (prop.getReactorVent() > 0) {
                int maxHeat;
                int reactorDrain;
                int rheat = reactorDrain = reactor.getHeat();
                int n = maxHeat = produce ? prop.getReactorVent() : prop.getReactorVent() / 2;
                if (reactorDrain > maxHeat) {
                    reactorDrain = maxHeat;
                }
                rheat -= reactorDrain;
                if ((reactorDrain = this.alterHeat(reactor, yourStack, x, y, reactorDrain)) > 0) {
                    return;
                }
                reactor.setHeat(rheat);
            }
            if (produce) {
                reactor.addOutput(-((float)prop.getSelfVent() * 0.005f));
            }
            this.alterHeat(reactor, yourStack, x, y, produce ? -prop.getSelfVent() : -prop.getSelfVent() / 2);
        }
    }

    @Override
    public boolean acceptUraniumPulse(IReactor reactor, ItemStack yourStack, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        return false;
    }

    @Override
    public boolean canStoreHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return true;
    }

    @Override
    public int getMaxHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return this.getMaxCustomDamage(yourStack);
    }

    @Override
    public int getCurrentHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return this.getCustomDamage(yourStack);
    }

    @Override
    public int alterHeat(IReactor reactor, ItemStack yourStack, int x, int y, int heat) {
        int myHeat = this.getCustomDamage(yourStack);
        if ((myHeat += heat) > this.getMaxCustomDamage(yourStack)) {
            reactor.setItemAt(x, y, null);
            heat = this.getMaxCustomDamage(yourStack) - myHeat + 1;
        } else {
            if (myHeat < 0) {
                heat = myHeat;
                myHeat = 0;
            } else {
                heat = 0;
            }
            this.setCustomDamage(yourStack, myHeat);
        }
        return heat;
    }

    @Override
    public float influenceExplosion(IReactor reactor, ItemStack yourStack) {
        return 0.0f;
    }

    @Override
    public ItemStack[] getSubParts() {
        ItemStack[] array = new ItemStack[this.properties.size()];
        int i = 0;
        for (Integer ints : this.properties.keySet()) {
            array[i] = new ItemStack((Item)this, 1, ints.intValue());
            ++i;
        }
        return array;
    }

    @Override
    public boolean hasSubParts() {
        return true;
    }

    @Override
    public ItemStack getReactorPart() {
        return null;
    }

    @Override
    public short getID(ItemStack stack) {
        VentProperty prop = this.properties.get(stack.func_77960_j());
        if (prop != null) {
            return (short)prop.getID();
        }
        return 0;
    }

    @Override
    public IReactorPlannerComponent.ReactorComponentType getType(ItemStack par1) {
        return IReactorPlannerComponent.ReactorComponentType.Vent;
    }

    @Override
    public NBTBase.NBTPrimitive getReactorStat(IReactorPlannerComponent.ReactorComponentStat par1, ItemStack par2) {
        VentProperty prop = this.properties.get(par2.func_77960_j());
        if (par1 == IReactorPlannerComponent.ReactorComponentStat.SelfCooling) {
            return new NBTTagInt(prop.getSelfVent());
        }
        if (par1 == IReactorPlannerComponent.ReactorComponentStat.ReactorCooling) {
            return new NBTTagInt(prop.getReactorVent());
        }
        if (par1 == IReactorPlannerComponent.ReactorComponentStat.EnergyUsage) {
            return new NBTTagFloat((float)prop.getSelfVent() * 0.005f * (float)IC2.energyGeneratorNuclear);
        }
        return nulltag;
    }

    @Override
    public boolean isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat par1, ItemStack par2) {
        return false;
    }

    @Override
    public NBTBase.NBTPrimitive getReactorStat(IReactor par1, int x, int y, ItemStack item, IReactorPlannerComponent.ReactorComponentStat stat) {
        return nulltag;
    }

    @Override
    public IReactorPlannerComponent.ReactorType getReactorInfo(ItemStack stack) {
        return IReactorPlannerComponent.ReactorType.Reactor;
    }

    @Override
    public List<IReactorPlannerComponent.ReactorComponentStat> getExtraStats(ItemStack stack) {
        ArrayList<IReactorPlannerComponent.ReactorComponentStat> list = new ArrayList<IReactorPlannerComponent.ReactorComponentStat>();
        list.add(IReactorPlannerComponent.ReactorComponentStat.EnergyUsage);
        return list;
    }

    class VentProperty {
        int id;
        int self;
        int reactor;
        String sprite;
        int iconPlace;
        String unlocalizedName;

        public VentProperty(int par1, int par2, int par3, String par4, int par5, String par6) {
            this.id = par1;
            this.self = par2;
            this.reactor = par3;
            this.sprite = par4;
            this.iconPlace = par5;
            this.unlocalizedName = par6;
        }

        public String getUnloclaizedName() {
            return "item." + this.unlocalizedName;
        }

        public int getID() {
            return this.id;
        }

        public int getSelfVent() {
            return this.self;
        }

        public int getReactorVent() {
            return this.reactor;
        }

        public IIcon getIcon() {
            return Ic2Icons.getTexture(this.sprite)[this.iconPlace];
        }
    }
}

