/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import com.google.common.math.DoubleMath;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ICustomDamageItem;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.api.reactor.IReactorPlannerComponent;
import ic2.api.reactor.ISteamReactor;
import ic2.api.reactor.ISteamReactorComponent;
import ic2.core.IC2;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.item.ItemIC2;
import ic2.core.item.reactor.ItemReactorUranium;
import ic2.core.util.IExtraData;
import ic2.core.util.StackUtil;
import java.awt.Color;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.IIcon;

public class ItemReactorEnrichUranium
extends ItemIC2
implements ISteamReactorComponent,
IReactorPlannerComponent,
ICustomDamageItem,
IExtraData {
    public static int[] numberOfCells = new int[]{1, 2, 4};
    public static String[] stringOfCells = new String[]{"Simple", "Dual", "Quad"};

    public ItemReactorEnrichUranium(int index) {
        super(index);
        this.setNoRepair();
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        UraniumType type = UraniumType.values()[meta / 3];
        int cellCount = meta % 3;
        return Ic2Icons.getTexture("i3")[this.iconIndex + type.getTextureOffset() + cellCount];
    }

    public String func_77667_c(ItemStack par1) {
        UraniumType type = this.getUranType(par1);
        int meta = par1.func_77960_j() % 3;
        return "item.reactorUranium" + type.name() + stringOfCells[meta];
    }

    @Override
    public void processChamber(IReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun) {
        if (!reactor.produceEnergy()) {
            return;
        }
        int count = this.getCellAmount(yourStack);
        UraniumType type = this.getUranType(yourStack);
        for (int iteration = 0; iteration < count; ++iteration) {
            int i;
            int pulses = (int)((float)(1 + count / 2) * type.getPulseModifier());
            if (!heatrun) {
                for (i = 0; i < pulses; ++i) {
                    this.acceptUraniumPulse(reactor, yourStack, yourStack, x, y, x, y, heatrun);
                }
                for (i = (int)type.getPulseModifier(); i > 0; --i) {
                    for (int[] nArray : type.getPulseEffect()) {
                        pulses += this.checkPulseable(reactor, x + nArray[0], y + nArray[1], yourStack, x, y, heatrun, type);
                    }
                }
                continue;
            }
            for (i = DoubleMath.roundToInt((double)type.getPulseModifier(), (RoundingMode)RoundingMode.DOWN); i > 0; --i) {
                for (int[] nArray : type.getPulseEffect()) {
                    pulses += this.checkPulseable(reactor, x + nArray[0], y + nArray[1], yourStack, x, y, heatrun, type);
                }
            }
            int heat = (int)((float)(this.sumUp(pulses) * 4) * type.getHeatModfier());
            ArrayList heatAcceptors = new ArrayList();
            for (int[] array4 : type.getPulseEffect()) {
                this.checkHeatAcceptor(reactor, x + array4[0], y + array4[1], heatAcceptors);
            }
            while (heatAcceptors.size() > 0 && heat > 0) {
                int n = heat / heatAcceptors.size();
                heat -= n;
                int n2 = ((IReactorComponent)((ItemReactorUranium.ItemStackCoord)heatAcceptors.get((int)0)).stack.func_77973_b()).alterHeat(reactor, ((ItemReactorUranium.ItemStackCoord)heatAcceptors.get((int)0)).stack, ((ItemReactorUranium.ItemStackCoord)heatAcceptors.get((int)0)).x, ((ItemReactorUranium.ItemStackCoord)heatAcceptors.get((int)0)).y, n);
                heat += n2;
                heatAcceptors.remove(0);
            }
            if (heat <= 0) continue;
            reactor.addHeat(heat);
        }
        if (this.getCustomDamage(yourStack) >= this.getMaxCustomDamage(yourStack) - 1) {
            if (IC2.random.nextInt(3) == 0) {
                reactor.setItemAt(x, y, StackUtil.copyWithSize(type.getNearDepleted(), count));
            } else {
                reactor.setItemAt(x, y, null);
            }
        } else if (heatrun) {
            this.setCustomDamage(yourStack, this.getCustomDamage(yourStack) + 1);
        }
    }

    @Override
    public void processTick(ISteamReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun, boolean damageTick) {
        if (!reactor.produceEnergy()) {
            return;
        }
        int count = this.getCellAmount(yourStack);
        UraniumType type = this.getUranType(yourStack);
        for (int iteration = 0; iteration < count; ++iteration) {
            int i;
            int pulses = (int)((float)(1 + count / 2) * type.getPulseModifier());
            if (!heatrun) {
                for (i = 0; i < pulses; ++i) {
                    this.acceptUraniumPulse(reactor, yourStack, yourStack, x, y, x, y, heatrun);
                }
                for (i = DoubleMath.roundToInt((double)type.getPulseModifier(), (RoundingMode)RoundingMode.DOWN); i > 0; --i) {
                    for (int[] nArray : type.getPulseEffect()) {
                        pulses += this.checkPulseable(reactor, x + nArray[0], y + nArray[1], yourStack, x, y, damageTick, type);
                    }
                }
                continue;
            }
            for (i = DoubleMath.roundToInt((double)type.getPulseModifier(), (RoundingMode)RoundingMode.DOWN); i > 0; --i) {
                for (int[] nArray : type.getPulseEffect()) {
                    pulses += this.checkPulseable(reactor, x + nArray[0], y + nArray[1], yourStack, x, y, damageTick, type);
                }
            }
            int heat = (int)((float)(this.sumUp(pulses) * 4) * type.getHeatModfier());
            ArrayList heatAcceptors = new ArrayList();
            for (int[] array4 : type.getPulseEffect()) {
                this.checkHeatAcceptor(reactor, x + array4[0], y + array4[1], heatAcceptors);
            }
            while (heatAcceptors.size() > 0 && heat > 0) {
                int n = heat / heatAcceptors.size();
                heat -= n;
                int n2 = ((IReactorComponent)((ItemReactorUranium.ItemStackCoord)heatAcceptors.get((int)0)).stack.func_77973_b()).alterHeat(reactor, ((ItemReactorUranium.ItemStackCoord)heatAcceptors.get((int)0)).stack, ((ItemReactorUranium.ItemStackCoord)heatAcceptors.get((int)0)).x, ((ItemReactorUranium.ItemStackCoord)heatAcceptors.get((int)0)).y, n);
                heat += n2;
                heatAcceptors.remove(0);
            }
            if (heat <= 0) continue;
            reactor.addHeat(heat);
        }
        if (damageTick) {
            if (this.getCustomDamage(yourStack) + 1 > this.getMaxCustomDamage(yourStack)) {
                if (IC2.random.nextInt(3) == 0) {
                    reactor.setItemAt(x, y, StackUtil.copyWithSize(type.getNearDepleted(), count));
                } else {
                    reactor.setItemAt(x, y, null);
                }
            } else {
                this.setCustomDamage(yourStack, this.getCustomDamage(yourStack) + 1);
            }
        }
    }

    @Override
    public boolean acceptUraniumPulse(IReactor reactor, ItemStack yourStack, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        if (reactor instanceof ISteamReactor) {
            return true;
        }
        if (!heatrun) {
            UraniumType type = this.getUranType(yourStack);
            reactor.addOutput(type.getEUPerPulse());
        }
        return true;
    }

    @Override
    public boolean canStoreHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return false;
    }

    @Override
    public int getMaxHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    @Override
    public int getCurrentHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    @Override
    public int alterHeat(IReactor reactor, ItemStack yourStack, int x, int y, int heat) {
        return heat;
    }

    @Override
    public float influenceExplosion(IReactor reactor, ItemStack yourStack) {
        int amount = this.getCellAmount(yourStack);
        return this.getUranType(yourStack).getExplosionEffect() * (float)amount;
    }

    private int checkPulseable(IReactor reactor, int x, int y, ItemStack me, int mex, int mey, boolean heatrun, UraniumType type) {
        ItemStack other = reactor.getItemAt(x, y);
        if (other != null && other.func_77973_b() instanceof IReactorComponent && ((IReactorComponent)other.func_77973_b()).acceptUraniumPulse(reactor, other, me, x, y, mex, mey, heatrun)) {
            return type.getPulseForConnection();
        }
        return 0;
    }

    private int sumUp(int x) {
        int sum = 0;
        for (int i = 1; i <= x; ++i) {
            sum += i;
        }
        return sum;
    }

    private void checkHeatAcceptor(IReactor reactor, int x, int y, ArrayList heatAcceptors) {
        ItemStack thing = reactor.getItemAt(x, y);
        if (thing != null && thing.func_77973_b() instanceof IReactorComponent && ((IReactorComponent)thing.func_77973_b()).canStoreHeat(reactor, thing, x, y)) {
            heatAcceptors.add(new ItemReactorUranium.ItemStackCoord(thing, x, y));
        }
    }

    public int getCellAmount(ItemStack par1) {
        int meta = par1.func_77960_j();
        return numberOfCells[meta % 3];
    }

    public UraniumType getUranType(ItemStack par1) {
        int meta = par1.func_77960_j();
        return UraniumType.values()[meta / 3];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item p_150895_1_, CreativeTabs p_150895_2_, List list) {
        for (UraniumType type : UraniumType.values()) {
            list.add(new ItemStack((Item)this, 1, type.getOffset()));
            list.add(new ItemStack((Item)this, 1, type.getOffset() + 1));
            list.add(new ItemStack((Item)this, 1, type.getOffset() + 2));
        }
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)this.getCustomDamage(stack) / (double)this.getMaxCustomDamage(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getCustomDamage(stack) > 0;
    }

    @Override
    public int getCustomDamage(ItemStack stack) {
        return StackUtil.getOrCreateNbtData(stack).func_74762_e("CustomDamage");
    }

    @Override
    public int getMaxCustomDamage(ItemStack stack) {
        return this.getMaxDamage(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getUranType(stack).getMaxDamage();
    }

    public boolean isDamaged(ItemStack stack) {
        return this.getCustomDamage(stack) > 0;
    }

    @Deprecated
    public int getDisplayDamage(ItemStack stack) {
        return this.getCustomDamage(stack);
    }

    @Override
    public void setCustomDamage(ItemStack stack, int damage) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        nbt.func_74768_a("CustomDamage", damage);
    }

    @Override
    public boolean applyCustomDamage(ItemStack stack, int damage, EntityLivingBase src) {
        this.setCustomDamage(stack, this.getCustomDamage(stack) + damage);
        return true;
    }

    @Override
    public ItemStack[] getSubParts() {
        ItemStack[] items = new ItemStack[UraniumType.values().length * 3];
        for (UraniumType type : UraniumType.values()) {
            items[type.getOffset()] = new ItemStack((Item)this, 1, type.getOffset());
            items[type.getOffset() + 1] = new ItemStack((Item)this, 1, type.getOffset() + 1);
            items[type.getOffset() + 2] = new ItemStack((Item)this, 1, type.getOffset() + 2);
        }
        return items;
    }

    @Override
    public boolean hasSubParts() {
        return true;
    }

    @Override
    public ItemStack getReactorPart() {
        return null;
    }

    @Override
    public IReactorPlannerComponent.ReactorComponentType getType(ItemStack par1) {
        return IReactorPlannerComponent.ReactorComponentType.FuelRod;
    }

    @Override
    public NBTBase.NBTPrimitive getReactorStat(IReactorPlannerComponent.ReactorComponentStat par1, ItemStack par2) {
        UraniumType type = this.getUranType(par2);
        int cellCount = this.getCellAmount(par2);
        if (par1 == IReactorPlannerComponent.ReactorComponentStat.HeatProduction) {
            int amount = 0;
            for (int i = 0; i < cellCount; ++i) {
                amount = (int)((float)amount + (float)(this.sumUp((int)((float)(1 + cellCount / 2) * type.getPulseModifier())) * 4) * type.getHeatModfier());
            }
            return new NBTTagInt(amount);
        }
        if (par1 == IReactorPlannerComponent.ReactorComponentStat.EnergyProduction) {
            float amount = 0.0f;
            for (int i = 0; i < cellCount; ++i) {
                int pulses = (int)((float)(1 + cellCount / 2) * type.getPulseModifier());
                for (int z = 0; z < pulses; ++z) {
                    amount += type.getEUPerPulse();
                }
            }
            return new NBTTagFloat(amount * (float)IC2.energyGeneratorNuclear);
        }
        if (par1 == IReactorPlannerComponent.ReactorComponentStat.MaxDurability) {
            return new NBTTagInt(this.getMaxCustomDamage(par2));
        }
        if (par1 == IReactorPlannerComponent.ReactorComponentStat.ReactorEEM) {
            return new NBTTagFloat(type.getExplosionEffect() * (float)cellCount);
        }
        if (par1 == IReactorPlannerComponent.ReactorComponentStat.RodAmount) {
            return new NBTTagInt(cellCount);
        }
        if (par1 == IReactorPlannerComponent.ReactorComponentStat.PulseAmount) {
            return new NBTTagInt((int)((float)(1 + cellCount / 2) * type.getPulseModifier() * (float)cellCount));
        }
        return nulltag;
    }

    @Override
    public boolean isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat par1, ItemStack par2) {
        return par1 == IReactorPlannerComponent.ReactorComponentStat.EnergyProduction || par1 == IReactorPlannerComponent.ReactorComponentStat.HeatProduction;
    }

    @Override
    public NBTBase.NBTPrimitive getReactorStat(IReactor par1, int x, int y, ItemStack item, IReactorPlannerComponent.ReactorComponentStat stat) {
        UraniumType type = this.getUranType(item);
        int cellCount = this.getCellAmount(item);
        if (stat == IReactorPlannerComponent.ReactorComponentStat.HeatProduction) {
            int amount = 0;
            int pulsePerTick = (int)type.getPulseModifier();
            for (int i = 0; i < cellCount; ++i) {
                int pulses = (int)((float)(1 + cellCount / 2) * type.getPulseModifier());
                for (int z = 0; z < pulsePerTick; ++z) {
                    for (int[] array : type.getPulseEffect()) {
                        pulses += this.checkPulseable(par1, x + array[0], y + array[1], item, x, y, false, type);
                    }
                }
                amount = (int)((float)amount + (float)(this.sumUp(pulses) * 4) * type.getHeatModfier());
            }
            return new NBTTagInt(amount);
        }
        if (stat == IReactorPlannerComponent.ReactorComponentStat.EnergyProduction) {
            for (int i = 0; i < cellCount; ++i) {
                int z;
                int pulsePerTick = (int)type.getPulseModifier();
                int pulses = (1 + cellCount / 2) * pulsePerTick;
                for (z = 0; z < pulses; ++z) {
                    this.acceptUraniumPulse(par1, item, item, x, y, x, y, false);
                }
                for (z = 0; z < pulsePerTick; ++z) {
                    for (int[] array : type.getPulseEffect()) {
                        pulses += this.checkPulseable(par1, x + array[0], y + array[1], item, x, y, false, type);
                    }
                }
            }
            return new NBTTagFloat(par1.getReactorEnergyOutput());
        }
        return nulltag;
    }

    @Override
    public IReactorPlannerComponent.ReactorType getReactorInfo(ItemStack stack) {
        return IReactorPlannerComponent.ReactorType.Both;
    }

    @Override
    public List<IReactorPlannerComponent.ReactorComponentStat> getExtraStats(ItemStack stack) {
        return null;
    }

    @Override
    public void init() {
        UraniumType type = UraniumType.Redstone;
        Ic2Items.reactorRedstoneEnrichedUraniumSimple = new ItemStack((Item)this, 1, type.getOffset());
        Ic2Items.reactorRedstoneEnrichedUraniumDual = new ItemStack((Item)this, 1, type.getOffset() + 1);
        Ic2Items.reactorRedstoneEnrichedUraniumQuad = new ItemStack((Item)this, 1, type.getOffset() + 2);
        type = UraniumType.Blaze;
        Ic2Items.reactorBlazeEnrichedUraniumSimple = new ItemStack((Item)this, 1, type.getOffset());
        Ic2Items.reactorBlazeEnrichedUraniumDual = new ItemStack((Item)this, 1, type.getOffset() + 1);
        Ic2Items.reactorBlazeEnrichedUraniumQuad = new ItemStack((Item)this, 1, type.getOffset() + 2);
        type = UraniumType.EnderPearl;
        Ic2Items.reactorEnderPearlEnrichedUraniumSimple = new ItemStack((Item)this, 1, type.getOffset());
        Ic2Items.reactorEnderPearlEnrichedUraniumDual = new ItemStack((Item)this, 1, type.getOffset() + 1);
        Ic2Items.reactorEnderPearlEnrichedUraniumQuad = new ItemStack((Item)this, 1, type.getOffset() + 2);
        type = UraniumType.NetherStar;
        Ic2Items.reactorNetherStarEnrichedUraniumSimple = new ItemStack((Item)this, 1, type.getOffset());
        Ic2Items.reactorNetherStarEnrichedUraniumDual = new ItemStack((Item)this, 1, type.getOffset() + 1);
        Ic2Items.reactorNetherStarEnrichedUraniumQuad = new ItemStack((Item)this, 1, type.getOffset() + 2);
        type = UraniumType.Charcoal;
        Ic2Items.reactorCharcoalEnrichedUraniumSimple = new ItemStack((Item)this, 1, type.getOffset());
        Ic2Items.reactorCharcoalEnrichedUraniumDual = new ItemStack((Item)this, 1, type.getOffset() + 1);
        Ic2Items.reactorCharcoalEnrichedUraniumQuad = new ItemStack((Item)this, 1, type.getOffset() + 2);
    }

    @Override
    public short getID(ItemStack stack) {
        UraniumType type = this.getUranType(stack);
        int meta = stack.func_77960_j() % 3;
        return (short)(type.getID() + meta);
    }

    public static enum UraniumType {
        Redstone(2, 1.0f, 8000, 0, 3, 2.0f, 2.0f, 0.5f, new ItemStack(Items.field_151137_ax)),
        Blaze(1, 1.0f, 10000, 3, 6, 8.0f, 1.0f, 4.0f, new ItemStack(Items.field_151072_bj)),
        EnderPearl(1, 1, 5000, 6, 9, 2.0f, 1.0f, 1.0f, new ItemStack(Items.field_151079_bi), new int[][]{{-1, -1}, {0, -1}, {1, -1}, {-1, 0}, {1, 0}, {-1, 1}, {0, 1}, {1, 1}}),
        NetherStar(3, 5.0f, 20000, 9, 37, 2.0f, 2.0f, 1.2f, new ItemStack(Items.field_151156_bN)),
        Charcoal(1, 0.6f, 15000, 12, 40, 2.0f, 1.0f, 1.0f, new ItemStack(Items.field_151044_h, 1, 1)){

            @Override
            public int getTextureOffset() {
                return 29;
            }
        };

        int pulseConnection;
        float euPerPulse;
        int maxDamage;
        int offset;
        short id;
        float explosionEffect;
        float pulseModifier;
        float heatMod;
        List<int[]> pulseEffects;
        ItemStack item;

        private UraniumType() {
        }

        private UraniumType(int par1, float par2, int par3, int par4, int par5, float par6, float par7, float par8, ItemStack par9) {
            this.pulseConnection = par1;
            this.euPerPulse = par2;
            this.maxDamage = par3;
            this.offset = par4;
            this.id = (short)par5;
            this.explosionEffect = par6;
            this.pulseModifier = par7;
            this.heatMod = par8;
            this.item = par9;
            this.pulseEffects = new ArrayList<int[]>();
            this.pulseEffects.add(new int[]{-1, 0});
            this.pulseEffects.add(new int[]{1, 0});
            this.pulseEffects.add(new int[]{0, -1});
            this.pulseEffects.add(new int[]{0, 1});
        }

        private UraniumType(int par1, int par2, int par3, int par4, int par5, float par6, float par7, float par8, ItemStack par9, int[][] par10) {
            this(par1, par2, par3, par4, par5, par6, par7, par8, par9);
            this.pulseEffects.clear();
            for (int i = 0; i < par10.length; ++i) {
                this.pulseEffects.add(par10[i]);
            }
        }

        public UraniumType setOffset(int par1) {
            return this;
        }

        public int getTextureOffset() {
            return this.offset;
        }

        public int getOffset() {
            return this.offset;
        }

        public short getID() {
            return this.id;
        }

        public int getPulseForConnection() {
            return this.pulseConnection;
        }

        public float getExplosionEffect() {
            return this.explosionEffect;
        }

        public float getPulseModifier() {
            return this.pulseModifier;
        }

        public float getHeatModfier() {
            return this.heatMod;
        }

        public float getEUPerPulse() {
            return this.euPerPulse;
        }

        public List<int[]> getPulseEffect() {
            return this.pulseEffects;
        }

        public int getMaxDamage() {
            return this.maxDamage;
        }

        public Color getColor() {
            switch (this) {
                case Blaze: {
                    return new Color(15244039);
                }
                case Charcoal: {
                    return new Color(0x363636);
                }
                case EnderPearl: {
                    return new Color(2338417);
                }
                case NetherStar: {
                    return new Color(16772970);
                }
                case Redstone: {
                    return new Color(0xFF0000);
                }
            }
            return Color.GREEN;
        }

        public ItemStack getItem() {
            return this.item;
        }

        public ItemStack getIngot() {
            switch (this) {
                case Redstone: {
                    return Ic2Items.redstoneEnrichedUraniumIngot.func_77946_l();
                }
                case Blaze: {
                    return Ic2Items.blazeEnrichedUraniumIngot.func_77946_l();
                }
                case EnderPearl: {
                    return Ic2Items.enderpearlEnrichedUraniumIngot.func_77946_l();
                }
                case NetherStar: {
                    return Ic2Items.netherstarEnrichedUraniumIngot.func_77946_l();
                }
                case Charcoal: {
                    return Ic2Items.charcoalEnrichedUraniumIngot.func_77946_l();
                }
            }
            return Ic2Items.uraniumIngot.func_77946_l();
        }

        public ItemStack getNearDepleted() {
            switch (this) {
                case Redstone: {
                    return Ic2Items.nearDepletedRedstoneEnrichedUraniumCell.func_77946_l();
                }
                case Blaze: {
                    return Ic2Items.nearDepletedBlazeEnrichedUraniumCell.func_77946_l();
                }
                case EnderPearl: {
                    return Ic2Items.nearDepletedEnderPearlEnrichedUraniumCell.func_77946_l();
                }
                case NetherStar: {
                    return Ic2Items.nearDepletedNetherStarEnrichedUraniumCell.func_77946_l();
                }
                case Charcoal: {
                    return Ic2Items.nearDepletedCharcoalEnrichedUraniumCell.func_77946_l();
                }
            }
            return Ic2Items.nearDepletedUraniumCell.func_77946_l();
        }

        public ItemStack getIsotopic() {
            switch (this) {
                case Redstone: {
                    return Ic2Items.reactorRedstoneIsotopeCell.func_77946_l();
                }
                case Blaze: {
                    return Ic2Items.reactorBlazeIsotopeCell.func_77946_l();
                }
                case EnderPearl: {
                    return Ic2Items.reactorEnderPearlIsotopeCell.func_77946_l();
                }
                case NetherStar: {
                    return Ic2Items.reactorNetherStarIsotopeCell.func_77946_l();
                }
                case Charcoal: {
                    return Ic2Items.reactorCharcoalIsotopeCell.func_77946_l();
                }
            }
            return Ic2Items.reactorIsotopeCell.func_77946_l();
        }

        public ItemStack getReEnriched() {
            switch (this) {
                case Redstone: {
                    return Ic2Items.reEnrichedRedstoneUraniumCell.func_77946_l();
                }
                case Blaze: {
                    return Ic2Items.reEnrichedBlazeUraniumCell.func_77946_l();
                }
                case EnderPearl: {
                    return Ic2Items.reEnrichedEnderPearlUraniumCell.func_77946_l();
                }
                case NetherStar: {
                    return Ic2Items.reEnrichedNetherStarUraniumCell.func_77946_l();
                }
                case Charcoal: {
                    return Ic2Items.reEnrichedCharcoalUraniumCell.func_77946_l();
                }
            }
            return Ic2Items.reEnrichedUraniumCell.func_77946_l();
        }

        public ItemStack getSimpleRod() {
            switch (this) {
                case Redstone: {
                    return Ic2Items.reactorRedstoneEnrichedUraniumSimple.func_77946_l();
                }
                case Blaze: {
                    return Ic2Items.reactorBlazeEnrichedUraniumSimple.func_77946_l();
                }
                case EnderPearl: {
                    return Ic2Items.reactorEnderPearlEnrichedUraniumSimple.func_77946_l();
                }
                case NetherStar: {
                    return Ic2Items.reactorNetherStarEnrichedUraniumSimple.func_77946_l();
                }
                case Charcoal: {
                    return Ic2Items.reactorCharcoalEnrichedUraniumSimple.func_77946_l();
                }
            }
            return Ic2Items.reactorUraniumSimple.func_77946_l();
        }

        public ItemStack getDualRod() {
            switch (this) {
                case Redstone: {
                    return Ic2Items.reactorRedstoneEnrichedUraniumDual.func_77946_l();
                }
                case Blaze: {
                    return Ic2Items.reactorBlazeEnrichedUraniumDual.func_77946_l();
                }
                case EnderPearl: {
                    return Ic2Items.reactorEnderPearlEnrichedUraniumDual.func_77946_l();
                }
                case NetherStar: {
                    return Ic2Items.reactorNetherStarEnrichedUraniumDual.func_77946_l();
                }
                case Charcoal: {
                    return Ic2Items.reactorCharcoalEnrichedUraniumDual.func_77946_l();
                }
            }
            return Ic2Items.reactorUraniumDual.func_77946_l();
        }

        public ItemStack getQuadRod() {
            switch (this) {
                case Redstone: {
                    return Ic2Items.reactorRedstoneEnrichedUraniumQuad.func_77946_l();
                }
                case Blaze: {
                    return Ic2Items.reactorBlazeEnrichedUraniumQuad.func_77946_l();
                }
                case EnderPearl: {
                    return Ic2Items.reactorEnderPearlEnrichedUraniumQuad.func_77946_l();
                }
                case NetherStar: {
                    return Ic2Items.reactorNetherStarEnrichedUraniumQuad.func_77946_l();
                }
                case Charcoal: {
                    return Ic2Items.reactorCharcoalEnrichedUraniumQuad.func_77946_l();
                }
            }
            return Ic2Items.reactorUraniumQuad.func_77946_l();
        }

        public ItemStack getNewIsotopic() {
            ItemStack item = this.getIsotopic();
            ICustomDamageItem custom = (ICustomDamageItem)item.func_77973_b();
            custom.setCustomDamage(item, 9999);
            return item;
        }
    }
}

