/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.api.reactor.IReactorPlannerComponent;
import ic2.api.reactor.ISteamReactor;
import ic2.api.reactor.ISteamReactorComponent;
import ic2.core.block.machine.tileentity.TileEntityMiner;
import ic2.core.item.ItemIC2;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemReactorVentSpread
extends ItemIC2
implements ISteamReactorComponent,
IReactorPlannerComponent {
    public int sideVent;

    public ItemReactorVentSpread(int index, int sidevent) {
        super(index);
        this.func_77625_d(1);
        this.sideVent = sidevent;
        this.setSpriteID("i3");
    }

    @Override
    public void processChamber(IReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun) {
        if (heatrun) {
            this.cool(reactor, x - 1, y);
            this.cool(reactor, x + 1, y);
            this.cool(reactor, x, y - 1);
            this.cool(reactor, x, y + 1);
        }
    }

    private void cool(IReactor reactor, int x, int y) {
        IReactorComponent comp;
        ItemStack stack = reactor.getItemAt(x, y);
        if (stack != null && stack.func_77973_b() instanceof IReactorComponent && (comp = (IReactorComponent)stack.func_77973_b()).canStoreHeat(reactor, stack, x, y)) {
            comp.alterHeat(reactor, stack, x, y, -this.sideVent);
        }
    }

    @Override
    public boolean acceptUraniumPulse(IReactor reactor, ItemStack yourStack, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        return false;
    }

    @Override
    public boolean canStoreHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return false;
    }

    @Override
    public int getMaxHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    @Override
    public int getCurrentHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    @Override
    public int alterHeat(IReactor reactor, ItemStack yourStack, int x, int y, int heat) {
        return heat;
    }

    @Override
    public float influenceExplosion(IReactor reactor, ItemStack yourStack) {
        return 0.0f;
    }

    @Override
    public void processTick(ISteamReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun, boolean damageTick) {
        this.processChamber(reactor, yourStack, x, y, heatrun);
    }

    @Override
    public ItemStack[] getSubParts() {
        return null;
    }

    @Override
    public boolean hasSubParts() {
        return false;
    }

    @Override
    public ItemStack getReactorPart() {
        return new ItemStack((Item)this);
    }

    @Override
    public IReactorPlannerComponent.ReactorComponentType getType(ItemStack par1) {
        return IReactorPlannerComponent.ReactorComponentType.VentSpread;
    }

    @Override
    public NBTBase.NBTPrimitive getReactorStat(IReactorPlannerComponent.ReactorComponentStat par1, ItemStack par2) {
        if (par1 == IReactorPlannerComponent.ReactorComponentStat.PartCooling) {
            return new NBTTagInt(this.sideVent);
        }
        return nulltag;
    }

    @Override
    public boolean isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat par1, ItemStack par2) {
        return par1 == IReactorPlannerComponent.ReactorComponentStat.PartCooling;
    }

    @Override
    public NBTBase.NBTPrimitive getReactorStat(IReactor par1, int x, int y, ItemStack item, IReactorPlannerComponent.ReactorComponentStat stat) {
        if (stat == IReactorPlannerComponent.ReactorComponentStat.PartCooling) {
            boolean count = false;
            int sides = 0;
            for (ForgeDirection dir : TileEntityMiner.validDirs) {
                IReactorComponent comp;
                int newX = x + dir.offsetX;
                int newY = y + dir.offsetZ;
                ItemStack stack = par1.getItemAt(newX, newY);
                if (stack == null || !(stack.func_77973_b() instanceof IReactorComponent) || !(comp = (IReactorComponent)stack.func_77973_b()).canStoreHeat(par1, stack, x, y)) continue;
                ++sides;
            }
            return new NBTTagInt(this.sideVent * sides);
        }
        return nulltag;
    }

    @Override
    public short getID(ItemStack stack) {
        return 26;
    }

    @Override
    public IReactorPlannerComponent.ReactorType getReactorInfo(ItemStack stack) {
        return IReactorPlannerComponent.ReactorType.Both;
    }

    @Override
    public List<IReactorPlannerComponent.ReactorComponentStat> getExtraStats(ItemStack stack) {
        return null;
    }
}

