/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkItemEventListener;
import ic2.api.reactor.IReactor;
import ic2.api.tile.IEnergyStorage;
import ic2.core.IC2;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.TileEntityCrop;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.block.machine.tileentity.TileEntityElecMachine;
import ic2.core.block.personal.IPersonalBlock;
import ic2.core.energy.EnergyNetGlobal;
import ic2.core.item.ItemIC2;
import ic2.core.network.packets.server.EnergyGridPacket;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class ItemDebug
extends ItemIC2
implements INetworkItemEventListener {
    private static String[] modes;
    private int mode;
    public static Map<Integer, List<AxisAlignedBB>> grids;

    public ItemDebug() {
        super(17);
        this.setSpriteID("i1");
        this.mode = 1;
        this.func_77627_a(false);
        this.func_77637_a(IC2.tabIC2);
        this.func_77655_b("itemDebug");
        if (IC2.platform.isRendering()) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent evt) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack item = player.func_71045_bC();
        if (item == null || item.func_77973_b() != this) {
            return;
        }
        if (((ItemDebug)item.func_77973_b()).mode != 2) {
            return;
        }
        List<AxisAlignedBB> boxList = this.getStuffToRender((EntityPlayer)player);
        if (boxList.isEmpty()) {
            return;
        }
        World world = player.field_70170_p;
        double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)evt.partialTicks;
        double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)evt.partialTicks;
        double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)evt.partialTicks;
        for (AxisAlignedBB box : boxList) {
            double xCoord = -x + (box.field_72340_a - box.field_72336_d);
            double yCoord = -y + (box.field_72338_b - box.field_72337_e);
            double zCoord = -z + (box.field_72339_c - box.field_72334_f);
            xCoord -= xCoord + x;
            yCoord -= yCoord + y;
            zCoord -= zCoord + z;
            GL11.glPushMatrix();
            GL11.glTranslated((double)xCoord, (double)yCoord, (double)zCoord);
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3042);
            RenderGlobal.func_147590_a((AxisAlignedBB)box, (int)0xFFFF00);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
            GL11.glPopMatrix();
        }
    }

    public List<AxisAlignedBB> getStuffToRender(EntityPlayer player) {
        int dim = player.field_71093_bK;
        if (dim != player.field_70170_p.field_73011_w.field_76574_g) {
            dim = player.field_70170_p.field_73011_w.field_76574_g;
        }
        if (!grids.containsKey(dim)) {
            return new ArrayList<AxisAlignedBB>();
        }
        double x = player.field_70165_t;
        double y = player.field_70163_u;
        double z = player.field_70161_v;
        List<AxisAlignedBB> boxList = grids.get(dim);
        HashSet<AxisAlignedBB> returnList = new HashSet<AxisAlignedBB>();
        for (AxisAlignedBB box : boxList) {
            double closeY;
            double closeX;
            double d = x > box.field_72336_d ? box.field_72336_d : (closeX = x < box.field_72340_a ? box.field_72340_a : x);
            double d2 = y > box.field_72337_e ? box.field_72337_e : (closeY = y < box.field_72338_b ? box.field_72338_b : z);
            double d3 = z > box.field_72334_f ? box.field_72334_f : (z < box.field_72339_c ? box.field_72339_c : y);
            double closeZ = d3;
            if (!(player.func_70092_e(closeX, closeY, closeZ) < 4096.0)) continue;
            returnList.add(box);
        }
        return new ArrayList<AxisAlignedBB>(returnList);
    }

    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (IC2.platform.isSimulating()) {
                ++this.mode;
                if (this.mode >= modes.length) {
                    this.mode = 0;
                }
                IC2.network.get().initiateItemEvent(player, item, this.mode, true);
                IC2.platform.messagePlayer(player, "Debug Item Mode: " + modes[this.mode]);
            }
            return item;
        }
        if (IC2.platform.isSimulating() && this.mode == 2) {
            IC2.network.get().sendCustomPacket(player, new EnergyGridPacket(EnergyNetGlobal.getBoxes()));
        }
        return item;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        switch (this.mode) {
            case 0: {
                Block blockId = world.func_147439_a(x, y, z);
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                String plat = IC2.platform.isRendering() ? "client" : (IC2.platform.isSimulating() ? "sp" : "server");
                String message = blockId != Blocks.field_150350_a ? "[" + plat + "] id: " + blockId + " name: " + blockId.func_149739_a() + " te: " + tileEntity : "[" + plat + "] id: " + blockId + " name: null te: " + tileEntity;
                IC2.platform.messagePlayer(player, message);
                System.out.println(message);
                if (tileEntity != null) {
                    message = "[" + plat + "] interfaces:";
                    Class<?> c = tileEntity.getClass();
                    do {
                        for (Class<?> i : c.getInterfaces()) {
                            message = message + " " + i.getName();
                        }
                    } while ((c = c.getSuperclass()) != null);
                    IC2.platform.messagePlayer(player, message);
                    System.out.println(message);
                }
                if (blockId != null) {
                    System.out.println("block fields:");
                    ItemDebug.dumpObjectFields(blockId);
                }
                if (tileEntity == null) break;
                System.out.println("tile entity fields:");
                ItemDebug.dumpObjectFields(tileEntity);
                break;
            }
            case 1: {
                if (!IC2.platform.isSimulating()) {
                    return false;
                }
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (tileEntity instanceof TileEntityBlock) {
                    TileEntityBlock te = (TileEntityBlock)tileEntity;
                    IC2.platform.messagePlayer(player, "Block: Active=" + te.getActive() + " Facing=" + te.getFacing());
                }
                if (tileEntity instanceof TileEntityBaseGenerator) {
                    TileEntityBaseGenerator te2 = (TileEntityBaseGenerator)tileEntity;
                    IC2.platform.messagePlayer(player, "BaseGen: Fuel=" + te2.fuel + " Storage=" + te2.storage);
                }
                if (tileEntity instanceof TileEntityElecMachine) {
                    TileEntityElecMachine te3 = (TileEntityElecMachine)tileEntity;
                    IC2.platform.messagePlayer(player, "ElecMachine: Energy=" + te3.energy);
                }
                if (tileEntity instanceof IEnergyStorage) {
                    IEnergyStorage te4 = (IEnergyStorage)tileEntity;
                    IC2.platform.messagePlayer(player, "EnergyStorage: Stored=" + te4.getStored());
                }
                if (tileEntity instanceof IReactor) {
                    IReactor te5 = (IReactor)tileEntity;
                    IC2.platform.messagePlayer(player, "Reactor: Heat=" + te5.getHeat() + " MaxHeat=" + te5.getMaxHeat() + " HEM=" + te5.getHeatEffectModifier() + " Output=" + te5.getReactorEnergyOutput());
                }
                if (tileEntity instanceof IPersonalBlock) {
                    IPersonalBlock te6 = (IPersonalBlock)tileEntity;
                    IC2.platform.messagePlayer(player, "PersonalBlock: CanAccess=" + te6.canAccess(player));
                }
                if (!(tileEntity instanceof TileEntityCrop)) break;
                TileEntityCrop te7 = (TileEntityCrop)tileEntity;
                IC2.platform.messagePlayer(player, "PersonalBlock: Crop=" + te7.getID() + " Size=" + te7.getSize() + " Growth=" + te7.getGrowth() + " Gain=" + te7.getGain() + " Resistance=" + te7.getResistance() + " Nutrients=" + te7.getNutrientStorage() + " Water=" + te7.getHydrationStorage() + " GrowthPoints=" + te7.growthPoints);
                break;
            }
        }
        return this.mode != 2;
    }

    private static void dumpObjectFields(Object o) {
        Class<?> fieldDeclaringClass = o.getClass();
        do {
            Field[] arr$;
            Field[] fields = arr$ = fieldDeclaringClass.getDeclaredFields();
            for (Field field : arr$) {
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                try {
                    System.out.println("name: " + fieldDeclaringClass.getName() + "." + field.getName() + " type: " + field.getType() + " value: " + field.get(o));
                }
                catch (IllegalAccessException e) {
                    System.out.println("name: " + fieldDeclaringClass.getName() + "." + field.getName() + " type: " + field.getType() + " value: <can't access>");
                }
                field.setAccessible(accessible);
            }
        } while ((fieldDeclaringClass = fieldDeclaringClass.getSuperclass()) != null);
    }

    @Override
    public void onNetworkEvent(ItemStack metaData, EntityPlayer player, int event) {
        this.mode = event;
        grids.clear();
    }

    static {
        grids = new HashMap<Integer, List<AxisAlignedBB>>();
        modes = new String[]{"Interfaces and Fields", "Tile Data", "EnergyNet Grids"};
    }
}

