/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import com.google.common.collect.Multimap;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricTool;
import ic2.core.IC2;
import ic2.core.IHitSoundOverride;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDamage;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityInteractEvent;

public class ItemElectricToolChainsaw
extends ItemAxe
implements IHitSoundOverride,
IElectricTool {
    public static boolean wasEquipped = false;
    public static AudioSource audioSource;
    public int co;
    public int operationEnergyCost = 50;
    public int maxCharge = 10000;
    public int transferLimit = 100;
    public int tier = 1;
    public Set mineableBlocks = new HashSet();
    public int iconIndex;

    public ItemElectricToolChainsaw(int sprite) {
        super(Item.ToolMaterial.IRON);
        this.field_77864_a = 12.0f;
        this.co = 1;
        this.iconIndex = sprite;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.setHarvestLevel("axe", 2);
    }

    public void init() {
        this.mineableBlocks.add(Blocks.field_150344_f);
        this.mineableBlocks.add(Blocks.field_150342_X);
        this.mineableBlocks.add(Blocks.field_150364_r);
        this.mineableBlocks.add(Blocks.field_150363_s);
        this.mineableBlocks.add(Blocks.field_150486_ae);
        this.mineableBlocks.add(Blocks.field_150362_t);
        this.mineableBlocks.add(Blocks.field_150321_G);
        this.mineableBlocks.add(Block.func_149634_a((Item)Ic2Items.crop.func_77973_b()));
        if (Ic2Items.rubberLeaves != null) {
            this.mineableBlocks.add(Block.func_149634_a((Item)Ic2Items.rubberLeaves.func_77973_b()));
        }
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase entityliving1) {
        if (ElectricItem.manager.use(itemstack, this.operationEnergyCost, (EntityLivingBase)((EntityPlayer)entityliving1)) && ElectricItem.manager.use(itemstack, this.operationEnergyCost, (EntityLivingBase)((EntityPlayer)entityliving1))) {
            entityliving.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)entityliving1)), 10.0f);
        } else {
            entityliving.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)entityliving1)), 1.0f);
        }
        if (entityliving instanceof EntityCreeper && entityliving.func_110143_aJ() <= 0.0f) {
            IC2.achievements.issueAchievement((EntityPlayer)entityliving1, "killCreeperChainsaw");
        }
        return false;
    }

    public boolean canHarvestBlock(Block block, ItemStack item) {
        return block.func_149688_o() == Material.field_151575_d || this.mineableBlocks.contains(block);
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        IShearable target;
        Entity entity = event.target;
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.func_77973_b() == this && entity instanceof IShearable && ElectricItem.manager.use(itemstack, this.operationEnergyCost * 2, (EntityLivingBase)player) && (target = (IShearable)entity).isShearable(itemstack, (IBlockAccess)entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v)) {
            ArrayList drops = target.onSheared(itemstack, (IBlockAccess)entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemstack));
            for (ItemStack stack : drops) {
                EntityItem entityDropItem;
                EntityItem ent = entityDropItem = entity.func_70099_a(stack, 1.0f);
                entityDropItem.field_70181_x += (double)(Item.field_77697_d.nextFloat() * 0.05f);
                EntityItem entityItem = ent;
                entityItem.field_70159_w += (double)((Item.field_77697_d.nextFloat() - Item.field_77697_d.nextFloat()) * 0.1f);
                EntityItem entityItem2 = ent;
                entityItem2.field_70179_y += (double)((Item.field_77697_d.nextFloat() - Item.field_77697_d.nextFloat()) * 0.1f);
            }
        }
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int X, int Y, int Z, EntityPlayer player) {
        IShearable target;
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        Block id = player.field_70170_p.func_147439_a(X, Y, Z);
        if (id != null && id instanceof IShearable && (target = (IShearable)id).isShearable(itemstack, (IBlockAccess)player.field_70170_p, X, Y, Z) && ElectricItem.manager.use(itemstack, this.operationEnergyCost, (EntityLivingBase)player) && ElectricItem.manager.use(itemstack, this.operationEnergyCost, (EntityLivingBase)player)) {
            ArrayList drops = target.onSheared(itemstack, (IBlockAccess)player.field_70170_p, X, Y, Z, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemstack));
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(Item.field_77697_d.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(Item.field_77697_d.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d3 = (double)(Item.field_77697_d.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)X + d, (double)Y + d2, (double)Z + d3, stack);
                entityitem.field_145804_b = 10;
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            player.func_71064_a(StatList.field_75934_C[Block.func_149682_b((Block)id)], 1);
        }
        return false;
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
        boolean isEquipped;
        boolean bl = isEquipped = flag && entity instanceof EntityLivingBase;
        if (!isEquipped && !itemstack.func_82839_y()) {
            return;
        }
        if (IC2.platform.isRendering()) {
            if (isEquipped && !wasEquipped) {
                if (!itemstack.func_82839_y()) {
                    itemstack.func_82842_a(new EntityItemFrame(world));
                }
                if (audioSource == null) {
                    audioSource = IC2.audioManager.createSource(entity, PositionSpec.Hand, "Tools/Chainsaw/ChainsawIdle.ogg", true, false, IC2.audioManager.defaultVolume);
                }
                if (audioSource != null) {
                    audioSource.play();
                }
            } else if (!isEquipped && audioSource != null) {
                itemstack.func_82842_a(null);
                audioSource.stop();
                audioSource.remove();
                audioSource = null;
                if (entity instanceof EntityLivingBase) {
                    IC2.audioManager.playOnce(entity, PositionSpec.Hand, "Tools/Chainsaw/ChainsawStop.ogg", true, IC2.audioManager.defaultVolume);
                }
            } else if (audioSource != null) {
                audioSource.updatePosition();
            }
            wasEquipped = isEquipped;
        }
    }

    @Override
    public String getHitSoundForBlock(int x, int y, int z) {
        String[] soundEffects = new String[]{"Tools/Chainsaw/ChainsawUseOne.ogg", "Tools/Chainsaw/ChainsawUseTwo.ogg"};
        return soundEffects[Item.field_77697_d.nextInt(soundEffects.length)];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        return Ic2Icons.getTexture("i1")[this.iconIndex];
    }

    public float func_150893_a(ItemStack tool, Block block) {
        if (!ElectricItem.manager.canUse(tool, this.operationEnergyCost)) {
            return 1.0f;
        }
        if (ForgeHooks.isToolEffective((ItemStack)tool, (Block)block, (int)0)) {
            return this.field_77864_a;
        }
        if (this.canHarvestBlock(block, tool)) {
            return this.field_77864_a;
        }
        return 1.0f;
    }

    public float getDigSpeed(ItemStack tool, Block block, int md) {
        if (!ElectricItem.manager.canUse(tool, this.operationEnergyCost)) {
            return 1.0f;
        }
        if (ForgeHooks.isToolEffective((ItemStack)tool, (Block)block, (int)md)) {
            return this.field_77864_a;
        }
        if (this.canHarvestBlock(block, tool)) {
            return this.field_77864_a;
        }
        return 1.0f;
    }

    public String getTextureFile() {
        return "/ic2/sprites/item_0.png";
    }

    @Override
    public boolean canProvideEnergy(ItemStack par1) {
        return false;
    }

    @Override
    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    @Override
    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    @Override
    public double getMaxCharge(ItemStack par1) {
        return this.maxCharge;
    }

    @Override
    public int getTier(ItemStack par1) {
        return this.tier;
    }

    @Override
    public double getTransferLimit(ItemStack par1) {
        return this.transferLimit;
    }

    public Multimap func_111205_h() {
        Multimap multimap = super.func_111205_h();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.co, 0));
        return multimap;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_150894_a(ItemStack par1ItemStack, World par2World, Block par3, int par4, int par5, int par6, EntityLivingBase par7EntityLiving) {
        Block block = par2World.func_147439_a(par4, par5, par6);
        if (block == Blocks.field_150350_a) {
            IC2.getInstance();
            IC2.log.debug("ItemElectricTool.onBlockDestroyed(): received invalid block id " + par3);
            return false;
        }
        if ((double)block.func_149712_f(par2World, par4, par5, par6) != 0.0) {
            if (par7EntityLiving instanceof EntityPlayer) {
                ElectricItem.manager.use(par1ItemStack, this.operationEnergyCost, (EntityLivingBase)((EntityPlayer)par7EntityLiving));
            } else {
                ElectricItem.manager.discharge(par1ItemStack, this.operationEnergyCost, this.tier, true, false, false);
            }
        }
        return true;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item i, CreativeTabs tabs, List itemList) {
        ItemStack charged = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(charged, 2.147483647E9, Integer.MAX_VALUE, true, false);
        itemList.add(charged);
        itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister p_94581_1_) {
    }

    @Override
    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.digger;
    }

    @Override
    public boolean isSpecialSupport(ItemStack item, Enchantment ench) {
        return ench instanceof EnchantmentDamage;
    }

    @Override
    public boolean isExcluded(ItemStack item, Enchantment ench) {
        return false;
    }
}

