/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import ic2.core.IC2;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.item.tool.ItemScanner;
import ic2.core.util.IElectricHelper;
import ic2.core.util.IExtraData;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemScanners
extends ItemScanner
implements IExtraData,
ISpecialElectricItem {
    private IElectricItemManager manager = new ScannerManager();

    public ItemScanners(int index) {
        super(index, 2);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b("itemMetaScanners");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1, EntityPlayer par2, List par3, boolean par4) {
        if (this.getType(par1) == ScannerType.SettedOV) {
            par3.add(StatCollector.func_74837_a((String)"itemInfo.scannerLevel.name", (Object[])new Object[]{this.getScanningLevel(par1)}));
        }
        if (par1.func_77960_j() > 3) {
            if (GuiScreen.func_146272_n()) {
                par3.add(StatCollector.func_74838_a((String)"itemInfo.scannerOres.name"));
                par3.addAll(this.getOresFromType(this.getType(par1), par1));
            } else {
                par3.add(StatCollector.func_74837_a((String)"itemInfo.pressShiftOreInfo.name", (Object[])new Object[]{EnumChatFormatting.AQUA, EnumChatFormatting.GRAY}));
            }
        }
    }

    public List<String> getOresFromType(ScannerType par1, ItemStack par2) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        switch (par1) {
            case HighOV: {
                List<ItemStack> pos;
                for (int i = 5; i <= IC2.maxOreValue; ++i) {
                    pos = IC2.oreValues.get(i);
                    if (pos == null || pos.size() <= 0) continue;
                    items.addAll(pos);
                }
                break;
            }
            case LowOV: {
                List<ItemStack> pos;
                for (int i = 0; i <= 2; ++i) {
                    pos = IC2.oreValues.get(i);
                    if (pos == null || pos.size() <= 0) continue;
                    items.addAll(pos);
                }
                break;
            }
            case MedOV: {
                List<ItemStack> pos;
                for (int i = 3; i <= 4; ++i) {
                    pos = IC2.oreValues.get(i);
                    if (pos == null || pos.size() <= 0) continue;
                    items.addAll(pos);
                }
                break;
            }
            case SettedOV: {
                List<ItemStack> pos = IC2.oreValues.get(this.getScanningLevel(par2));
                if (pos == null || pos.size() <= 0) break;
                items.addAll(pos);
                break;
            }
        }
        ArrayList<String> results = new ArrayList<String>();
        ArrayList<String> oreNames = new ArrayList<String>();
        for (int i = 0; i < items.size(); ++i) {
            try {
                String text;
                ItemStack item = (ItemStack)items.get(i);
                boolean found = false;
                for (int id : OreDictionary.getOreIDs((ItemStack)item)) {
                    String oreID = OreDictionary.getOreName((int)id);
                    if (oreNames.contains(oreID)) {
                        found = true;
                        break;
                    }
                    oreNames.add(oreID);
                }
                if (found || results.contains(text = item.func_82833_r())) continue;
                results.add(text);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return results;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        return Ic2Icons.getTexture("i1")[this.iconIndex + par1];
    }

    public String func_77667_c(ItemStack item) {
        return "item." + this.getType(item).getName();
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List itemList) {
        for (ScannerType type : ScannerType.values()) {
            ItemStack empty = new ItemStack(par1, 1, type.ordinal());
            ItemStack full = new ItemStack(par1, 1, type.ordinal());
            ElectricItem.manager.charge(full, 2.147483647E9, Integer.MAX_VALUE, true, false);
            itemList.add(empty);
            itemList.add(full);
        }
    }

    @Override
    protected int valueOfArea(ItemStack stack, World worldObj, int x, int y, int z, int range, boolean oreValue) {
        ScannerType type = this.getType(stack);
        if (type == ScannerType.LowOV || type == ScannerType.MedOV || type == ScannerType.HighOV || type == ScannerType.SettedOV) {
            int totalScore = 0;
            int blocksScanned = 0;
            for (int blockY = y; blockY > 0; --blockY) {
                for (int blockX = x - range; blockX <= x + range; ++blockX) {
                    for (int blockZ = z - range; blockZ <= z + range; ++blockZ) {
                        int metaData;
                        Block blockId = worldObj.func_147439_a(blockX, blockY, blockZ);
                        if (this.isValuableOre(stack, blockId, metaData = worldObj.func_72805_g(blockX, blockY, blockZ))) {
                            ++totalScore;
                        }
                        ++blocksScanned;
                    }
                }
            }
            return blocksScanned > 0 ? (int)(1000.0 * (double)totalScore / (double)blocksScanned) : 0;
        }
        return super.valueOfArea(stack, worldObj, x, y, z, range, oreValue);
    }

    @Override
    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (entityplayer.func_70093_af() && this.getType(itemstack) == ScannerType.SettedOV) {
            if (world.field_72995_K) {
                return itemstack;
            }
            int scanningLevel = this.getScanningLevel(itemstack);
            if (++scanningLevel > IC2.maxOreValue) {
                scanningLevel = 0;
            }
            this.setScanningLevel(itemstack, scanningLevel);
            IC2.platform.messagePlayer(entityplayer, "[Scanner]: Setted Scanning Level to: " + scanningLevel);
            return itemstack;
        }
        return super.func_77659_a(itemstack, world, entityplayer);
    }

    @Override
    public int getRange(ItemStack par1) {
        return this.getType(par1).getRange();
    }

    @Override
    public boolean searchOreValue(ItemStack par1) {
        return this.getType(par1).isOreValue();
    }

    @Override
    public int getEnergyCost(ItemStack par1) {
        return this.getType(par1).getEUCost();
    }

    @Override
    public int getOreValue(ItemStack par1, Block block, int metaData) {
        ScannerType type = this.getType(par1);
        int value = super.getOreValue(par1, block, metaData);
        if (type == ScannerType.LowOV) {
            return value <= 2 ? 1 : 0;
        }
        if (type == ScannerType.MedOV) {
            return value > 2 && value <= 4 ? 1 : 0;
        }
        if (type == ScannerType.HighOV) {
            return value > 4 ? 1 : 0;
        }
        if (type == ScannerType.SettedOV) {
            return value == this.getScanningLevel(par1) ? 1 : 0;
        }
        return value;
    }

    private ScannerType getType(ItemStack par1) {
        return ScannerType.values()[par1.func_77960_j()];
    }

    private int getScanningLevel(ItemStack par1) {
        return StackUtil.getOrCreateNbtData(par1).func_74762_e("ScanLevel");
    }

    private void setScanningLevel(ItemStack par1, int lvl) {
        StackUtil.getOrCreateNbtData(par1).func_74768_a("ScanLevel", lvl);
    }

    @Override
    public void init() {
        Ic2Items.rangedODScanner = new ItemStack((Item)this, 1, 0);
        Ic2Items.rangedOVScanner = new ItemStack((Item)this, 1, 1);
        Ic2Items.bigRangedODScanner = new ItemStack((Item)this, 1, 2);
        Ic2Items.bigRangedOVScanner = new ItemStack((Item)this, 1, 3);
        Ic2Items.lowOreValueScanner = new ItemStack((Item)this, 1, 4);
        Ic2Items.medOreValueScanner = new ItemStack((Item)this, 1, 5);
        Ic2Items.highOreValueScanner = new ItemStack((Item)this, 1, 6);
        Ic2Items.setOreValueScanner = new ItemStack((Item)this, 1, 7);
    }

    @Override
    public IElectricItemManager getManager(ItemStack itemStack) {
        return this.manager;
    }

    public class ScannerManager
    implements IElectricItemManager {
        @Override
        public double charge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
            IElectricItem item = (IElectricItem)stack.func_77973_b();
            assert (item.getMaxCharge(stack) > 0.0);
            if (amount < 0.0 || stack.field_77994_a > 1 || item.getTier(stack) > tier) {
                return 0.0;
            }
            if (!ignoreTransferLimit && amount > item.getTransferLimit(stack)) {
                amount = item.getTransferLimit(stack);
            }
            NBTTagCompound tNBT = StackUtil.getOrCreateNbtData(stack);
            int tNewCharge = tNBT.func_74762_e("charge");
            if (amount > item.getMaxCharge(stack) - (double)tNewCharge) {
                amount = item.getMaxCharge(stack) - (double)tNewCharge;
            }
            if (!simulate) {
                if ((tNewCharge = (int)((double)tNewCharge + amount)) > 0) {
                    tNBT.func_74768_a("charge", tNewCharge);
                } else {
                    tNBT.func_82580_o("charge");
                    if (tNBT.func_150296_c().isEmpty()) {
                        stack.func_77982_d(null);
                    }
                }
            }
            return amount;
        }

        @Override
        public double discharge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
            NBTTagCompound tNBT;
            int tNewCharge;
            IElectricItem item = (IElectricItem)stack.func_77973_b();
            assert (item.getMaxCharge(stack) > 0.0);
            if (amount < 0.0 || stack.field_77994_a > 1 || item.getTier(stack) > tier) {
                return 0.0;
            }
            if (externally && !item.canProvideEnergy(stack)) {
                return 0.0;
            }
            if (!ignoreTransferLimit && amount > item.getTransferLimit(stack)) {
                amount = item.getTransferLimit(stack);
            }
            if (amount > (double)(tNewCharge = (tNBT = StackUtil.getOrCreateNbtData(stack)).func_74762_e("charge"))) {
                amount = tNewCharge;
            }
            if (!simulate) {
                if ((tNewCharge = (int)((double)tNewCharge - amount)) > 0) {
                    tNBT.func_74768_a("charge", tNewCharge);
                } else {
                    tNBT.func_82580_o("charge");
                    if (tNBT.func_150296_c().isEmpty()) {
                        stack.func_77982_d(null);
                    }
                }
            }
            return amount;
        }

        @Override
        public double getCharge(ItemStack stack) {
            return ElectricItem.manager.discharge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false, true);
        }

        @Override
        public boolean canUse(ItemStack stack, double amount) {
            return ElectricItem.manager.getCharge(stack) >= amount;
        }

        @Override
        public boolean use(ItemStack stack, double amount, EntityLivingBase entity) {
            if (!IC2.platform.isSimulating()) {
                return false;
            }
            ElectricItem.manager.chargeFromArmor(stack, entity);
            double transfer = ElectricItem.manager.discharge(stack, amount, Integer.MAX_VALUE, true, false, true);
            if (transfer == amount) {
                ElectricItem.manager.discharge(stack, amount, Integer.MAX_VALUE, true, false, false);
                ElectricItem.manager.chargeFromArmor(stack, entity);
                return true;
            }
            return false;
        }

        @Override
        public void chargeFromArmor(ItemStack stack, EntityLivingBase entity) {
            if (!IC2.platform.isSimulating() || entity == null) {
                return;
            }
            boolean inventoryChanged = false;
            if (entity instanceof EntityPlayer && IC2.modul.containsKey("Baubles Modul")) {
                inventoryChanged = ((IElectricHelper)((Object)IC2.modul.get("Baubles Modul"))).chargeFromArmor(stack, (EntityPlayer)entity);
            }
            for (int i = 0; i < 4; ++i) {
                IElectricItem armorItem;
                ItemStack armorItemStack = entity.func_71124_b(i + 1);
                if (armorItemStack == null || !(armorItemStack.func_77973_b() instanceof IElectricItem) || !(armorItem = (IElectricItem)armorItemStack.func_77973_b()).canProvideEnergy(armorItemStack) || armorItem.getTier(armorItemStack) < ((IElectricItem)stack.func_77973_b()).getTier(stack)) continue;
                double transfer = ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, true);
                if (!((transfer = ElectricItem.manager.discharge(armorItemStack, transfer, Integer.MAX_VALUE, true, true, false)) > 0.0)) continue;
                ElectricItem.manager.charge(stack, transfer, Integer.MAX_VALUE, true, false);
                inventoryChanged = true;
            }
            if (inventoryChanged && entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).field_71070_bA.func_75142_b();
            }
        }

        @Override
        public String getToolTip(ItemStack stack) {
            IElectricItem item = (IElectricItem)stack.func_77973_b();
            return ElectricItem.manager.getCharge(stack) + "/" + item.getMaxCharge(stack) + " EU";
        }
    }

    public static enum ScannerType {
        RangedOD(7, false, 150, "rangedScanner.OD"),
        RangedOV(8, true, 750, "rangedScanner.OV"),
        BigRangedOD(9, false, 300, "bigRangedScanner.OD"),
        BigRangedOV(10, true, 1750, "bigRangedScanner.OV"),
        LowOV(6, false, 600, "LowOreValueScanner"),
        MedOV(6, false, 800, "MedOreValueScanner"),
        HighOV(6, false, 1000, "HighOreValueScanner"),
        SettedOV(6, false, 1250, "settedOreValueScanner");

        int range;
        int cost;
        boolean oreValue;
        String name;

        private ScannerType(int range, boolean oreValue, int cost, String name) {
            this.range = range;
            this.oreValue = oreValue;
            this.cost = cost;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getRange() {
            return this.range;
        }

        public boolean isOreValue() {
            return this.oreValue;
        }

        public int getEUCost() {
            return this.cost;
        }
    }
}

