/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.event.RetextureEvent;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.item.BasicElectricItem;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class ItemTextureCopier
extends BasicElectricItem {
    public static final int copyCost = 10000;
    public static final int drawCost = 1500;

    public ItemTextureCopier() {
        super(81);
        this.setSpriteID("i1");
        this.maxCharge = 100000;
        this.tier = 2;
        this.transferLimit = 250;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        if (ItemTextureCopier.hasBlock(stack)) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
            Block block = Block.func_149684_b((String)nbt.func_74779_i("BlockID"));
            int meta = nbt.func_74762_e("BlockMeta");
            int blockSide = nbt.func_74762_e("BlockSide");
            list.add(StatCollector.func_74837_a((String)"itemInfo.storedBlock.name", (Object[])new Object[]{new ItemStack(block, 1, meta).func_82833_r()}));
            list.add(StatCollector.func_74837_a((String)"itemInfo.storedBlockSide.name", (Object[])new Object[]{blockSide}));
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (IC2.platform.isRendering()) {
            if (player.func_70093_af()) {
                if (!ElectricItem.manager.canUse(stack, 10000.0)) {
                    return true;
                }
                Block block = world.func_147439_a(x, y, z);
                if (!world.func_147437_c(x, y, z) && this.isValidBlock(block)) {
                    int meta = world.func_72805_g(x, y, z);
                    try {
                        IIcon texture = block.func_149691_a(side, meta);
                        IIcon worldTexture = block.func_149673_e((IBlockAccess)world, x, y, z, side);
                        return texture == null || texture != worldTexture || ItemTextureCopier.isMissingTexture(texture);
                    }
                    catch (Exception texture) {
                        // empty catch block
                    }
                }
                return false;
            }
        } else if (player.func_70093_af()) {
            if (!ElectricItem.manager.canUse(stack, 10000.0)) {
                return false;
            }
            Block block = world.func_147439_a(x, y, z);
            if (!world.func_147437_c(x, y, z) && this.isValidBlock(block)) {
                NBTTagCompound nbt;
                int meta = world.func_72805_g(x, y, z);
                String blockID = Block.field_149771_c.func_148750_c((Object)block);
                if (blockID == (nbt = StackUtil.getOrCreateNbtData(stack)).func_74779_i("BlockID") && meta == nbt.func_74762_e("BlockMeta") && side == nbt.func_74762_e("BlockSide")) {
                    return false;
                }
                nbt.func_74778_a("BlockID", blockID);
                nbt.func_74768_a("BlockMeta", meta);
                nbt.func_74768_a("BlockSide", side);
                ElectricItem.manager.use(stack, 10000.0, (EntityLivingBase)player);
                return true;
            }
        } else {
            if (!ElectricItem.manager.canUse(stack, 1500.0) || !ItemTextureCopier.hasBlock(stack)) {
                return false;
            }
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
            Block block = Block.func_149684_b((String)nbt.func_74779_i("BlockID"));
            int meta = nbt.func_74762_e("BlockMeta");
            int blockSide = nbt.func_74762_e("BlockSide");
            RetextureEvent event = new RetextureEvent(world, x, y, z, side, block, meta, blockSide);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.applied) {
                ElectricItem.manager.use(stack, 1500.0, (EntityLivingBase)player);
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean isValidBlock(Block block) {
        return block.func_149686_d();
    }

    public static boolean hasBlock(ItemStack item) {
        if (item == null) {
            return false;
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(item);
        return nbt.func_74764_b("BlockID");
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isMissingTexture(IIcon par1) {
        TextureAtlasSprite result = Minecraft.func_71410_x().func_147117_R().func_110572_b(par1.func_94215_i());
        return result.func_94215_i().equalsIgnoreCase("missingno");
    }
}

