/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.IPacketEnergyNet;
import ic2.api.energy.NodeStats;
import ic2.api.energy.PacketStat;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.core.IC2;
import ic2.core.block.machine.tileentity.TileEntityTeleporter;
import ic2.core.item.ItemIC2;
import ic2.core.util.KeyboardClient;
import ic2.core.util.StackUtil;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemToolMeter
extends ItemIC2 {
    public ItemToolMeter(int index) {
        super(index);
        this.field_77777_bU = 1;
        this.func_77656_e(0);
        this.setSpriteID("i1");
    }

    public ItemStack func_77659_a(ItemStack par1, World par2, EntityPlayer par3) {
        if (!par2.field_72995_K && IC2.keyboard.isModeSwitchKeyDown(par3)) {
            int meta = par1.func_77960_j() + 1;
            if (meta >= MeasuringMode.values().length) {
                meta = 0;
            }
            par1.func_77964_b(meta);
            IC2.platform.messagePlayer(par3, StatCollector.func_74837_a((String)"itemInfo.energyMeterModeChanged.name", (Object[])new Object[]{MeasuringMode.values()[meta].getName()}));
            return par1;
        }
        return par1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack p_77624_1_, EntityPlayer p_77624_2_, List p_77624_3_, boolean p_77624_4_) {
        super.func_77624_a(p_77624_1_, p_77624_2_, p_77624_3_, p_77624_4_);
        p_77624_3_.add(StatCollector.func_74837_a((String)"itemInfo.energyMeterModeSwitchHelp.name", (Object[])new Object[]{((KeyboardClient)IC2.keyboard).getKey(2)}));
        p_77624_3_.add(StatCollector.func_74837_a((String)"itemInfo.energyMeterMode.name", (Object[])new Object[]{MeasuringMode.values()[p_77624_1_.func_77960_j()].getName()}));
    }

    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l, float hitX, float hitY, float hitZ) {
        MeasuringMode mode = MeasuringMode.values()[itemstack.func_77960_j()];
        if (!IC2.keyboard.isModeSwitchKeyDown(entityplayer) && IC2.platform.isSimulating()) {
            TileEntity tileEntity = EnergyNet.instance.getTileEntity(world, i, j, k);
            if (tileEntity instanceof IEnergySource || tileEntity instanceof IEnergyConductor || tileEntity instanceof IEnergySink) {
                if (mode == MeasuringMode.EUAverageReading) {
                    NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemstack);
                    NodeStats node = EnergyNet.instance.getNodeStats(tileEntity);
                    double currentTotalEnergyEmitted = node.getEnergyOut();
                    double currentTotalEnergySunken = node.getEnergyIn();
                    long currentMeasureTime = world.func_82737_E();
                    if (nbtData.func_74762_e("lastMeasuredTileEntityX") != i || nbtData.func_74762_e("lastMeasuredTileEntityY") != j || nbtData.func_74762_e("lastMeasuredTileEntityZ") != k) {
                        nbtData.func_74768_a("lastMeasuredTileEntityX", i);
                        nbtData.func_74768_a("lastMeasuredTileEntityY", j);
                        nbtData.func_74768_a("lastMeasuredTileEntityZ", k);
                        IC2.platform.messagePlayer(entityplayer, StatCollector.func_74838_a((String)"itemInfo.energyMeterNewMeasurment.name"));
                    } else {
                        long measurePeriod = currentMeasureTime - nbtData.func_74763_f("lastMeasureTime");
                        if (measurePeriod < 1L) {
                            measurePeriod = 1L;
                        }
                        double deltaEmitted = (currentTotalEnergyEmitted - nbtData.func_74769_h("lastTotalEnergyEmitted")) / (double)measurePeriod;
                        double deltaSunken = (currentTotalEnergySunken - nbtData.func_74769_h("lastTotalEnergySunken")) / (double)measurePeriod;
                        DecimalFormat powerFormat = new DecimalFormat("0.##");
                        IC2.platform.messagePlayer(entityplayer, StatCollector.func_74837_a((String)"itemInfo.energyMeterAverageEU.name", (Object[])new Object[]{powerFormat.format(deltaSunken), powerFormat.format(deltaEmitted), powerFormat.format(deltaSunken - deltaEmitted), measurePeriod}));
                    }
                    nbtData.func_74780_a("lastTotalEnergyEmitted", currentTotalEnergyEmitted);
                    nbtData.func_74780_a("lastTotalEnergySunken", currentTotalEnergySunken);
                    nbtData.func_74772_a("lastMeasureTime", currentMeasureTime);
                    return true;
                }
                if (mode == MeasuringMode.TileInfo) {
                    if (tileEntity instanceof IEnergySource) {
                        int offer = (int)((IEnergySource)tileEntity).getOfferedEnergy();
                        IC2.platform.messagePlayer(entityplayer, StatCollector.func_74837_a((String)"itemInfo.energyMeterSourceInfo.name", (Object[])new Object[]{offer}));
                    }
                    if (tileEntity instanceof IEnergySink) {
                        int safeInput = (int)EnergyNet.instance.getPowerFromTier(((IEnergySink)tileEntity).getSinkTier());
                        IC2.platform.messagePlayer(entityplayer, StatCollector.func_74837_a((String)"itemInfo.energyMeterSinkInfo.name", (Object[])new Object[]{safeInput}));
                    }
                    if (tileEntity instanceof IEnergyConductor) {
                        double Powerloss = ((IEnergyConductor)tileEntity).getConductionLoss();
                        int conductorBreakdown = (int)((IEnergyConductor)tileEntity).getConductorBreakdownEnergy() - 1;
                        IC2.platform.messagePlayer(entityplayer, StatCollector.func_74837_a((String)"itemInfo.energyMeterConductorLoss.name", (Object[])new Object[]{Powerloss}));
                        IC2.platform.messagePlayer(entityplayer, StatCollector.func_74837_a((String)"itemInfo.energyMeterConductorLimit.name", (Object[])new Object[]{conductorBreakdown}));
                    }
                    return true;
                }
                if (mode == MeasuringMode.TotalEmitted) {
                    NodeStats stats = EnergyNet.instance.getNodeStats(tileEntity);
                    DecimalFormat powerFormat = new DecimalFormat("0.##");
                    IC2.platform.messagePlayer(entityplayer, StatCollector.func_74837_a((String)"itemInfo.energyMeterTotalEmitted.name", (Object[])new Object[]{powerFormat.format(stats.getEnergyOut())}));
                    return true;
                }
                if (mode == MeasuringMode.PacketReading) {
                    NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemstack);
                    List<PacketStat> packets = ((IPacketEnergyNet)EnergyNet.instance).getSendedPackets(tileEntity);
                    long currentMeasureTime = world.func_82737_E();
                    if (nbtData.func_74762_e("lastMeasuredTileEntityX") != i || nbtData.func_74762_e("lastMeasuredTileEntityY") != j || nbtData.func_74762_e("lastMeasuredTileEntityZ") != k) {
                        nbtData.func_74768_a("lastMeasuredTileEntityX", i);
                        nbtData.func_74768_a("lastMeasuredTileEntityY", j);
                        nbtData.func_74768_a("lastMeasuredTileEntityZ", k);
                        IC2.platform.messagePlayer(entityplayer, StatCollector.func_74838_a((String)"itemInfo.energyMeterNewMeasurment.name"));
                    } else {
                        long measurePeriod = currentMeasureTime - nbtData.func_74763_f("lastMeasureTime");
                        if (measurePeriod < 1L) {
                            measurePeriod = 1L;
                        }
                        DecimalFormat powerFormat = new DecimalFormat("0.##");
                        IC2.platform.messagePlayer(entityplayer, StatCollector.func_74837_a((String)"itemInfo.energyMeterAveragePacket.name", (Object[])new Object[]{measurePeriod}));
                        if (packets.isEmpty()) {
                            IC2.platform.messagePlayer(entityplayer, StatCollector.func_74838_a((String)"itemInfo.energyMeterNone.name"));
                        } else {
                            for (PacketStat stat : packets) {
                                IC2.platform.messagePlayer(entityplayer, StatCollector.func_74837_a((String)"itemInfo.energyMeterEUPacket.name", (Object[])new Object[]{powerFormat.format(stat.getPacketEnergy()), stat.getPacketCount()}));
                            }
                        }
                    }
                    nbtData.func_74772_a("lastMeasureTime", currentMeasureTime);
                    return true;
                }
                if (mode == MeasuringMode.TotalPackets) {
                    List<PacketStat> packets = ((IPacketEnergyNet)EnergyNet.instance).getTotalSendedPackets(tileEntity);
                    DecimalFormat powerFormat = new DecimalFormat("0.##");
                    IC2.platform.messagePlayer(entityplayer, StatCollector.func_74838_a((String)"itemInfo.energyMeterTotalPacket.name"));
                    if (packets.isEmpty()) {
                        IC2.platform.messagePlayer(entityplayer, StatCollector.func_74838_a((String)"itemInfo.energyMeterNone.name"));
                    } else {
                        for (PacketStat stat : packets) {
                            IC2.platform.messagePlayer(entityplayer, StatCollector.func_74837_a((String)"itemInfo.energyMeterEUPacket.name", (Object[])new Object[]{powerFormat.format(stat.getPacketEnergy()), stat.getPacketCount()}));
                        }
                    }
                    return true;
                }
            }
            if (mode == MeasuringMode.TileInfo && (tileEntity = world.func_147438_o(i, j, k)) instanceof TileEntityTeleporter) {
                TileEntityTeleporter tele = (TileEntityTeleporter)tileEntity;
                List list = world.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)i, (double)(j + 1), (double)k, (double)(i + 1), (double)(j + 2), (double)(k + 1)));
                EntityPlayer entity = entityplayer;
                if (list.size() == 1) {
                    entity = (Entity)list.get(0);
                }
                if (tele.targetSet) {
                    int weight = tele.getWeightOf((Entity)entity);
                    double distance = tele.getDistance();
                    int energyCost = (int)((double)weight * Math.pow(distance + 10.0, 0.7) * 5.0);
                    String s = "energyMeterTeleporterInfoCost";
                    if (tele.isDimSwtich()) {
                        energyCost *= 10;
                        s = s + "Dim";
                    }
                    DecimalFormat powerFormat = new DecimalFormat("0.##");
                    IC2.platform.messagePlayer(entityplayer, StatCollector.func_74837_a((String)"itemInfo.energyMeterTeleporterInfoEntity.name", (Object[])new Object[]{entity instanceof EntityPlayer ? "Player" : EntityList.func_75621_b((Entity)entity), weight}));
                    IC2.platform.messagePlayer(entityplayer, StatCollector.func_74837_a((String)("itemInfo." + s + ".name"), (Object[])new Object[]{powerFormat.format(distance), energyCost}));
                }
                return true;
            }
        }
        return false;
    }

    public static enum MeasuringMode {
        EUAverageReading("measureMode.averageEU.name"),
        TileInfo("measureMode.tileInfo.name"),
        TotalEmitted("measureMode.totalEmitted.name"),
        PacketReading("measureMode.packetReading.name"),
        TotalPackets("measureMode.totalPackets.name");

        String name;

        private MeasuringMode(String par1) {
            this.name = par1;
        }

        public String getName() {
            return StatCollector.func_74838_a((String)this.name);
        }
    }
}

