/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricTool;
import ic2.core.IC2;
import ic2.core.item.tool.ItemToolWrench;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemToolWrenchElectric
extends ItemToolWrench
implements IElectricTool {
    public ItemToolWrenchElectric(int index) {
        super(index);
        this.func_77656_e(27);
        this.func_77625_d(1);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (IC2.platform.isSimulating() && IC2.keyboard.isModeSwitchKeyDown(entityplayer)) {
            NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemstack);
            boolean newValue = !nbtData.func_74767_n("losslessMode");
            nbtData.func_74757_a("losslessMode", newValue);
            if (newValue) {
                IC2.platform.messagePlayer(entityplayer, StatCollector.func_74838_a((String)"itemInfo.losslessWrenchModeEnabled.name"));
            } else {
                IC2.platform.messagePlayer(entityplayer, StatCollector.func_74838_a((String)"itemInfo.losslessWrenchModeDisabled.name"));
            }
        }
        return itemstack;
    }

    @Override
    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return !IC2.keyboard.isModeSwitchKeyDown(entityPlayer) && super.onItemUseFirst(itemstack, entityPlayer, world, x, y, z, side, hitX, hitY, hitZ);
    }

    @Override
    public boolean canTakeDamage(ItemStack stack, int amount) {
        return ElectricItem.manager.discharge(stack, amount *= 50, Integer.MAX_VALUE, true, false, true) == (double)amount;
    }

    @Override
    public void damage(ItemStack itemStack, int amount, EntityPlayer player) {
        ElectricItem.manager.use(itemStack, 50 * amount, (EntityLivingBase)player);
    }

    @Override
    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    @Override
    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    @Override
    public boolean canProvideEnergy(ItemStack par1) {
        return false;
    }

    @Override
    public double getMaxCharge(ItemStack par1) {
        return 12000.0;
    }

    @Override
    public int getTier(ItemStack par1) {
        return 1;
    }

    @Override
    public double getTransferLimit(ItemStack par1) {
        return 250.0;
    }

    public void func_150895_a(Item i, CreativeTabs tabs, List itemList) {
        ItemStack charged = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(charged, 2.147483647E9, Integer.MAX_VALUE, true, false);
        itemList.add(charged);
        itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    @Override
    public boolean overrideWrenchSuccessRate(ItemStack itemStack) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        return nbtData.func_74767_n("losslessMode");
    }

    @Override
    public double getModifier(ItemStack stack) {
        return 1.1;
    }

    @Override
    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.breakable;
    }

    @Override
    public boolean isSpecialSupport(ItemStack item, Enchantment ench) {
        return ench == Enchantment.field_77346_s;
    }

    public boolean func_82789_a(ItemStack p_82789_1_, ItemStack p_82789_2_) {
        return false;
    }

    @Override
    public boolean isExcluded(ItemStack item, Enchantment ench) {
        return false;
    }
}

