/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades;

import ic2.api.Direction;
import ic2.api.tile.IMachine;
import ic2.core.Ic2Icons;
import ic2.core.block.inventory.filter.BackupItemFilter;
import ic2.core.block.personal.IPersonalBlock;
import ic2.core.item.upgrades.BaseMetaUpgrade;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;

public class ExportUpgrade
extends BaseMetaUpgrade {
    @Override
    public boolean onTick(ItemStack upgrade, IMachine machine) {
        TileEntity tile;
        Direction dir;
        if (!machine.isProcessing() && this.getWorldTime(machine) % 20L == 0L && (dir = this.getDirection(upgrade)) != null && (tile = dir.applyToTileEntity((TileEntity)machine)) != null && (tile instanceof IInventory || tile instanceof IPersonalBlock)) {
            int added;
            int aviableItems = Math.min(64, (int)(machine.getEnergy() * 3.0));
            BackupItemFilter filter = new BackupItemFilter(null);
            ItemStack stack = StackUtil.getFromInventory(machine, dir, this.getOwner(upgrade), filter, aviableItems, false);
            if (stack != null && (added = StackUtil.putInInventory(tile, dir.getInverse(), this.getOwner(upgrade), stack)) > 0) {
                StackUtil.getFromInventory(machine, dir, this.getOwner(upgrade), filter, added, true);
                machine.useEnergy(added / 3, false);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean needsTick() {
        return true;
    }

    @Override
    public void onProcessEnd(ItemStack upgrade, IMachine machine, List<ItemStack> results) {
        TileEntity tile;
        Direction dir = this.getDirection(upgrade);
        if (dir != null && (tile = dir.applyToTileEntity((TileEntity)machine)) != null && (tile instanceof IInventory || tile instanceof IPersonalBlock)) {
            int aviableItems = Math.min(64, (int)(machine.getEnergy() * 3.0));
            int itemsAdded = 0;
            ArrayList<ItemStack> left = new ArrayList<ItemStack>();
            while (!results.isEmpty() && aviableItems > 0) {
                ItemStack item = results.remove(0);
                if (item == null) continue;
                ItemStack copy = item.func_77946_l();
                copy.field_77994_a = Math.min(aviableItems, item.field_77994_a);
                int added = StackUtil.putInInventory(tile, dir.getInverse(), this.getOwner(upgrade), copy);
                if (added > 0) {
                    item.field_77994_a -= added;
                    aviableItems -= added;
                    itemsAdded += added;
                    if (item.field_77994_a <= 0) continue;
                }
                left.add(item);
            }
            machine.useEnergy(Math.max(1, itemsAdded / 3), false);
            if (!left.isEmpty()) {
                results.addAll(left);
            }
        }
    }

    @Override
    public IMachine.UpgradeType getType() {
        return IMachine.UpgradeType.ImportExport;
    }

    @Override
    public String getName() {
        return "itemExportUpgrade";
    }

    @Override
    public IIcon getTexture() {
        return Ic2Icons.getTexture("i0")[136];
    }

    @Override
    public boolean usesOwner() {
        return true;
    }

    @Override
    public boolean usesDirection() {
        return true;
    }
}

