/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades;

import ic2.api.Direction;
import ic2.api.tile.IMachine;
import ic2.core.Ic2Icons;
import ic2.core.block.inventory.filter.MachineFilter;
import ic2.core.block.personal.IPersonalBlock;
import ic2.core.item.upgrades.BaseMetaUpgrade;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;

public class ImportUpgrade
extends BaseMetaUpgrade {
    @Override
    public boolean onTick(ItemStack upgrade, IMachine machine) {
        TileEntity tile;
        Direction dir;
        if (!machine.isProcessing() && this.getWorldTime(machine) % 20L == 0L && (dir = this.getDirection(upgrade)) != null && (tile = dir.applyToTileEntity((TileEntity)machine)) != null && (tile instanceof IInventory || tile instanceof IPersonalBlock)) {
            int added;
            int amount = Math.min(64, (int)(machine.getEnergy() * 3.0));
            MachineFilter filter = new MachineFilter(machine);
            ItemStack item = StackUtil.getFromInventory(tile, dir, this.getOwner(upgrade), filter, amount, false);
            if (item != null && (added = StackUtil.putInInventory(machine, dir.getInverse(), this.getOwner(upgrade), item)) > 0) {
                StackUtil.getFromInventory(tile, dir, this.getOwner(upgrade), filter, added, true);
                machine.useEnergy(Math.max(1, added / 3), false);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean needsTick() {
        return true;
    }

    @Override
    public void onProcessEnd(ItemStack upgrade, IMachine machine, List<ItemStack> results) {
        TileEntity tile;
        Direction dir = this.getDirection(upgrade);
        if (dir != null && (tile = dir.applyToTileEntity((TileEntity)machine)) != null && (tile instanceof IInventory || tile instanceof IPersonalBlock)) {
            int added;
            int amount = Math.min(64, (int)(machine.getEnergy() * 3.0));
            MachineFilter filter = new MachineFilter(machine);
            ItemStack item = StackUtil.getFromInventory(tile, dir, this.getOwner(upgrade), filter, amount, false);
            if (item != null && (added = StackUtil.putInInventory(machine, dir.getInverse(), this.getOwner(upgrade), item)) > 0) {
                StackUtil.getFromInventory(tile, dir, this.getOwner(upgrade), filter, added, true);
                machine.useEnergy(Math.max(1, added / 3), false);
            }
        }
    }

    @Override
    public IMachine.UpgradeType getType() {
        return IMachine.UpgradeType.ImportExport;
    }

    @Override
    public IIcon getTexture() {
        return Ic2Icons.getTexture("i0")[134];
    }

    @Override
    public String getName() {
        return "itemImportUpgrade";
    }

    @Override
    public boolean usesOwner() {
        return true;
    }

    @Override
    public boolean usesDirection() {
        return true;
    }
}

