/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkDataProvider;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.network.NetworkManager;
import ic2.core.network.PacketManager;
import ic2.core.network.internal.INetworkGuiDataProvider;
import ic2.core.network.packets.IC2Packet;
import ic2.core.network.packets.client.FieldRequestPacket;
import ic2.core.network.packets.client.ItemClientEventPacket;
import ic2.core.network.packets.client.KeyboardPacket;
import ic2.core.network.packets.client.LoginPacket;
import ic2.core.network.packets.client.TileClientEventPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class NetworkManagerClient
extends NetworkManager {
    @Override
    public void requestInitialData(INetworkDataProvider dataProvider) {
        if (IC2.platform.isSimulating()) {
            return;
        }
        if (dataProvider instanceof TileEntity) {
            TileEntity te = (TileEntity)dataProvider;
            FieldRequestPacket packet = new FieldRequestPacket(te);
            PacketManager.instance.sendToServer(packet);
        } else {
            IC2.platform.displayError("An unknown network data provider attempted to request data from the\nmultiplayer server.\nThis could happen due to a bug.\n\n(Technical information: " + dataProvider + ")");
        }
    }

    @Override
    public void initiateClientItemEvent(ItemStack itemStack, int event) {
        ItemClientEventPacket packet = new ItemClientEventPacket(itemStack, event);
        PacketManager.instance.sendToServer(packet);
    }

    @Override
    public void initiateKeyUpdate(int keyState) {
        KeyboardPacket packet = new KeyboardPacket(keyState);
        PacketManager.instance.sendToServer(packet);
    }

    @Override
    public void initiateClientTileEntityEvent(TileEntity te, int event) {
        TileClientEventPacket packet = new TileClientEventPacket(te, event);
        PacketManager.instance.sendToServer(packet);
    }

    @Override
    public void sendLoginData() {
        LoginPacket packet = new LoginPacket(IC2.enableQuantumSpeedOnSprint);
        PacketManager.instance.sendToServer(packet);
    }

    @Override
    public void sendInitialData(EntityPlayerMP mp, TileEntity tile) {
    }

    @Override
    public void announceBlockUpdate(World world, int x, int y, int z) {
        if (IC2.platform.isSimulating()) {
            super.announceBlockUpdate(world, x, y, z);
        }
    }

    @Override
    public void updateTileEntityField(TileEntity te, String field) {
    }

    @Override
    public void initiateTileEntityEvent(TileEntity te, int event, boolean limitRange) {
    }

    @Override
    public void initiateItemEvent(EntityPlayer player, ItemStack itemStack, int event, boolean limitRange) {
    }

    @Override
    public void initiateGuiDisplay(EntityPlayerMP entityPlayer, IHasGui inventory, int windowId) {
    }

    @Override
    public void initiateExplosionEffect(World world, double x, double y, double z) {
    }

    @Override
    public void initiateExplosionEffect(World world, double x, double y, double z, boolean nuke) {
    }

    @Override
    public void sendCustomPacket(EntityPlayer player, IC2Packet packet) {
    }

    @Override
    public void sendCustomPacket(IC2Packet packet) {
        PacketManager.instance.sendToServer(packet);
    }

    @Override
    public void requestInitialGuiData(EntityPlayer player, INetworkGuiDataProvider dataProvider) {
    }

    @Override
    public void updateTileGuiField(TileEntity te, String field) {
    }

    @Override
    public void updateTileEntityField(TileEntity te, String field, EntityPlayerMP player) {
    }

    @Override
    public void updateGuiChanges(EntityPlayer player, TileEntity tile) {
    }
}

