/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.core.IC2;
import ic2.core.item.GatewayElectricItemManager;
import ic2.core.item.armor.ItemArmorElectric;
import ic2.core.item.armor.ItemArmorJetpack;
import ic2.core.item.armor.ItemArmorJetpackQuantumSuit;
import ic2.core.item.boats.EntityElectricBoat;
import ic2.core.util.IElectricHelper;
import ic2.core.util.StackUtil;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.lwjgl.opengl.GL11;

public class ChargeTooltipHandler {
    @SubscribeEvent
    public void onToolTip(ItemTooltipEvent evt) {
        String tooltip;
        if (evt.itemStack == null) {
            return;
        }
        IElectricItemManager manager = ((GatewayElectricItemManager)ElectricItem.manager).getManager(evt.itemStack);
        if (manager != null && (tooltip = manager.getToolTip(evt.itemStack)) != null) {
            evt.toolTip.add(tooltip);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Post evt) {
        RenderGameOverlayEvent.ElementType cfr_ignored_0 = evt.type;
        if (evt.type != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null) {
            return;
        }
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        if (player.field_70154_o instanceof EntityElectricBoat) {
            this.handleElectricBoat((EntityElectricBoat)player.field_70154_o, (EntityPlayer)player, mc, evt);
            return;
        }
        this.handleNuclearJetpack((EntityPlayer)player, mc, evt);
    }

    @SideOnly(value=Side.CLIENT)
    private void handleElectricBoat(EntityElectricBoat boat, EntityPlayer player, Minecraft mc, RenderGameOverlayEvent.Post evt) {
        float scale;
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        boolean charge = GuiScreen.func_146271_m();
        float f = scale = charge ? boat.getCharge() : boat.getForce();
        if (!charge && (scale /= (float)(scale < 0.0f ? 2 : 4)) < 0.0f) {
            scale = -scale;
        }
        FontRenderer fontrenderer = mc.field_71466_p;
        ScaledResolution scaledresolution = evt.resolution;
        int i = scaledresolution.func_78326_a();
        int short1 = 182;
        int j = i / 2 - short1 / 2;
        int k = (int)(scale * (float)(short1 + 1));
        int b0 = scaledresolution.func_78328_b() - 29;
        this.drawTexturedModalRect(j, b0, 0, 74, short1, 5, 0);
        this.drawTexturedModalRect(j, b0, 0, 74, short1, 5, 0);
        if (k > 0) {
            this.drawTexturedModalRect(j, b0, 0, 79, k, 5, 0);
        }
        DecimalFormat format = new DecimalFormat("#.##");
        String s = StatCollector.func_74837_a((String)(charge ? "itemInfo.boatCharge.name" : "itemInfo.boatForce.name"), (Object[])new Object[]{format.format(scale *= 100.0f) + "%"});
        fontrenderer.func_78261_a(s, i / 2 - fontrenderer.func_78256_a(s) / 2, b0 - 2, 0xFFFFFF);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
    }

    @SideOnly(value=Side.CLIENT)
    private void handleNuclearJetpack(EntityPlayer player, Minecraft mc, RenderGameOverlayEvent.Post evt) {
        ItemArmorJetpack pack;
        ItemStack item = player.field_71071_by.field_70460_b[2];
        if (item == null) {
            return;
        }
        boolean jetplate = item.func_77973_b() instanceof ItemArmorJetpackQuantumSuit;
        if (!(item.func_77973_b() instanceof ItemArmorJetpack) && !jetplate) {
            return;
        }
        ItemArmorJetpack itemArmorJetpack = pack = jetplate ? ((ItemArmorJetpackQuantumSuit)item.func_77973_b()).jetpack : (ItemArmorJetpack)item.func_77973_b();
        if (!pack.canDoRocketMode()) {
            return;
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(item);
        if (!nbt.func_74767_n("RocketMode")) {
            return;
        }
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        int maxCharge = pack.getMaxRocketCharge();
        int charge = nbt.func_74762_e("UsedEnergy");
        float scale = (float)charge / (float)maxCharge;
        FontRenderer fontrenderer = mc.field_71466_p;
        ScaledResolution scaledresolution = evt.resolution;
        int i = scaledresolution.func_78326_a();
        int short1 = 182;
        int j = i / 2 - short1 / 2;
        int k = (int)(scale * (float)(short1 + 1));
        int b0 = scaledresolution.func_78328_b() - 29;
        this.drawTexturedModalRect(j, b0, 0, 74, short1, 5, 0);
        this.drawTexturedModalRect(j, b0, 0, 74, short1, 5, 0);
        if (k > 0) {
            this.drawTexturedModalRect(j, b0, 0, 79, k, 5, 0);
        }
        String s = StatCollector.func_74838_a((String)"itemInfo.rocketCharge.name");
        fontrenderer.func_78261_a(s, i / 2 - fontrenderer.func_78256_a(s) / 2, b0 - 2, 0xFFFFFF);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
    }

    @SideOnly(value=Side.CLIENT)
    private void drawTexturedModalRect(int p_73729_1_, int p_73729_2_, int p_73729_3_, int p_73729_4_, int p_73729_5_, int p_73729_6_, int zLevel) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(p_73729_1_ + 0), (double)(p_73729_2_ + p_73729_6_), (double)zLevel, (double)((float)(p_73729_3_ + 0) * f), (double)((float)(p_73729_4_ + p_73729_6_) * f1));
        tessellator.func_78374_a((double)(p_73729_1_ + p_73729_5_), (double)(p_73729_2_ + p_73729_6_), (double)zLevel, (double)((float)(p_73729_3_ + p_73729_5_) * f), (double)((float)(p_73729_4_ + p_73729_6_) * f1));
        tessellator.func_78374_a((double)(p_73729_1_ + p_73729_5_), (double)(p_73729_2_ + 0), (double)zLevel, (double)((float)(p_73729_3_ + p_73729_5_) * f), (double)((float)(p_73729_4_ + 0) * f1));
        tessellator.func_78374_a((double)(p_73729_1_ + 0), (double)(p_73729_2_ + 0), (double)zLevel, (double)((float)(p_73729_3_ + 0) * f), (double)((float)(p_73729_4_ + 0) * f1));
        tessellator.func_78381_a();
    }

    @SubscribeEvent
    public void onHitByLightning(EntityStruckByLightningEvent event) {
        if (!IC2.enableSpecialElectricArmor) {
            return;
        }
        if (event.entity instanceof EntityPlayer) {
            IInventory inv;
            EntityPlayer player = (EntityPlayer)event.entity;
            int charge = 100000000;
            for (int i = 0; i < 4; ++i) {
                ItemStack item = player.field_71071_by.func_70440_f(i);
                if (item == null) continue;
                charge = (int)((double)charge - ElectricItem.manager.charge(item, charge, Integer.MAX_VALUE, true, false));
            }
            if (charge > 0 && IC2.modul.containsKey("Baubles Modul") && (inv = ((IElectricHelper)((Object)IC2.modul.get("Baubles Modul"))).getBaublesInventory(player)) != null) {
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack item = inv.func_70301_a(i);
                    if (item == null) continue;
                    charge = (int)((double)charge - ElectricItem.manager.charge(item, charge, Integer.MAX_VALUE, true, false));
                }
            }
            if (charge > 0 && charge < 100000000 && !ItemArmorElectric.hasElectricBoots((EntityLivingBase)player)) {
                player.func_70097_a(DamageSource.field_76377_j, (float)charge);
            }
        }
    }
}

