/*
 * Decompiled with CFR 0.152.
 */
package ic2.peIntigration.core;

import cpw.mods.fml.common.FMLLog;
import ic2.api.recipe.ICraftingRecipeManagerList;
import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.core.AdvCraftingRecipeManager;
import ic2.core.Ic2Items;
import ic2.core.block.EntityDynamite;
import ic2.core.block.EntityItnt;
import ic2.core.block.EntityNuke;
import ic2.core.block.EntityStickyDynamite;
import ic2.core.block.generator.tileentity.TileEntityGeoGenerator;
import ic2.core.block.generator.tileentity.TileEntitySolarGenerator;
import ic2.core.block.generator.tileentity.TileEntitySolarHV;
import ic2.core.block.generator.tileentity.TileEntitySolarLV;
import ic2.core.block.generator.tileentity.TileEntitySolarMV;
import ic2.core.block.wiring.TileEntityCableDetector;
import ic2.core.item.tool.EntityMiningLaser;
import ic2.core.util.StackUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.proxy.IBlacklistProxy;
import moze_intel.projecte.api.proxy.IConversionProxy;
import moze_intel.projecte.api.proxy.IEMCProxy;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.FluidContainerRegistry;

public class RecipeLoader {
    public static void init() {
        if (!RecipeLoader.loadBlackList()) {
            FMLLog.getLogger().info("Did Not Load 0");
            return;
        }
        if (!RecipeLoader.loadCustomEmc()) {
            FMLLog.getLogger().info("Did Not Load 1");
            return;
        }
        if (!RecipeLoader.loadRecipeEmc()) {
            FMLLog.getLogger().info("Did Not Load 2");
            return;
        }
    }

    static boolean loadCustomEmc() {
        IEMCProxy proxy = ProjectEAPI.getEMCProxy();
        if (proxy == null) {
            return false;
        }
        proxy.registerCustomEMC(Ic2Items.resin.func_77946_l(), 48);
        proxy.registerCustomEMC(Ic2Items.rubber.func_77946_l(), 16);
        if (Ic2Items.rubberSapling != null) {
            proxy.registerCustomEMC(Ic2Items.rubberSapling.func_77946_l(), 32);
        }
        if (Ic2Items.rubberWood != null) {
            proxy.registerCustomEMC(Ic2Items.rubberWood.func_77946_l(), 24);
        }
        proxy.registerCustomEMC(Ic2Items.electrolyzedWaterCell.func_77946_l(), 64);
        proxy.registerCustomEMC(Ic2Items.goldDust.func_77946_l(), 2048);
        proxy.registerCustomEMC(Ic2Items.ironDust.func_77946_l(), 256);
        proxy.registerCustomEMC(Ic2Items.copperDust.func_77946_l(), 128);
        proxy.registerCustomEMC(Ic2Items.tinDust.func_77946_l(), 256);
        proxy.registerCustomEMC(Ic2Items.silverDust.func_77946_l(), 512);
        proxy.registerCustomEMC(Ic2Items.specialFertilzer.func_77946_l(), 1024);
        proxy.registerCustomEMC(Ic2Items.clayDust.func_77946_l(), 32);
        return true;
    }

    static boolean loadRecipeEmc() {
        IMachineRecipeManager[] managers;
        IConversionProxy convert = ProjectEAPI.getConversionProxy();
        if (convert == null) {
            return false;
        }
        for (ICraftingRecipeManagerList.IAdvRecipe recipe : ((AdvCraftingRecipeManager)Recipes.advRecipes).getRecipeList()) {
            if (RecipeLoader.isBlackListed(((IRecipe)recipe).func_77571_b())) continue;
            HashMap<Object, Integer> amounts = new HashMap<Object, Integer>();
            List<ICraftingRecipeManagerList.RecipeObject> recipeObjects = recipe.getRecipeInput();
            for (ICraftingRecipeManagerList.RecipeObject recipeItem : recipeObjects) {
                Object obj = RecipeLoader.convertBack(recipeItem.getItems());
                if (obj == null || RecipeLoader.isBlackListed(obj)) continue;
                if (amounts.containsKey(obj)) {
                    amounts.put(obj, (Integer)amounts.get(obj) + 1);
                    continue;
                }
                amounts.put(obj, 1);
            }
            ItemStack stack = ((IRecipe)recipe).func_77571_b();
            convert.addConversion(stack.field_77994_a, (Object)StackUtil.copyWithSize(stack, 1), amounts);
        }
        for (IMachineRecipeManager manager : managers = new IMachineRecipeManager[]{Recipes.macerator, Recipes.extractor, Recipes.compressor}) {
            HashMap<IRecipeInput, RecipeOutput> recipeMap = new HashMap<IRecipeInput, RecipeOutput>(manager.getRecipes());
            for (Map.Entry recipe : recipeMap.entrySet()) {
                RecipeOutput out;
                Object input = RecipeLoader.convertBack(((IRecipeInput)recipe.getKey()).getInputs());
                if (input == null || RecipeLoader.isBlackListed(input) || (out = (RecipeOutput)recipe.getValue()) == null || out.items == null || out.items.size() == 0 || RecipeLoader.isBlackListed(out.items.get(0))) continue;
                ItemStack output = out.items.get(0);
                HashMap<Object, Integer> amounts = new HashMap<Object, Integer>();
                amounts.put(input, ((IRecipeInput)recipe.getKey()).getAmount());
                convert.addConversion(output.field_77994_a, (Object)StackUtil.copyWithSize(output, 1), amounts);
            }
        }
        return true;
    }

    static boolean loadBlackList() {
        IBlacklistProxy proxy = ProjectEAPI.getBlacklistProxy();
        if (proxy == null) {
            FMLLog.getLogger().info("Could not Blacklist Proxy. ProjectE support stops");
            return false;
        }
        proxy.blacklistSwiftwolf(EntityStickyDynamite.class);
        proxy.blacklistSwiftwolf(EntityDynamite.class);
        proxy.blacklistSwiftwolf(EntityItnt.class);
        proxy.blacklistSwiftwolf(EntityNuke.class);
        proxy.blacklistSwiftwolf(EntityMiningLaser.class);
        proxy.blacklistInterdiction(EntityStickyDynamite.class);
        proxy.blacklistInterdiction(EntityDynamite.class);
        proxy.blacklistInterdiction(EntityItnt.class);
        proxy.blacklistInterdiction(EntityNuke.class);
        proxy.blacklistInterdiction(EntityMiningLaser.class);
        proxy.blacklistTimeWatch(TileEntityCableDetector.class);
        proxy.blacklistTimeWatch(TileEntityGeoGenerator.class);
        proxy.blacklistTimeWatch(TileEntitySolarLV.class);
        proxy.blacklistTimeWatch(TileEntitySolarMV.class);
        proxy.blacklistTimeWatch(TileEntitySolarHV.class);
        proxy.blacklistTimeWatch(TileEntitySolarGenerator.class);
        return true;
    }

    public static boolean isBlackListed(Object par1) {
        ItemStack stack;
        return par1 instanceof ItemStack && ((stack = (ItemStack)par1).func_77969_a(Ic2Items.matter) || stack.func_77969_a(Ic2Items.scrap) || stack.func_77969_a(Ic2Items.scrapMetal) || stack.func_77969_a(Ic2Items.scrapBox));
    }

    public static Object convertBack(List<ItemStack> items) {
        int size;
        int n = size = items == null ? 0 : items.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return items.get(0);
        }
        if (size > 1) {
            ItemStack item = items.get(0);
            if (FluidContainerRegistry.isFilledContainer((ItemStack)item)) {
                return FluidContainerRegistry.getFluidForFilledItem((ItemStack)item);
            }
            if (StackUtil.hasOreID(item)) {
                return StackUtil.getFirstOreID(item);
            }
        }
        return null;
    }
}

