/*
 * Decompiled with CFR 0.152.
 */
package ic2.rfIntigration.tiles;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyContainer;
import ic2.api.energy.tile.IEnergySink;
import ic2.core.IC2;
import ic2.core.block.TileEntityBlock;
import ic2.rfIntigration.core.converter.EU;
import ic2.rfIntigration.core.converter.RF;
import ic2.rfIntigration.tiles.IConverterStorage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileConvertRFBase
extends TileEntityBlock
implements IEnergySink,
IConverterStorage,
IEnergyProvider,
IEnergyContainer {
    public int tier;
    public int maxInput;
    public int maxEnergy;
    public int energy;
    public float loss;
    public EU euConverter = new EU();
    public RF rfConverter = new RF();
    public boolean enet;

    public TileConvertRFBase(int tier, int maxInput, int maxEnergy, float loss) {
        this.tier = tier;
        this.maxEnergy = maxEnergy;
        this.loss = loss;
        this.maxInput = maxInput;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return direction.ordinal() != this.getFacing();
    }

    @Override
    public double getDemandedEnergy() {
        return Math.min((float)this.getFreeSpace() / this.getLoss(), (float)this.maxInput);
    }

    @Override
    public int getSinkTier() {
        return this.tier;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        return this.euConverter.charge(amount, this);
    }

    public boolean canConnectEnergy(ForgeDirection dir) {
        return dir.ordinal() == this.getFacing();
    }

    public int extractEnergy(ForgeDirection dir, int amount, boolean simulate) {
        return this.rfConverter.discharge(amount, simulate, this);
    }

    public int getEnergyStored(ForgeDirection dir) {
        return this.energy * IC2.rfPerEU;
    }

    public int getMaxEnergyStored(ForgeDirection dir) {
        return this.maxEnergy * IC2.rfPerEU;
    }

    @Override
    public float getLoss() {
        return 1.0f - this.loss;
    }

    @Override
    public int getFreeSpace() {
        return this.maxEnergy - this.energy;
    }

    @Override
    public int charge(int amount) {
        this.energy += amount;
        if (this.energy > this.maxEnergy) {
            amount -= this.energy - this.maxEnergy;
        }
        return amount;
    }

    @Override
    public int useEnergy(int amount) {
        this.energy -= amount;
        if (this.energy < 0) {
            amount += this.energy;
            this.energy = 0;
        }
        return amount;
    }

    @Override
    public int useEnergy(int amount, boolean simulate) {
        if (!simulate) {
            return this.useEnergy(amount);
        }
        int stored = this.energy;
        if ((stored -= amount) < 0) {
            amount += stored;
        }
        return amount;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.euConverter.readFromNBT(nbt.func_74775_l("EUConverter"));
        this.rfConverter.readFromNBT(nbt.func_74775_l("RFConverter"));
        this.energy = nbt.func_74762_e("Energy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.euConverter.writeToNBT(this.getNBT("EUConverter", nbt));
        this.rfConverter.writeToNBT(this.getNBT("RFConverter", nbt));
        nbt.func_74768_a("Energy", this.energy);
    }

    public NBTTagCompound getNBT(String par1, NBTTagCompound nbt) {
        if (!nbt.func_74764_b(par1)) {
            nbt.func_74782_a(par1, (NBTBase)new NBTTagCompound());
        }
        return nbt.func_74775_l(par1);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        ForgeDirection fdir;
        IEnergyReceiver receiver;
        super.func_145845_h();
        if (this.energy <= 0) {
            return;
        }
        Direction dir = Direction.fromSideValue(this.getFacing());
        TileEntity tile = dir.applyToTileEntity(this);
        if (tile != null && tile instanceof IEnergyReceiver && (receiver = (IEnergyReceiver)tile).canConnectEnergy(fdir = dir.toForgeDirection().getOpposite())) {
            int toSend = Math.min(this.energy, this.getNeededRF(receiver, fdir));
            this.extractEnergy(dir.toForgeDirection(), receiver.receiveEnergy(fdir, toSend, false), false);
        }
    }

    public int getNeededRF(IEnergyReceiver par1, ForgeDirection dir) {
        return par1.getMaxEnergyStored(dir) - par1.getEnergyStored(dir);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.enet) {
            this.enet = true;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (this.enet) {
            this.enet = false;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return side != this.getFacing();
    }

    @Override
    public int getStoredEnergy() {
        return this.energy;
    }

    @Override
    public int getEnergyCapacity() {
        return this.maxEnergy;
    }

    @Override
    public int getEnergyUsage() {
        return this.energy;
    }

    @Override
    public int getEnergyProduction() {
        return 0;
    }

    @Override
    public int getMaxEnergyInput() {
        return this.maxInput;
    }
}

