/*
 * Decompiled with CFR 0.152.
 */
package ic2.rfIntigration.tiles;

import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyContainer;
import ic2.api.energy.tile.IEnergySourceInfo;
import ic2.api.energy.tile.IMultiEnergySource;
import ic2.core.IC2;
import ic2.core.block.TileEntityBlock;
import ic2.rfIntigration.core.converter.EU;
import ic2.rfIntigration.core.converter.RF;
import ic2.rfIntigration.tiles.IConverterStorage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileConverterEUBase
extends TileEntityBlock
implements IEnergySourceInfo,
IConverterStorage,
IEnergyReceiver,
IEnergyContainer,
IMultiEnergySource {
    public int tier;
    public int maxOffer;
    public int storedEnergy;
    public int maxEnergy;
    public float loss;
    boolean enet;
    public EU euConverter = new EU();
    public RF rfConverter = new RF();

    public TileConverterEUBase(int tier, int maxEnergy, int maxOffer, float loss) {
        this.tier = tier;
        this.maxEnergy = maxEnergy;
        this.maxOffer = maxOffer;
        this.loss = loss;
    }

    @Override
    public double getOfferedEnergy() {
        return Math.min((double)this.storedEnergy * (double)this.getLoss(), (double)this.maxOffer);
    }

    @Override
    public void drawEnergy(double amount) {
        this.euConverter.discharge(amount, this);
    }

    @Override
    public int getSourceTier() {
        return this.tier;
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return direction.ordinal() == this.getFacing();
    }

    @Override
    public int getMaxEnergyAmount() {
        return this.maxEnergy;
    }

    @Override
    public int getFreeSpace() {
        return this.maxEnergy - this.storedEnergy;
    }

    @Override
    public int charge(int amount) {
        this.storedEnergy += amount;
        if (this.storedEnergy > this.maxEnergy) {
            amount -= this.storedEnergy - this.maxEnergy;
        }
        return amount;
    }

    @Override
    public int useEnergy(int amount) {
        this.storedEnergy -= amount;
        if (this.storedEnergy < 0) {
            amount += this.storedEnergy;
            this.storedEnergy = 0;
        }
        return amount;
    }

    @Override
    public int useEnergy(int amount, boolean simulate) {
        if (!simulate) {
            return this.useEnergy(amount);
        }
        int stored = this.storedEnergy;
        if ((stored -= amount) < 0) {
            amount += stored;
        }
        return amount;
    }

    @Override
    public float getLoss() {
        return 1.0f - this.loss;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.enet) {
            this.enet = true;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (this.enet) {
            this.enet = false;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
    }

    public boolean canConnectEnergy(ForgeDirection side) {
        return side.ordinal() != this.getFacing();
    }

    public int getEnergyStored(ForgeDirection side) {
        return this.storedEnergy * IC2.rfForEU;
    }

    public int getMaxEnergyStored(ForgeDirection side) {
        return this.maxEnergy * IC2.rfForEU;
    }

    public int receiveEnergy(ForgeDirection side, int amount, boolean simulate) {
        return amount - this.rfConverter.charge(amount, simulate, this);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.rfConverter.writeToNBT(this.getNBT("RFConverter", nbt));
        this.euConverter.writeToNBT(this.getNBT("EuConverter", nbt));
        nbt.func_74768_a("Energy", this.storedEnergy);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.rfConverter.readFromNBT(nbt.func_74775_l("RFConverter"));
        this.euConverter.readFromNBT(nbt.func_74775_l("EuConverter"));
        this.storedEnergy = nbt.func_74762_e("Energy");
    }

    public NBTTagCompound getNBT(String par1, NBTTagCompound nbt) {
        if (!nbt.func_74764_b(par1)) {
            nbt.func_74782_a(par1, (NBTBase)new NBTTagCompound());
        }
        return nbt.func_74775_l(par1);
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return side != this.getFacing();
    }

    @Override
    public int getStoredEnergy() {
        return this.storedEnergy;
    }

    @Override
    public int getEnergyCapacity() {
        return this.maxEnergy;
    }

    @Override
    public int getEnergyUsage() {
        return 0;
    }

    @Override
    public int getEnergyProduction() {
        return this.maxOffer;
    }

    @Override
    public int getMaxEnergyInput() {
        return 0;
    }

    @Override
    public boolean sendMultibleEnergyPackets() {
        return true;
    }

    @Override
    public int getMultibleEnergyPacketAmount() {
        return 4;
    }
}

