/*
 * Decompiled with CFR 0.152.
 */
package ic2.waIntigration.core;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyConductorColored;
import ic2.api.energy.tile.IEnergyContainer;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.energy.tile.IMultiEnergySource;
import ic2.api.tile.IEnergyStorage;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.network.NetworkManager;
import ic2.core.network.internal.INetworkGuiDataProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.impl.ConfigHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EnergyTileHandler
implements IWailaDataProvider {
    public HudMode mode = HudMode.All;
    public int ticker = 0;
    public final boolean ignoreWaila;
    public static Map<EntityPlayer, TileEntity> tracking = new HashMap<EntityPlayer, TileEntity>();
    public static Set<EntityPlayer> skipping = new HashSet<EntityPlayer>();

    public EnergyTileHandler(boolean par1) {
        this.ignoreWaila = par1;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP arg0, TileEntity arg1, NBTTagCompound arg2, World arg3, int arg4, int arg5, int arg6) {
        NetworkManager manager = IC2.network.get();
        if (tracking.get(arg0) != arg1) {
            this.ticker = 0;
            if (arg1 instanceof INetworkGuiDataProvider) {
                manager.requestInitialGuiData((EntityPlayer)arg0, (INetworkGuiDataProvider)arg1);
            }
            tracking.put((EntityPlayer)arg0, arg1);
        }
        skipping.add((EntityPlayer)arg0);
        manager.updateGuiChanges((EntityPlayer)arg0, arg1);
        return arg2;
    }

    public List<String> getWailaBody(ItemStack item, List<String> list, IWailaDataAccessor access, IWailaConfigHandler config) {
        TileEntity tile;
        if (this.ticker > 0) {
            --this.ticker;
        }
        if ((tile = access.getTileEntity()) instanceof IEnergyTile) {
            EntityPlayer player = access.getPlayer();
            if (IC2.keyboard.isHudModeKeyDown(player) && this.ticker == 0) {
                this.ticker = 20;
                this.switchMode(player);
            }
            if (this.mode == HudMode.Dissabled) {
                return list;
            }
            if (!this.hasHotbarItem(player, Ic2Items.ecMeter) && !this.hasHotbarItem(player, Ic2Items.debug)) {
                list.add(StatCollector.func_74838_a((String)"wailaInfo.requireEUReader.name"));
            } else {
                if (tile instanceof IEnergySink && (this.mode == HudMode.SinkOnly || this.mode == HudMode.All)) {
                    IEnergySink sink = (IEnergySink)tile;
                    if (this.mode == HudMode.SinkOnly || this.mode == HudMode.All && !(tile instanceof IEnergyContainer)) {
                        this.addToList(list, HudConfig.SinkInput, config, StatCollector.func_74837_a((String)"wailaInfo.energySinkMaxInput.name", (Object[])new Object[]{(int)EnergyNet.instance.getPowerFromTier(sink.getSinkTier())}));
                    }
                    this.addToList(list, HudConfig.SinkDemainded, config, StatCollector.func_74837_a((String)"wailaInfo.energySinkDemainded.name", (Object[])new Object[]{(int)sink.getDemandedEnergy()}));
                }
                if (tile instanceof IEnergyStorage && (this.mode == HudMode.StorageOnly || this.mode == HudMode.All)) {
                    IEnergyStorage storage = (IEnergyStorage)tile;
                    this.addToList(list, HudConfig.StorageTeleporter, config, StatCollector.func_74837_a((String)"wailaInfo.energyStorageTeleporterInfo.name", (Object[])new Object[]{this.getBooleanString(storage.isTeleporterCompatible(access.getSide()))}));
                    if (this.mode == HudMode.StorageOnly || this.mode == HudMode.All && !(tile instanceof IEnergyContainer)) {
                        this.addToList(list, HudConfig.StorageStorageInfo, config, StatCollector.func_74837_a((String)"wailaInfo.energyStorageStorageInfo.name", (Object[])new Object[]{storage.getStored(), storage.getCapacity()}));
                    }
                }
                if (tile instanceof IEnergyContainer && (this.mode == HudMode.EnergyContainer || this.mode == HudMode.All)) {
                    IEnergyContainer container = (IEnergyContainer)tile;
                    this.addToList(list, HudConfig.ContainerStorage, config, StatCollector.func_74837_a((String)"wailaInfo.energyContainerStorage.name", (Object[])new Object[]{container.getStoredEnergy(), container.getEnergyCapacity()}));
                    int amount = container.getMaxEnergyInput();
                    if (amount > 0) {
                        this.addToList(list, HudConfig.ContainerMaxIn, config, StatCollector.func_74837_a((String)"wailaInfo.energyContainerMaxInput.name", (Object[])new Object[]{amount}));
                    }
                    if ((amount = container.getEnergyUsage()) > 0) {
                        this.addToList(list, HudConfig.ContainerUsage, config, StatCollector.func_74837_a((String)"wailaInfo.energyContainerUsage.name", (Object[])new Object[]{amount}));
                    }
                    if ((amount = container.getEnergyProduction()) > 0) {
                        this.addToList(list, HudConfig.ContainerProduction, config, StatCollector.func_74837_a((String)"wailaInfo.energyContainerProduction.name", (Object[])new Object[]{amount}));
                    }
                }
                if (tile instanceof IEnergySource && (this.mode == HudMode.SourceOnly || this.mode == HudMode.All)) {
                    IMultiEnergySource multi;
                    IEnergySource source = (IEnergySource)tile;
                    int packets = 1;
                    if (tile instanceof IMultiEnergySource && (multi = (IMultiEnergySource)tile).sendMultibleEnergyPackets()) {
                        packets = multi.getMultibleEnergyPacketAmount();
                    }
                    this.addToList(list, HudConfig.SourceProvide, config, StatCollector.func_74837_a((String)"wailaInfo.energySourceProvide.name", (Object[])new Object[]{source.getOfferedEnergy()}));
                    this.addToList(list, HudConfig.SourcePackets, config, StatCollector.func_74837_a((String)"wailaInfo.energySourcePackets.name", (Object[])new Object[]{packets}));
                }
                if (tile instanceof IEnergyConductor && (this.mode == HudMode.CableOnly || this.mode == HudMode.All)) {
                    IEnergyConductor wire = (IEnergyConductor)tile;
                    if (tile instanceof IEnergyConductorColored) {
                        IEnergyConductorColored color = (IEnergyConductorColored)tile;
                        this.addToList(list, HudConfig.ConductorColor, config, StatCollector.func_74837_a((String)"wailaInfo.energyConductorColor.name", (Object[])new Object[]{color.getConductorColor()}));
                    }
                    this.addToList(list, HudConfig.ConductorMaxEnergy, config, StatCollector.func_74837_a((String)"wailaInfo.energyConductorMaxEnergy.name", (Object[])new Object[]{(int)(wire.getConductorBreakdownEnergy() - 1.0)}));
                    this.addToList(list, HudConfig.ConductorLoss, config, StatCollector.func_74837_a((String)"wailaInfo.energyConductorLoss.name", (Object[])new Object[]{wire.getConductionLoss()}));
                }
            }
        }
        return list;
    }

    public void addToList(List<String> par1, HudConfig type, IWailaConfigHandler config, String toAdd) {
        if (!this.ignoreWaila || ((ConfigHandler)config).getConfig("modules", type.getConfig(), false)) {
            par1.add(toAdd);
        }
    }

    public List<String> getWailaHead(ItemStack item, List<String> list, IWailaDataAccessor access, IWailaConfigHandler arg3) {
        return list;
    }

    public ItemStack getWailaStack(IWailaDataAccessor arg0, IWailaConfigHandler arg1) {
        return null;
    }

    public List<String> getWailaTail(ItemStack item, List<String> list, IWailaDataAccessor access, IWailaConfigHandler arg3) {
        return list;
    }

    public String getBooleanString(boolean par1) {
        if (par1) {
            return StatCollector.func_74838_a((String)"wailaInfo.yes.name");
        }
        return StatCollector.func_74838_a((String)"wailaInfo.no.name");
    }

    public boolean hasHotbarItem(EntityPlayer player, ItemStack item) {
        InventoryPlayer inv = player.field_71071_by;
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || !stack.func_77969_a(item)) continue;
            return true;
        }
        return false;
    }

    public void switchMode(EntityPlayer player) {
        int value = this.mode.ordinal() + 1;
        if (HudMode.values().length <= value) {
            value = 0;
        }
        this.mode = HudMode.values()[value];
        IC2.platform.messagePlayer(player, StatCollector.func_74837_a((String)"wailaInfo.switchHud.name", (Object[])new Object[]{this.mode.getName()}));
    }

    public static enum HudMode {
        SinkOnly("wailaInfo.SinkHudOnly.name"),
        CableOnly("wailaInfo.WireHudOnly.name"),
        SourceOnly("wailaInfo.SourceHudOnly.name"),
        StorageOnly("wailaInfo.StorageHudOnly.name"),
        EnergyContainer("wailaInfo.ContainerHudOnly.name"),
        All("wailaInfo.HudAll.name"),
        Dissabled("wailaInfo.HudDissabled.name");

        String unloclaizedName;

        private HudMode(String par1) {
            this.unloclaizedName = par1;
        }

        public String getName() {
            return StatCollector.func_74838_a((String)this.unloclaizedName);
        }
    }

    public static enum HudConfig {
        SinkInput("ic2.sink.in"),
        SinkDemainded("ic2.sink.req"),
        StorageTeleporter("ic2.storage.tele"),
        StorageStorageInfo("ic2.storage.info"),
        ContainerStorage("ic2.cont.info"),
        ContainerMaxIn("ic2.cont.in"),
        ContainerUsage("ic2.cont.use"),
        ContainerProduction("ic2.cont.prod"),
        SourceProvide("ic2.source.prov"),
        SourcePackets("ic2.source.packets"),
        ConductorColor("ic2.cable.color"),
        ConductorMaxEnergy("ic2.cable.max"),
        ConductorLoss("ic2.cable.loss");

        String config;

        private HudConfig(String par1) {
            this.config = par1;
        }

        public String getConfig() {
            return this.config;
        }

        public String getName() {
            return StatCollector.func_74838_a((String)(this.config + ".name"));
        }
    }
}

