/*
 * Decompiled with CFR 0.152.
 */
package net.sorenon.images;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.InputStream;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4573;
import net.sorenon.images.DownloadedImageImpl;
import net.sorenon.images.ImagesAPIImpl;
import net.sorenon.images.init.ImagesMod;
import net.sorenon.images.init.ImagesModClient;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010*\u001a\u00020+J\u001a\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\b\u00102\u001a\u00020+H\u0002R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R&\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u00063"}, d2={"Lnet/sorenon/images/DownloadingImage;", "", "map", "Ljava/util/HashMap;", "", "Lnet/sorenon/images/ImagesAPIImpl$ImageEnum;", "url", "Ljava/net/URL;", "(Ljava/util/HashMap;Ljava/net/URL;)V", "image", "Lnet/minecraft/client/texture/NativeImage;", "getImage", "()Lnet/minecraft/client/texture/NativeImage;", "setImage", "(Lnet/minecraft/client/texture/NativeImage;)V", "loader", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "getLoader", "()Ljava/util/concurrent/CompletableFuture;", "setLoader", "(Ljava/util/concurrent/CompletableFuture;)V", "getMap", "()Ljava/util/HashMap;", "setMap", "(Ljava/util/HashMap;)V", "texture", "Lnet/minecraft/client/texture/NativeImageBackedTexture;", "getTexture", "()Lnet/minecraft/client/texture/NativeImageBackedTexture;", "setTexture", "(Lnet/minecraft/client/texture/NativeImageBackedTexture;)V", "textureIdentifier", "Lnet/minecraft/util/Identifier;", "getTextureIdentifier", "()Lnet/minecraft/util/Identifier;", "setTextureIdentifier", "(Lnet/minecraft/util/Identifier;)V", "getUrl", "()Ljava/net/URL;", "setUrl", "(Ljava/net/URL;)V", "close", "", "readToBuffer", "Ljava/nio/ByteBuffer;", "stream", "Ljava/io/InputStream;", "limit", "", "uploadTexture", "images"})
public final class DownloadingImage {
    @NotNull
    private class_2960 textureIdentifier;
    @NotNull
    private CompletableFuture<Void> loader;
    @Nullable
    private class_1043 texture;
    @Nullable
    private class_1011 image;
    @NotNull
    private HashMap<String, ImagesAPIImpl.ImageEnum> map;
    @NotNull
    private URL url;

    @NotNull
    public final class_2960 getTextureIdentifier() {
        return this.textureIdentifier;
    }

    public final void setTextureIdentifier(@NotNull class_2960 class_29602) {
        Intrinsics.checkParameterIsNotNull((Object)class_29602, (String)"<set-?>");
        this.textureIdentifier = class_29602;
    }

    @NotNull
    public final CompletableFuture<Void> getLoader() {
        return this.loader;
    }

    public final void setLoader(@NotNull CompletableFuture<Void> completableFuture) {
        Intrinsics.checkParameterIsNotNull(completableFuture, (String)"<set-?>");
        this.loader = completableFuture;
    }

    @Nullable
    public final class_1043 getTexture() {
        return this.texture;
    }

    public final void setTexture(@Nullable class_1043 class_10432) {
        this.texture = class_10432;
    }

    @Nullable
    public final class_1011 getImage() {
        return this.image;
    }

    public final void setImage(@Nullable class_1011 class_10112) {
        this.image = class_10112;
    }

    private final ByteBuffer readToBuffer(InputStream stream, int limit) {
        ByteBuffer buffer = MemoryUtil.memAlloc((int)8192);
        ReadableByteChannel readableByteChannel = Channels.newChannel(stream);
        while (readableByteChannel.read(buffer) != -1) {
            if (buffer.remaining() != 0) continue;
            if (buffer.capacity() >= limit) {
                ImagesMod.Companion.getLOGGER().info("[Images] Image " + this.url + " was above the max image size (this can be increased in the config)");
                Map map = this.map;
                String string = this.url.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
                map.put(string, ImagesAPIImpl.ImageEnum.Error.INSTANCE);
                return null;
            }
            int n = buffer.capacity() * 2;
            ByteBuffer byteBuffer = buffer;
            boolean bl = false;
            int n2 = Math.min(n, limit);
            buffer = MemoryUtil.memRealloc((ByteBuffer)byteBuffer, (int)n2);
        }
        return buffer;
    }

    private final void uploadTexture() {
        boolean bl = RenderSystem.isOnRenderThread();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (!this.loader.isCancelled()) {
            this.texture = new class_1043(this.image);
            class_310 class_3102 = class_310.method_1551();
            Intrinsics.checkExpressionValueIsNotNull((Object)class_3102, (String)"MinecraftClient.getInstance()");
            class_3102.method_1531().method_4616(this.textureIdentifier, (class_1044)this.texture);
            class_1011 class_10112 = this.image;
            if (class_10112 == null) {
                Intrinsics.throwNpe();
            }
            class_10112.close();
            class_1011 class_10113 = this.image;
            if (class_10113 == null) {
                Intrinsics.throwNpe();
            }
            int n = class_10113.method_4307();
            class_1011 class_10114 = this.image;
            if (class_10114 == null) {
                Intrinsics.throwNpe();
            }
            ImagesAPIImpl.ImageEnum.Loaded downloadedImage = new ImagesAPIImpl.ImageEnum.Loaded(new DownloadedImageImpl(n, class_10114.method_4323(), this.textureIdentifier));
            ImagesAPIImpl.ImageEnum imageEnum = this.map.get(this.url.toString());
            downloadedImage.setLastUsed(imageEnum != null ? imageEnum.getLastUsed() : 0);
            Map map = this.map;
            String string = this.url.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
            map.put(string, downloadedImage);
            ImagesMod.Companion.getLOGGER().info("[Images] Successfully downloaded " + this.url);
        }
    }

    public final void close() {
        boolean bl = RenderSystem.isOnRenderThread();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (!this.loader.isDone()) {
            this.loader.cancel(true);
            ImagesMod.Companion.getLOGGER().info("[Images] Canceling download of " + this.url);
        }
        boolean destroyed = false;
        if (this.texture != null) {
            class_1043 class_10432 = this.texture;
            if (class_10432 == null) {
                Intrinsics.throwNpe();
            }
            class_10432.close();
            destroyed = true;
        }
        if (this.image != null) {
            class_1011 class_10112 = this.image;
            if (class_10112 == null) {
                Intrinsics.throwNpe();
            }
            class_10112.close();
            destroyed = true;
        }
        if (destroyed) {
            ImagesMod.Companion.getLOGGER().info("[Images] Destroying downloaded image " + this.url);
        }
    }

    @NotNull
    public final HashMap<String, ImagesAPIImpl.ImageEnum> getMap() {
        return this.map;
    }

    public final void setMap(@NotNull HashMap<String, ImagesAPIImpl.ImageEnum> hashMap) {
        Intrinsics.checkParameterIsNotNull(hashMap, (String)"<set-?>");
        this.map = hashMap;
    }

    @NotNull
    public final URL getUrl() {
        return this.url;
    }

    public final void setUrl(@NotNull URL uRL) {
        Intrinsics.checkParameterIsNotNull((Object)uRL, (String)"<set-?>");
        this.url = uRL;
    }

    public DownloadingImage(@NotNull HashMap<String, ImagesAPIImpl.ImageEnum> map, @NotNull URL url) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        this.map = map;
        this.url = url;
        this.textureIdentifier = new class_2960("images", UUID.randomUUID().toString());
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public final void run() {
                ByteBuffer buffer;
                InputStream stream;
                block8: {
                    ImagesMod.Companion.getLOGGER().info("[Images] Downloading image from " + this.getUrl() + " as " + this.getTextureIdentifier());
                    stream = null;
                    buffer = null;
                    try {
                        InputStream inputStream = stream = this.getUrl().openStream();
                        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"stream");
                        if (this.readToBuffer(inputStream, ImagesModClient.Companion.getCFG_MAX_SIZE()) != null) {
                            ByteBuffer byteBuffer;
                            buffer = byteBuffer;
                            buffer.position(0);
                            this.setImage(class_1011.method_4303((class_1011.class_1012)class_1011.class_1012.field_4997, (ByteBuffer)buffer));
                            class_310.method_1551().execute(new Runnable(){

                                @Override
                                public final void run() {
                                    try {
                                        RenderSystem.recordRenderCall((class_4573)new class_4573(){

                                            public final void execute() {
                                                this.uploadTexture();
                                            }
                                        });
                                    }
                                    catch (Exception e) {
                                        ImagesMod.Companion.getLOGGER().info("[Images] Couldn't read texture from " + this.getUrl() + ", " + e);
                                        Map map = this.getMap();
                                        String string = this.getUrl().toString();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
                                        map.put(string, ImagesAPIImpl.ImageEnum.Error.INSTANCE);
                                    }
                                }
                            });
                            MemoryUtil.memFree((Buffer)buffer);
                            break block8;
                        }
                        MemoryUtil.memFree((Buffer)buffer);
                    }
                    catch (Exception e) {
                        ImagesMod.Companion.getLOGGER().info("[Images] Couldn't download texture from " + this.getUrl() + ", " + e);
                        Map map = this.getMap();
                        String string = this.getUrl().toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
                        map.put(string, ImagesAPIImpl.ImageEnum.Error.INSTANCE);
                        return;
                    }
                    IOUtils.closeQuietly((InputStream)stream);
                    return;
                }
                IOUtils.closeQuietly((InputStream)stream);
                return;
                finally {
                    MemoryUtil.memFree((Buffer)buffer);
                    if (stream != null) {
                        IOUtils.closeQuietly((InputStream)stream);
                    }
                }
            }
        }, class_156.method_18349());
        Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.runAsy\u2026etServerWorkerExecutor())");
        this.loader = completableFuture;
    }
}

