/*
 * Decompiled with CFR 0.152.
 */
package com.kqp.inventorytabs.api;

import com.kqp.inventorytabs.init.InventoryTabs;
import com.kqp.inventorytabs.tabs.provider.ChestTabProvider;
import com.kqp.inventorytabs.tabs.provider.EnderChestTabProvider;
import com.kqp.inventorytabs.tabs.provider.PlayerInventoryTabProvider;
import com.kqp.inventorytabs.tabs.provider.ShulkerBoxTabProvider;
import com.kqp.inventorytabs.tabs.provider.SimpleBlockTabProvider;
import com.kqp.inventorytabs.tabs.provider.TabProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2199;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class TabProviderRegistry {
    private static final Map<class_2960, TabProvider> TAB_PROVIDERS = new HashMap<class_2960, TabProvider>();
    public static final PlayerInventoryTabProvider PLAYER_INVENTORY_TAB_PROVIDER = (PlayerInventoryTabProvider)TabProviderRegistry.register(InventoryTabs.id("player_inventory_tab_provider"), new PlayerInventoryTabProvider());
    public static final SimpleBlockTabProvider SIMPLE_BLOCK_TAB_PROVIDER = (SimpleBlockTabProvider)TabProviderRegistry.register(InventoryTabs.id("simple_block_tab_provider"), new SimpleBlockTabProvider());
    public static final ChestTabProvider CHEST_TAB_PROVIDER = (ChestTabProvider)TabProviderRegistry.register(InventoryTabs.id("chest_tab_provider"), new ChestTabProvider());
    public static final EnderChestTabProvider ENDER_CHEST_TAB_PROVIDER = (EnderChestTabProvider)TabProviderRegistry.register(InventoryTabs.id("ender_chest_tab_provider"), new EnderChestTabProvider());
    public static final ShulkerBoxTabProvider SHULKER_BOX_TAB_PROVIDER = (ShulkerBoxTabProvider)TabProviderRegistry.register(InventoryTabs.id("shulker_box_tab_provider"), new ShulkerBoxTabProvider());

    public static void init() {
        TabProviderRegistry.addVanillaSimpleBlockTabProviders();
        TabProviderRegistry.addVanillaChestTabProviders();
    }

    private static void addVanillaSimpleBlockTabProviders() {
        TabProviderRegistry.registerSimpleBlock(class_2246.field_10181);
        TabProviderRegistry.registerSimpleBlock(class_2246.field_16336);
        TabProviderRegistry.registerSimpleBlock(class_2246.field_9980);
        TabProviderRegistry.registerSimpleBlock(class_2246.field_10485);
        TabProviderRegistry.registerSimpleBlock(class_2246.field_16337);
        TabProviderRegistry.registerSimpleBlock(class_2246.field_10083);
        TabProviderRegistry.registerSimpleBlock(class_2246.field_16329);
        TabProviderRegistry.registerSimpleBlock(class_2246.field_16335);
        TabProviderRegistry.registerSimpleBlock(class_2246.field_16328);
        TabProviderRegistry.registerSimpleBlock(class_2246.field_16333);
        TabProviderRegistry.registerSimpleBlock(class_2246.field_16334);
        TabProviderRegistry.registerSimpleBlock(class_2246.field_10333);
        TabProviderRegistry.registerSimpleBlock(class_2246.field_10200);
        TabProviderRegistry.registerSimpleBlock(class_2246.field_10228);
        TabProviderRegistry.registerSimpleBlock(class_2246.field_10312);
        class_2378.field_11146.forEach(block -> {
            if (block instanceof class_2199) {
                TabProviderRegistry.registerSimpleBlock(block);
            }
        });
    }

    private static void addVanillaChestTabProviders() {
        TabProviderRegistry.registerChest(class_2246.field_10034);
        TabProviderRegistry.registerChest(class_2246.field_10380);
    }

    public static void registerSimpleBlock(class_2248 block) {
        SIMPLE_BLOCK_TAB_PROVIDER.addBlock(block);
    }

    public static void registerChest(class_2248 block) {
        CHEST_TAB_PROVIDER.addChestBlock(block);
    }

    public static TabProvider register(class_2960 id, TabProvider tabProvider) {
        TAB_PROVIDERS.put(id, tabProvider);
        return tabProvider;
    }

    public static List<TabProvider> getTabProviders() {
        return new ArrayList<TabProvider>(TAB_PROVIDERS.values());
    }
}

