/*
 * Decompiled with CFR 0.152.
 */
package com.kqp.inventorytabs.tabs;

import com.kqp.inventorytabs.api.TabProviderRegistry;
import com.kqp.inventorytabs.init.InventoryTabsClient;
import com.kqp.inventorytabs.interf.TabManagerContainer;
import com.kqp.inventorytabs.mixin.client.accessor.HandledScreenAccessor;
import com.kqp.inventorytabs.tabs.render.TabRenderInfo;
import com.kqp.inventorytabs.tabs.render.TabRenderer;
import com.kqp.inventorytabs.tabs.tab.Tab;
import com.kqp.inventorytabs.util.MouseUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2596;
import net.minecraft.class_2815;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3675;
import net.minecraft.class_465;

@Environment(value=EnvType.CLIENT)
public class TabManager {
    public final List<Tab> tabs = new ArrayList<Tab>();
    public Tab currentTab;
    private class_465 currentScreen;
    public int currentPage = 0;
    public boolean tabOpenedRecently;
    public final TabRenderer tabRenderer = new TabRenderer(this);

    public void update() {
        this.refreshAvailableTabs();
        this.tabRenderer.update();
    }

    public void setCurrentTab(Tab tab) {
        this.currentTab = tab;
    }

    private void refreshAvailableTabs() {
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (!this.tabs.get(i).shouldBeRemoved()) continue;
            this.tabs.remove(i);
            --i;
        }
        TabProviderRegistry.getTabProviders().forEach(tabProvider -> tabProvider.addAvailableTabs(class_310.method_1551().field_1724, this.tabs));
        this.tabs.sort(Comparator.comparing(Tab::getPriority).reversed().thenComparing(tab -> tab.getHoverText().getString()));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int guiWidth = ((HandledScreenAccessor)this.currentScreen).getBackgroundWidth();
            int guiHeight = ((HandledScreenAccessor)this.currentScreen).getBackgroundHeight();
            int x = (this.currentScreen.field_22789 - guiWidth) / 2;
            int y = (this.currentScreen.field_22790 - guiHeight) / 2;
            if (mouseX > (double)x && mouseX < (double)(x + guiWidth) && mouseY > (double)y && mouseY < (double)(y + guiHeight)) {
                return false;
            }
            if (new Rectangle(x - 15 - 4, y - 16, 15, 13).contains(mouseX, mouseY) && this.canGoBackAPage()) {
                this.setCurrentPage(this.currentPage - 1);
                TabManager.playClick();
                return true;
            }
            if (new Rectangle(x + guiWidth + 4, y - 16, 15, 13).contains(mouseX, mouseY) && this.canGoForwardAPage()) {
                this.setCurrentPage(this.currentPage + 1);
                TabManager.playClick();
                return true;
            }
            TabRenderInfo[] tabRenderInfos = this.tabRenderer.getTabRenderInfos();
            for (int i = 0; i < tabRenderInfos.length; ++i) {
                Rectangle rect;
                TabRenderInfo tabRenderInfo = tabRenderInfos[i];
                if (tabRenderInfo == null || tabRenderInfo.tabReference == this.currentTab || !(rect = new Rectangle(tabRenderInfo.x, tabRenderInfo.y, tabRenderInfo.texW, tabRenderInfo.texH)).contains(mouseX, mouseY)) continue;
                this.onTabClick(tabRenderInfo.tabReference);
                return true;
            }
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (InventoryTabsClient.NEXT_TAB_KEY_BIND.method_1417(keyCode, scanCode)) {
            int currentTabIndex = this.tabs.indexOf(this.currentTab);
            if (class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)340)) {
                if (currentTabIndex > 0) {
                    this.onTabClick(this.tabs.get(currentTabIndex - 1));
                }
                return true;
            }
            if (currentTabIndex < this.tabs.size() - 1) {
                this.onTabClick(this.tabs.get(currentTabIndex + 1));
            }
            return true;
        }
        return false;
    }

    public void onScreenOpen(class_465 screen) {
        this.refreshAvailableTabs();
        this.setCurrentScreen(screen);
        MouseUtil.tryPop();
    }

    public void onTabClick(Tab tab) {
        MouseUtil.push();
        this.tabOpenedRecently = true;
        class_310 client = class_310.method_1551();
        if (client.field_1724.field_7512 != null) {
            client.method_1562().method_2883((class_2596)new class_2815(client.field_1724.field_7512.field_7763));
        }
        this.onOpenTab(tab);
        tab.open();
    }

    public void onOpenTab(Tab tab) {
        if (this.currentTab != null && this.currentTab != tab) {
            this.currentTab.onClose();
        }
        this.setCurrentTab(tab);
        this.setCurrentPage(this.pageOf(tab));
    }

    public int pageOf(Tab tab) {
        int index = this.tabs.indexOf(tab);
        return index / (this.getMaxRowLength() * 2);
    }

    public int getMaxRowLength() {
        int guiWidth = ((HandledScreenAccessor)this.currentScreen).getBackgroundWidth();
        int maxRowLength = guiWidth / 29;
        return maxRowLength;
    }

    public void setCurrentScreen(class_465 screen) {
        this.currentScreen = screen;
    }

    public class_465 getCurrentScreen() {
        return this.currentScreen;
    }

    public void setCurrentPage(int page) {
        if (page > 0 && this.tabs.size() < this.getMaxRowLength() * 2) {
            System.err.println("Not enough tabs to paginate, ignoring");
            return;
        }
        if (this.currentPage != page) {
            this.tabRenderer.resetPageTextRefreshTime();
        }
        this.currentPage = page;
    }

    public boolean screenOpenedViaTab() {
        if (this.tabOpenedRecently) {
            this.tabOpenedRecently = false;
            return true;
        }
        return false;
    }

    public int getMaxPages() {
        return this.tabs.size() / (this.getMaxRowLength() * 2 + 1);
    }

    public boolean canGoBackAPage() {
        return this.currentPage != 0;
    }

    public boolean canGoForwardAPage() {
        return this.currentPage < this.getMaxPages();
    }

    public static TabManager getInstance() {
        return ((TabManagerContainer)class_310.method_1551()).getTabManager();
    }

    public static void playClick() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
    }
}

