/*
 * Decompiled with CFR 0.152.
 */
package com.kqp.inventorytabs.tabs;

import com.kqp.inventorytabs.api.TabProviderRegistry;
import com.kqp.inventorytabs.interf.TabManagerContainer;
import com.kqp.inventorytabs.mixin.client.accessor.HandledScreenAccessor;
import com.kqp.inventorytabs.tabs.render.TabRenderInfo;
import com.kqp.inventorytabs.tabs.render.TabRenderer;
import com.kqp.inventorytabs.tabs.tab.PlayerTab;
import com.kqp.inventorytabs.tabs.tab.Tab;
import com.kqp.inventorytabs.util.MouseUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_465;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class TabManager {
    public final class_746 player;
    public final List<Tab> tabs;
    public Tab currentTab;
    private class_465 currentScreen;
    public int currentPage = 0;
    public boolean clickOpened = false;
    public final TabRenderer tabRenderer;

    public TabManager(class_746 player) {
        this.player = player;
        this.tabs = new ArrayList<Tab>();
        this.tabRenderer = new TabRenderer(this);
    }

    public void init() {
        this.tabs.add(new PlayerTab());
        this.refreshAvailableTabs();
    }

    public void update() {
        this.refreshAvailableTabs();
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (!this.tabs.get(i).shouldBeRemoved(this.player)) continue;
            this.tabs.remove(i);
            --i;
        }
    }

    public void setCurrentTab(Tab tab) {
        this.currentTab = tab;
    }

    private void refreshAvailableTabs() {
        TabProviderRegistry.getTabProviders().forEach(tabProvider -> tabProvider.addAvailableTabs(this.player, this.tabs));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int guiWidth = ((HandledScreenAccessor)this.currentScreen).getBackgroundWidth();
            int guiHeight = ((HandledScreenAccessor)this.currentScreen).getBackgroundHeight();
            int x = (this.currentScreen.field_22789 - guiWidth) / 2;
            int y = (this.currentScreen.field_22790 - guiHeight) / 2;
            if (mouseX > (double)x && mouseX < (double)(x + guiWidth) && mouseY > (double)y && mouseY < (double)(y + guiHeight)) {
                return false;
            }
            if (new Rectangle(x - 15 - 4, y - 16, 15, 13).contains(mouseX, mouseY) && this.canGoBack()) {
                this.setCurrentPage(this.currentPage - 1);
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                return true;
            }
            if (new Rectangle(x + guiWidth + 4, y - 16, 15, 13).contains(mouseX, mouseY) && this.canGoForward()) {
                this.setCurrentPage(this.currentPage + 1);
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                return true;
            }
            TabRenderInfo[] tabRenderInfos = this.tabRenderer.getTabRenderInfos();
            for (int i = 0; i < tabRenderInfos.length; ++i) {
                Rectangle rect;
                TabRenderInfo tabRenderInfo = tabRenderInfos[i];
                if (tabRenderInfo == null || tabRenderInfo.tabReference == this.currentTab || !(rect = new Rectangle(tabRenderInfo.x, tabRenderInfo.y, tabRenderInfo.texW, tabRenderInfo.texH)).contains(mouseX, mouseY)) continue;
                this.openTab(tabRenderInfo.tabReference, true);
                return true;
            }
        }
        return false;
    }

    public void onScreenOpen(class_465 screen) {
        this.setCurrentScreen(screen);
        this.tabRenderer.bottomRowYOffset = 0;
        MouseUtil.tryPop();
    }

    public void openTab(Tab tab, boolean clicked) {
        MouseUtil.push();
        this.clickOpened = clicked;
        this.onOpenTab(tab);
        tab.open(this.player);
    }

    public void onOpenTab(Tab tab) {
        this.setCurrentTab(tab);
        this.setCurrentPage(this.pageOf(tab));
    }

    public int pageOf(Tab tab) {
        int index = this.tabs.indexOf(tab);
        return index / (this.getMaxRowLength() * 2);
    }

    public int getMaxRowLength() {
        int guiWidth = ((HandledScreenAccessor)this.currentScreen).getBackgroundWidth();
        int maxRowLength = guiWidth / 29;
        return maxRowLength;
    }

    public void setCurrentScreen(class_465 screen) {
        this.currentScreen = screen;
    }

    public class_465 getCurrentScreen() {
        return this.currentScreen;
    }

    public void setCurrentPage(int page) {
        if (page > 0 && this.tabs.size() < this.getMaxRowLength() * 2) {
            System.err.println("Not enough tabs to paginate, ignoring");
            return;
        }
        this.currentPage = page;
    }

    public int getMaxPages() {
        return this.tabs.size() / (this.getMaxRowLength() * 2 + 1);
    }

    public boolean canGoBack() {
        return this.currentPage != 0;
    }

    public boolean canGoForward() {
        return this.currentPage < this.getMaxPages();
    }

    public static TabManager getInstance() {
        return ((TabManagerContainer)class_310.method_1551()).getTabManager();
    }
}

