/*
 * Decompiled with CFR 0.152.
 */
package com.kqp.inventorytabs.tabs.render;

import com.kqp.inventorytabs.init.InventoryTabsClient;
import com.kqp.inventorytabs.mixin.client.accessor.HandledScreenAccessor;
import com.kqp.inventorytabs.mixin.client.accessor.ScreenAccessor;
import com.kqp.inventorytabs.tabs.TabManager;
import com.kqp.inventorytabs.tabs.render.TabRenderInfo;
import com.kqp.inventorytabs.tabs.tab.Tab;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Rectangle;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_918;

@Environment(value=EnvType.CLIENT)
public class TabRenderer {
    private static final class_2960 TABS_TEXTURE = new class_2960("textures/gui/container/creative_inventory/tabs.png");
    private static final class_2960 BUTTONS_TEXTURE = InventoryTabsClient.id("textures/gui/buttons.png");
    public static final int TAB_WIDTH = 28;
    public static final int TAB_HEIGHT = 32;
    public static final int BUTTON_WIDTH = 15;
    public static final int BUTTON_HEIGHT = 13;
    public final TabManager tabManager;
    public int bottomRowYOffset;
    private TabRenderInfo[] tabRenderInfos;

    public TabRenderer(TabManager tabManager) {
        this.tabManager = tabManager;
    }

    public void renderBackground(class_4587 matrices) {
        matrices.method_22903();
        this.tabRenderInfos = this.getTabRenderInfos();
        for (int i = 0; i < this.tabRenderInfos.length; ++i) {
            TabRenderInfo tabRenderInfo = this.tabRenderInfos[i];
            if (tabRenderInfo == null || tabRenderInfo.tabReference == this.tabManager.currentTab) continue;
            this.renderTab(matrices, tabRenderInfo);
        }
        matrices.method_22909();
    }

    public void renderForeground(class_4587 matrices, double mouseX, double mouseY) {
        class_310.method_1551().method_1531().method_22813(TABS_TEXTURE);
        for (int i = 0; i < this.tabRenderInfos.length; ++i) {
            TabRenderInfo tabRenderInfo = this.tabRenderInfos[i];
            if (tabRenderInfo == null || tabRenderInfo.tabReference != this.tabManager.currentTab) continue;
            this.renderTab(matrices, tabRenderInfo);
        }
        this.drawButtons(matrices, mouseX, mouseY);
    }

    private void drawButtons(class_4587 matrices, double mouseX, double mouseY) {
        class_465 currentScreen = this.tabManager.getCurrentScreen();
        class_310.method_1551().method_1531().method_22813(BUTTONS_TEXTURE);
        int width = ((HandledScreenAccessor)currentScreen).getBackgroundWidth();
        int height = ((HandledScreenAccessor)currentScreen).getBackgroundHeight();
        int oX = (currentScreen.field_22789 - width) / 2;
        int oY = (currentScreen.field_22790 - height) / 2;
        int x = oX - 15 - 4;
        int y = oY - 16;
        boolean hovered = new Rectangle(x, y, 15, 13).contains(mouseX, mouseY);
        int u = 0;
        int v = this.tabManager.canGoBack() ? 0 : 13;
        currentScreen.method_25302(matrices, x, y, u += this.tabManager.canGoBack() && hovered ? 30 : 0, v, 15, 13);
        x = oX + width + 4;
        y = oY - 16;
        hovered = new Rectangle(x, y, 15, 13).contains(mouseX, mouseY);
        u = 15;
        v = this.tabManager.canGoForward() ? 0 : 13;
        currentScreen.method_25302(matrices, x, y, u += this.tabManager.canGoForward() && hovered ? 30 : 0, v, 15, 13);
    }

    private void renderTab(class_4587 matrices, TabRenderInfo tabRenderInfo) {
        class_465 currentScreen = this.tabManager.getCurrentScreen();
        class_310.method_1551().method_1531().method_22813(TABS_TEXTURE);
        currentScreen.method_25302(matrices, tabRenderInfo.x, tabRenderInfo.y, tabRenderInfo.texU, tabRenderInfo.texV, tabRenderInfo.texW, tabRenderInfo.texH);
        class_918 itemRenderer = ((ScreenAccessor)currentScreen).getItemRenderer();
        class_327 textRenderer = ((ScreenAccessor)currentScreen).getTextRenderer();
        itemRenderer.field_4730 = 100.0f;
        RenderSystem.enableRescaleNormal();
        class_1799 itemStack = tabRenderInfo.tabReference.getItemStack();
        itemRenderer.method_4023(itemStack, tabRenderInfo.itemX, tabRenderInfo.itemY);
        itemRenderer.method_4025(textRenderer, itemStack, tabRenderInfo.itemX, tabRenderInfo.itemY);
        itemRenderer.field_4730 = 0.0f;
    }

    public void renderHoverTooltips(class_4587 matrices, double mouseX, double mouseY) {
        for (int i = 0; i < this.tabRenderInfos.length; ++i) {
            Rectangle itemRec;
            TabRenderInfo tabRenderInfo = this.tabRenderInfos[i];
            if (tabRenderInfo == null || !(itemRec = new Rectangle(tabRenderInfo.itemX, tabRenderInfo.itemY, 16, 16)).contains(mouseX, mouseY)) continue;
            this.tabManager.getCurrentScreen().method_25424(matrices, tabRenderInfo.tabReference.getHoverText(), (int)mouseX, (int)mouseY);
        }
    }

    public TabRenderInfo[] getTabRenderInfos() {
        class_465 currentScreen = this.tabManager.getCurrentScreen();
        int maxRowLength = this.tabManager.getMaxRowLength();
        int numVisibleTabs = maxRowLength * 2;
        int startingIndex = this.tabManager.currentPage * numVisibleTabs;
        TabRenderInfo[] tabRenderInfo = new TabRenderInfo[numVisibleTabs];
        int x = (currentScreen.field_22789 - ((HandledScreenAccessor)currentScreen).getBackgroundWidth()) / 2;
        int y = (currentScreen.field_22790 - ((HandledScreenAccessor)currentScreen).getBackgroundHeight()) / 2;
        for (int i = 0; i < numVisibleTabs; ++i) {
            if (startingIndex + i >= this.tabManager.tabs.size()) continue;
            Tab tab = this.tabManager.tabs.get(startingIndex + i);
            boolean topRow = i < maxRowLength;
            boolean selected = tab == this.tabManager.currentTab;
            TabRenderInfo tabInfo = new TabRenderInfo();
            tabInfo.tabReference = tab;
            tabInfo.index = startingIndex + i;
            tabInfo.x = x + i * 29;
            if (!topRow) {
                tabInfo.x -= maxRowLength * 29;
            }
            if (topRow) {
                tabInfo.y = y - 26;
                if (selected) {
                    tabInfo.y = y - 28;
                }
            } else {
                tabInfo.y = y + ((HandledScreenAccessor)currentScreen).getBackgroundHeight() - 4 + this.bottomRowYOffset;
            }
            tabInfo.texW = 28;
            tabInfo.texH = 32;
            tabInfo.texU = i == 0 || i == maxRowLength ? 0 : 28;
            tabInfo.texV = topRow ? (selected ? 32 : 0) : (selected ? 96 : 64);
            if (topRow) {
                tabInfo.itemX = tabInfo.x + 6;
                tabInfo.itemY = tabInfo.y + 8;
            } else {
                tabInfo.itemX = tabInfo.x + 6;
                tabInfo.itemY = tabInfo.y + 6;
            }
            tabRenderInfo[i] = tabInfo;
        }
        return tabRenderInfo;
    }
}

