/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.collect.ImmutableMap;
import invtweaks.InvTweaksMod;
import invtweaks.packets.PacketUpdateConfig;
import invtweaks.util.Utils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class InvTweaksConfig {
    public static final ForgeConfigSpec CLIENT_CONFIG;
    public static final int NO_POS_OVERRIDE = -1418392593;
    public static final String NO_SPEC_OVERRIDE = "default";
    public static final Map<String, Category> DEFAULT_CATS;
    public static final List<String> DEFAULT_RAW_RULES;
    public static final Ruleset DEFAULT_RULES;
    public static final Map<String, ContOverride> DEFAULT_CONT_OVERRIDES;
    private static final ForgeConfigSpec.ConfigValue<List<? extends UnmodifiableConfig>> CATS;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> RULES;
    private static final ForgeConfigSpec.BooleanValue ENABLE_AUTOREFILL;
    private static final ForgeConfigSpec.BooleanValue ENABLE_QUICKVIEW;
    private static final ForgeConfigSpec.IntValue ENABLE_SORT;
    private static final ForgeConfigSpec.IntValue ENABLE_BUTTONS;
    private static final ForgeConfigSpec.ConfigValue<List<? extends UnmodifiableConfig>> CONT_OVERRIDES;
    private static final Map<UUID, Map<String, Category>> playerToCats;
    private static final Map<UUID, Ruleset> playerToRules;
    private static final Set<UUID> playerAutoRefill;
    private static final Map<UUID, Map<String, ContOverride>> playerToContOverrides;
    private static Map<String, Category> COMPILED_CATS;
    private static Ruleset COMPILED_RULES;
    private static Map<String, ContOverride> COMPILED_CONT_OVERRIDES;
    private static boolean isDirty;

    public static PacketUpdateConfig getSyncPacket() {
        return new PacketUpdateConfig((List)CATS.get(), (List)RULES.get(), (List)CONT_OVERRIDES.get(), (Boolean)ENABLE_AUTOREFILL.get());
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        ThreadTaskExecutor executor = (ThreadTaskExecutor)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.CLIENT);
        executor.func_222817_e(() -> InvTweaksConfig.setDirty(true));
    }

    @SubscribeEvent
    public static void onReload(ModConfig.Reloading configEvent) {
        ThreadTaskExecutor executor = (ThreadTaskExecutor)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.CLIENT);
        executor.func_222817_e(() -> InvTweaksConfig.setDirty(true));
    }

    public static boolean isDirty() {
        return isDirty;
    }

    public static void setDirty(boolean newVal) {
        isDirty = newVal;
        if (isDirty) {
            COMPILED_CATS = InvTweaksConfig.cfgToCompiledCats((List)CATS.get());
            COMPILED_RULES = new Ruleset((List)RULES.get());
            COMPILED_CONT_OVERRIDES = InvTweaksConfig.cfgToCompiledContOverrides((List)CONT_OVERRIDES.get());
        }
    }

    public static Map<String, Category> getSelfCompiledCats() {
        return COMPILED_CATS;
    }

    public static Ruleset getSelfCompiledRules() {
        return COMPILED_RULES;
    }

    public static Map<String, ContOverride> getSelfCompiledContOverrides() {
        return COMPILED_CONT_OVERRIDES;
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    public static void setPlayerCats(PlayerEntity ent, Map<String, Category> cats) {
        playerToCats.put(ent.func_110124_au(), cats);
    }

    public static void setPlayerRules(PlayerEntity ent, Ruleset ruleset) {
        playerToRules.put(ent.func_110124_au(), ruleset);
    }

    public static void setPlayerAutoRefill(PlayerEntity ent, boolean autoRefill) {
        if (autoRefill) {
            playerAutoRefill.add(ent.func_110124_au());
        } else {
            playerAutoRefill.remove(ent.func_110124_au());
        }
    }

    public static void setPlayerContOverrides(PlayerEntity ent, Map<String, ContOverride> val) {
        playerToContOverrides.put(ent.func_110124_au(), val);
    }

    public static Map<String, Category> getPlayerCats(PlayerEntity ent) {
        if (DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> ent == Minecraft.func_71410_x().field_71439_g) == Boolean.TRUE) {
            return InvTweaksConfig.getSelfCompiledCats();
        }
        return playerToCats.getOrDefault(ent.func_110124_au(), DEFAULT_CATS);
    }

    public static Ruleset getPlayerRules(PlayerEntity ent) {
        if (DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> ent == Minecraft.func_71410_x().field_71439_g) == Boolean.TRUE) {
            return InvTweaksConfig.getSelfCompiledRules();
        }
        return playerToRules.getOrDefault(ent.func_110124_au(), DEFAULT_RULES);
    }

    public static boolean getPlayerAutoRefill(PlayerEntity ent) {
        if (DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> ent == Minecraft.func_71410_x().field_71439_g) == Boolean.TRUE) {
            return (Boolean)ENABLE_AUTOREFILL.get();
        }
        return playerAutoRefill.contains(ent.func_110124_au());
    }

    public static Map<String, ContOverride> getPlayerContOverrides(PlayerEntity ent) {
        if (DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> ent == Minecraft.func_71410_x().field_71439_g) == Boolean.TRUE) {
            return InvTweaksConfig.getSelfCompiledContOverrides();
        }
        return playerToContOverrides.getOrDefault(ent.func_110124_au(), DEFAULT_CONT_OVERRIDES);
    }

    public static boolean isSortEnabled(boolean isPlayerSort) {
        return InvTweaksConfig.isFlagEnabled((Integer)ENABLE_SORT.get(), isPlayerSort);
    }

    public static boolean isButtonEnabled(boolean isPlayer) {
        return InvTweaksConfig.isFlagEnabled((Integer)ENABLE_BUTTONS.get(), isPlayer);
    }

    private static boolean isFlagEnabled(int flag, boolean isPlayer) {
        return flag == 3 || flag == (isPlayer ? 1 : 2);
    }

    public static boolean isQuickViewEnabled() {
        return (Boolean)ENABLE_QUICKVIEW.get();
    }

    public static Map<String, Category> cfgToCompiledCats(List<UnmodifiableConfig> lst) {
        LinkedHashMap<String, Category> catsMap = new LinkedHashMap<String, Category>();
        for (UnmodifiableConfig subCfg : lst) {
            String name = (String)subCfg.getOrElse("name", (Object)"");
            if (name.equals("") || name.startsWith("/")) continue;
            catsMap.put(name, new Category((List)subCfg.getOrElse("spec", Collections.emptyList())));
        }
        return catsMap;
    }

    public static Map<String, ContOverride> cfgToCompiledContOverrides(List<UnmodifiableConfig> lst) {
        LinkedHashMap<String, ContOverride> res = new LinkedHashMap<String, ContOverride>();
        for (UnmodifiableConfig subCfg : lst) {
            res.put((String)subCfg.getOrElse("containerClass", (Object)""), new ContOverride((Integer)subCfg.getOrElse("x", (Object)-1418392593), (Integer)subCfg.getOrElse("y", (Object)-1418392593), (String)subCfg.getOrElse("sortRange", (Object)NO_SPEC_OVERRIDE)));
        }
        return res;
    }

    static {
        DEFAULT_CATS = ImmutableMap.builder().put((Object)"sword", (Object)new Category("/instanceof:net.minecraft.item.SwordItem")).put((Object)"axe", (Object)new Category("/instanceof:net.minecraft.item.AxeItem")).put((Object)"pickaxe", (Object)new Category("/instanceof:net.minecraft.item.PickaxeItem")).put((Object)"shovel", (Object)new Category("/instanceof:net.minecraft.item.ShovelItem")).put((Object)"acceptableFood", (Object)new Category(String.format("/instanceof:net.minecraft.item.Food; !%s; !%s; !%s; !%s", Items.field_151078_bh.getRegistryName(), Items.field_151070_bp.getRegistryName(), Items.field_151170_bI.getRegistryName(), Items.field_196089_aZ.getRegistryName()))).put((Object)"torch", (Object)new Category(Objects.requireNonNull(Items.field_221657_bQ.getRegistryName()).toString())).put((Object)"cheapBlocks", (Object)new Category("/tag:forge:cobblestone", "/tag:forge:dirt")).put((Object)"blocks", (Object)new Category("/instanceof:net.minecraft.item.BlockItem")).build();
        DEFAULT_RAW_RULES = Arrays.asList("D /LOCKED", "A1-C9 /OTHER");
        DEFAULT_RULES = new Ruleset(DEFAULT_RAW_RULES);
        DEFAULT_CONT_OVERRIDES = ImmutableMap.of((Object)"com.tfar.craftingstation.CraftingStationContainer", (Object)new ContOverride(-1418392593, -1418392593, ""), (Object)"mcjty.rftoolsutility.modules.crafter.blocks.CrafterContainer", (Object)new ContOverride(-1418392593, -1418392593, ""));
        playerToCats = new HashMap<UUID, Map<String, Category>>();
        playerToRules = new HashMap<UUID, Ruleset>();
        playerAutoRefill = new HashSet<UUID>();
        playerToContOverrides = new HashMap<UUID, Map<String, ContOverride>>();
        COMPILED_CATS = DEFAULT_CATS;
        COMPILED_RULES = DEFAULT_RULES;
        COMPILED_CONT_OVERRIDES = DEFAULT_CONT_OVERRIDES;
        isDirty = false;
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Sorting customization").push("sorting");
        CATS = builder.comment(new String[]{"Categor(y/ies) for sorting", "", "name: the name of the category", "", "spec:", "Each element denotes a series of semicolon-separated clauses", "Items need to match all clauses of at least one element", "Items matching earlier elements are earlier in order", "A clause of the form /tag:<tag_value> matches a tag", "Clauses /instanceof:<fully_qualified_name> or /class:<fully_qualified_name> check if item is", "instance of class or exactly of that class respectively", "Specifying an item's registry name as a clause checks for that item", "Prepending an exclamation mark at the start of a clause inverts it"}).defineList("category", DEFAULT_CATS.entrySet().stream().map(ent -> ((Category)ent.getValue()).toConfig((String)ent.getKey())).collect(Collectors.toList()), obj -> obj instanceof UnmodifiableConfig);
        RULES = builder.comment(new String[]{"Rules for sorting", "Each element is of the form <POS> <CATEGORY>", "A-D is the row from top to bottom", "1-9 is the column from left to right", "POS denotes the target slots", "Exs. POS = D3 means 3rd slot of hotbar", "     POS = B means 2nd row, left to right", "     POS = 9 means 9th column, bottom to top", "     POS = A1-C9 means slots A1,A2,\u00e2\u20ac\u00a6,A9,B1,\u00e2\u20ac\u00a6,B9,C1,\u00e2\u20ac\u00a6,C9", "     POS = A9-C1 means slots A9,A8,\u00e2\u20ac\u00a6,A1,B9,\u00e2\u20ac\u00a6,B1,C9,\u00e2\u20ac\u00a6,C1", "Append v to POS of the form A1-C9 to move in columns instead of rows", "Append r to POS of the form B or 9 to reverse slot order", "CATEGORY is the item category to designate the slots to", "CATEGORY = /LOCKED prevents slots from moving in sorting", "CATEGORY = /FROZEN has the effect of /LOCKED and, in addition, ignores slot in auto-refill", "CATEGORY = /OTHER covers all remaining items after other rules are exhausted"}).defineList("rules", DEFAULT_RAW_RULES, obj -> obj instanceof String);
        CONT_OVERRIDES = builder.comment(new String[]{"Custom settings per GUI", "x = x-position of external sort button relative to GUI top left", "y = same as above except for the y-position", "Omit x and y to leave position unchanged", "sortRange = slots to sort", "E.g. sortRange = \"5,0-2\" sorts slots 5,0,1,2 in that order", "sortRange = \"\" disables sorting for that container", "Out-of-bound slots are ignored", "Omit sortRange to leave as default"}).defineList("containerOverrides", DEFAULT_CONT_OVERRIDES.entrySet().stream().map(ent -> ((ContOverride)ent.getValue()).toConfig((String)ent.getKey())).collect(Collectors.toList()), obj -> obj instanceof UnmodifiableConfig);
        builder.pop();
        builder.comment("Tweaks").push("tweaks");
        ENABLE_AUTOREFILL = builder.comment("Enable auto-refill").define("autoRefill", true);
        ENABLE_QUICKVIEW = builder.comment("Enable a quick view of how many items that you're currently holding exists in your inventory by displaying it next your hotbar").define("quickView", true);
        ENABLE_SORT = builder.comment(new String[]{"0 = disable sorting", "1 = player sorting only", "2 = external sorting only", "3 = all sorting enabled (default)"}).defineInRange("enableSort", 3, 0, 3);
        ENABLE_BUTTONS = builder.comment(new String[]{"0 = disable buttons (i.e. keybind only)", "1 = buttons for player sorting only", "2 = buttons for external sorting only", "3 = all buttons enabled (default)"}).defineInRange("enableButtons", 3, 0, 3);
        builder.pop();
        CLIENT_CONFIG = builder.build();
    }

    public static class ContOverride {
        private final int x;
        private final int y;
        @Nullable
        private final IntList sortRange;
        private final String sortRangeSpec;

        public ContOverride(int x, int y, String sortRangeSpec) {
            this.x = x;
            this.y = y;
            this.sortRangeSpec = sortRangeSpec;
            IntLists.EmptyList tmp = null;
            if (sortRangeSpec.isEmpty()) {
                tmp = IntLists.EMPTY_LIST;
            } else if (!sortRangeSpec.equalsIgnoreCase(InvTweaksConfig.NO_SPEC_OVERRIDE)) {
                try {
                    tmp = (IntList)Arrays.stream(sortRangeSpec.split("\\s*,\\s*")).flatMapToInt(str -> {
                        String[] rangeSpec = str.split("\\s*-\\s*");
                        return IntStream.rangeClosed(Integer.parseInt(rangeSpec[0]), Integer.parseInt(rangeSpec[1]));
                    }).collect(IntArrayList::new, IntList::add, IntList::addAll);
                }
                catch (NumberFormatException e) {
                    InvTweaksMod.LOGGER.warn("Invalid slot spec: " + sortRangeSpec);
                    tmp = IntLists.EMPTY_LIST;
                }
            }
            this.sortRange = tmp;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        @Nullable
        public IntList getSortRange() {
            return this.sortRange;
        }

        public boolean isSortDisabled() {
            return this.sortRange != null && this.sortRange.isEmpty();
        }

        public CommentedConfig toConfig(String contClass) {
            CommentedConfig result = CommentedConfig.inMemory();
            result.set("containerClass", (Object)contClass);
            if (this.x != -1418392593) {
                result.set("x", (Object)this.x);
            }
            if (this.y != -1418392593) {
                result.set("y", (Object)this.y);
            }
            if (!this.sortRangeSpec.equalsIgnoreCase(InvTweaksConfig.NO_SPEC_OVERRIDE)) {
                result.set("sortRange", (Object)this.sortRangeSpec);
            }
            return result;
        }
    }

    public static class Ruleset {
        private final List<String> rules;
        private final Map<String, IntList> compiledRules = new LinkedHashMap<String, IntList>();
        private final IntList compiledFallbackRules = new IntArrayList(Utils.gridSpecToSlots("A1-D9", false));

        public Ruleset(List<String> rules) {
            this.rules = rules;
            for (String rule : rules) {
                String[] parts = rule.split("\\s+", 2);
                if (parts.length == 2) {
                    try {
                        this.compiledRules.computeIfAbsent(parts[1], k -> new IntArrayList()).addAll((IntList)IntArrayList.wrap((int[])Utils.gridSpecToSlots(parts[0], false)));
                        if (!parts[1].equals("/OTHER")) continue;
                        this.compiledFallbackRules.clear();
                        this.compiledFallbackRules.addAll((IntList)IntArrayList.wrap((int[])Utils.gridSpecToSlots(parts[0], true)));
                    }
                    catch (IllegalArgumentException e) {
                        InvTweaksMod.LOGGER.warn("Bad slot target: " + parts[0]);
                    }
                    continue;
                }
                InvTweaksMod.LOGGER.warn("Syntax error in rule: " + rule);
            }
        }

        public Ruleset(String ... rules) {
            this(Arrays.asList(rules));
        }

        public Ruleset(Ruleset rules) {
            this.rules = rules.rules;
            this.compiledRules.putAll(rules.compiledRules);
            this.compiledFallbackRules.clear();
            this.compiledFallbackRules.addAll(rules.compiledFallbackRules);
        }

        public IntList catToInventorySlots(String cat) {
            return this.compiledRules.get(cat);
        }

        public IntList fallbackInventoryRules() {
            return this.compiledFallbackRules;
        }
    }

    public static class Category {
        private final List<String> spec;
        private final List<List<Predicate<ItemStack>>> compiledSpec = new ArrayList<List<Predicate<ItemStack>>>();

        public Category(List<String> spec) {
            this.spec = spec;
            for (String subspec : spec) {
                ArrayList compiledSubspec = new ArrayList();
                for (String clause : subspec.split("\\s*;\\s*")) {
                    Category.compileClause(clause).ifPresent(compiledSubspec::add);
                }
                this.compiledSpec.add(compiledSubspec);
            }
        }

        public Category(String ... spec) {
            this(Arrays.asList(spec));
        }

        private static Optional<Predicate<ItemStack>> compileClause(String clause) {
            if (clause.startsWith("!")) {
                return Category.compileClause(clause.substring(1)).map(Predicate::negate);
            }
            String[] parts = clause.split(":", 2);
            if (parts[0].equals("/tag")) {
                return Optional.of(st -> Optional.ofNullable(ItemTags.func_199903_a().func_199910_a(new ResourceLocation(parts[1]))).filter(tg -> tg.func_199685_a_((Object)st.func_77973_b())).isPresent() || st.func_77973_b() instanceof BlockItem && Optional.ofNullable(BlockTags.func_199896_a().func_199910_a(new ResourceLocation(parts[1]))).filter(tg -> tg.func_199685_a_((Object)((BlockItem)st.func_77973_b()).func_179223_d())).isPresent());
            }
            if (parts[0].equals("/instanceof") || parts[0].equals("/class")) {
                try {
                    Class<?> clazz = Class.forName(parts[1]);
                    if (parts[0].equals("/instanceof")) {
                        return Optional.of(st -> clazz.isInstance(st.func_77973_b()));
                    }
                    return Optional.of(st -> st.func_77973_b().getClass().equals(clazz));
                }
                catch (ClassNotFoundException e) {
                    InvTweaksMod.LOGGER.warn("Class %s not found! Ignoring clause", (Object)parts[1]);
                    return Optional.empty();
                }
            }
            try {
                return Optional.of(st -> Objects.equals(st.func_77973_b().getRegistryName(), new ResourceLocation(clause)));
            }
            catch (ResourceLocationException e) {
                InvTweaksMod.LOGGER.warn("Invalid item resource location: %s", (Object)clause);
                return Optional.empty();
            }
        }

        public int checkStack(ItemStack stack) {
            return IntStream.range(0, this.compiledSpec.size()).filter(idx -> this.compiledSpec.get(idx).stream().allMatch(pr -> pr.test(stack))).findFirst().orElse(-1);
        }

        public CommentedConfig toConfig(String catName) {
            CommentedConfig result = CommentedConfig.inMemory();
            result.set("name", (Object)catName);
            result.set("spec", this.spec);
            return result;
        }
    }
}

