/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.util;

import com.google.common.base.Equivalence;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Streams;
import invtweaks.config.InvTweaksConfig;
import invtweaks.util.Utils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class Sorting {
    public static void executeSort(PlayerEntity player, boolean isPlayerSort) {
        block17: {
            block18: {
                if (!isPlayerSort) break block18;
                Map<String, InvTweaksConfig.Category> cats = InvTweaksConfig.getPlayerCats(player);
                InvTweaksConfig.Ruleset rules = InvTweaksConfig.getPlayerRules(player);
                IntList lockedSlots = Optional.ofNullable(rules.catToInventorySlots("/LOCKED")).map(IntArrayList::new).orElseGet(IntArrayList::new);
                lockedSlots.addAll(Optional.ofNullable(rules.catToInventorySlots("/FROZEN")).orElse((IntList)IntLists.EMPTY_LIST));
                lockedSlots.sort(null);
                PlayerInventory inv = player.field_71071_by;
                if (player.field_70170_p.field_72995_K) {
                    DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                        PlayerController pc = Minecraft.func_71410_x().field_71442_b;
                        Int2ObjectMap indexToSlot = (Int2ObjectMap)player.field_71070_bA.field_75151_b.stream().filter(slot -> slot.field_75224_c instanceof PlayerInventory).filter(slot -> 0 <= slot.getSlotIndex() && slot.getSlotIndex() < 36).collect(Collectors.toMap(Slot::getSlotIndex, Function.identity(), (u, v) -> u, Int2ObjectOpenHashMap::new));
                        IntList stackIdxs = (IntList)IntStream.range(0, inv.field_70462_a.size()).filter(idx -> Collections.binarySearch(lockedSlots, idx) < 0).filter(idx -> !((ItemStack)inv.field_70462_a.get(idx)).func_190926_b()).collect(IntArrayList::new, IntList::add, IntList::addAll);
                        Map<Equivalence.Wrapper<ItemStack>, Set<Slot>> gatheredSlots = Utils.gatheredSlots(() -> stackIdxs.stream().mapToInt(v -> v).mapToObj(arg_0 -> ((Int2ObjectMap)indexToSlot).get(arg_0)).filter(Slot::func_75216_d).iterator());
                        ArrayList<Equivalence.Wrapper<ItemStack>> stackWs = new ArrayList<Equivalence.Wrapper<ItemStack>>(gatheredSlots.keySet());
                        stackWs.sort(Comparator.comparing(Equivalence.Wrapper::get, Utils.FALLBACK_COMPARATOR));
                        for (Map.Entry ent : cats.entrySet()) {
                            IntList specificRules = rules.catToInventorySlots((String)ent.getKey());
                            if (specificRules == null) {
                                specificRules = IntLists.EMPTY_LIST;
                            }
                            specificRules = (IntList)specificRules.stream().filter(idx -> Collections.binarySearch(lockedSlots, idx) < 0).mapToInt(v -> v).collect(IntArrayList::new, IntList::add, IntList::addAll);
                            List specificRulesSlots = specificRules.stream().map(idx -> (Slot)indexToSlot.get(idx.intValue())).collect(Collectors.toList());
                            ListIterator<Slot> toIt = specificRulesSlots.listIterator();
                            Client.processCategoryClient(player, pc, gatheredSlots, stackWs, (InvTweaksConfig.Category)ent.getValue(), toIt);
                        }
                        List fallbackList = Stream.concat(Streams.stream(Optional.ofNullable(rules.catToInventorySlots("/OTHER"))).flatMap(Collection::stream), rules.fallbackInventoryRules().stream()).mapToInt(v -> v).filter(idx -> Collections.binarySearch(lockedSlots, idx) < 0).distinct().mapToObj(arg_0 -> ((Int2ObjectMap)indexToSlot).get(arg_0)).collect(Collectors.toList());
                        Client.processCategoryClient(player, pc, gatheredSlots, stackWs, null, fallbackList.listIterator());
                    });
                } else {
                    List<ItemStack> stacks = Utils.condensed(() -> IntStream.range(0, inv.field_70462_a.size()).filter(idx -> Collections.binarySearch(lockedSlots, idx) < 0).mapToObj(arg_0 -> ((NonNullList)inv.field_70462_a).get(arg_0)).filter(st -> !st.func_190926_b()).iterator());
                    stacks.sort(Utils.FALLBACK_COMPARATOR);
                    stacks = new LinkedList<ItemStack>(stacks);
                    for (int i = 0; i < inv.field_70462_a.size(); ++i) {
                        if (Collections.binarySearch(lockedSlots, i) >= 0) continue;
                        inv.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
                    }
                    for (Map.Entry<String, InvTweaksConfig.Category> ent : cats.entrySet()) {
                        IntList specificRules = rules.catToInventorySlots(ent.getKey());
                        if (specificRules == null) {
                            specificRules = IntLists.EMPTY_LIST;
                        }
                        specificRules = (IntList)specificRules.stream().filter(idx -> Collections.binarySearch(lockedSlots, idx) < 0).mapToInt(v -> v).collect(IntArrayList::new, IntList::add, IntList::addAll);
                        ArrayList<ItemStack> curStacks = new ArrayList<ItemStack>();
                        Iterator<ItemStack> it = stacks.iterator();
                        while (it.hasNext() && curStacks.size() < specificRules.size()) {
                            ItemStack st = it.next();
                            if (ent.getValue().checkStack(st) < 0) continue;
                            curStacks.add(st);
                            it.remove();
                        }
                        curStacks.sort(Comparator.comparingInt(s -> ((InvTweaksConfig.Category)cats.get(ent.getKey())).checkStack((ItemStack)s)));
                        Streams.zip((Stream)specificRules.stream(), curStacks.stream(), Pair::of).forEach(pr -> {
                            ItemStack cfr_ignored_0 = (ItemStack)inv.field_70462_a.set(((Integer)pr.getKey()).intValue(), pr.getValue());
                        });
                    }
                    PrimitiveIterator.OfInt fallbackIt = Stream.concat(Streams.stream(Optional.ofNullable(rules.catToInventorySlots("/OTHER"))).flatMap(Collection::stream), rules.fallbackInventoryRules().stream()).mapToInt(v -> v).iterator();
                    while (fallbackIt.hasNext()) {
                        int idx2 = fallbackIt.nextInt();
                        if (Collections.binarySearch(lockedSlots, idx2) >= 0) continue;
                        if (!stacks.isEmpty()) {
                            if (!((ItemStack)inv.field_70462_a.get(idx2)).func_190926_b()) continue;
                            inv.field_70462_a.set(idx2, (Object)stacks.remove(0));
                            continue;
                        }
                        break block17;
                    }
                }
                break block17;
            }
            Container cont = player.field_71070_bA;
            if (cont == player.field_71069_bz) break block17;
            String contClass = cont.getClass().getName();
            InvTweaksConfig.ContOverride override = InvTweaksConfig.getPlayerContOverrides(player).get(contClass);
            if (override != null && override.isSortDisabled()) {
                return;
            }
            List<Slot> validSlots = (override != null && override.getSortRange() != null ? override.getSortRange().stream().filter(Objects::nonNull).filter(idx -> 0 <= idx && idx < cont.field_75151_b.size()).map(cont.field_75151_b::get) : cont.field_75151_b.stream()).filter(slot -> !(slot.field_75224_c instanceof PlayerInventory)).filter(slot -> slot.func_82869_a(player) && slot.func_75214_a(slot.func_75211_c()) || !slot.func_75216_d()).collect(Collectors.toList());
            if (player.field_70170_p.field_72995_K) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                    PlayerController pc = Minecraft.func_71410_x().field_71442_b;
                    Map<Equivalence.Wrapper<ItemStack>, Set<Slot>> gatheredSlots = Utils.gatheredSlots(() -> validSlots.stream().filter(Slot::func_75216_d).iterator());
                    ArrayList<Equivalence.Wrapper<ItemStack>> stackWs = new ArrayList<Equivalence.Wrapper<ItemStack>>(gatheredSlots.keySet());
                    stackWs.sort(Comparator.comparing(Equivalence.Wrapper::get, Utils.FALLBACK_COMPARATOR));
                    ListIterator<Slot> toIt = validSlots.listIterator();
                    for (Equivalence.Wrapper wrapper : stackWs) {
                        HashBiMap displaced = HashBiMap.create();
                        Client.clientPushToSlots(player, pc, gatheredSlots.get(wrapper).iterator(), toIt, (BiMap<Slot, Slot>)displaced);
                        for (Map.Entry displacedPair : displaced.entrySet()) {
                            Set<Slot> toModify = gatheredSlots.get(Utils.STACKABLE.wrap((Object)((Slot)displacedPair.getValue()).func_75211_c()));
                            toModify.remove(displacedPair.getKey());
                            toModify.add((Slot)displacedPair.getValue());
                        }
                    }
                });
            } else {
                Slot cur;
                if (!validSlots.iterator().hasNext()) {
                    return;
                }
                List<ItemStack> stacks = Utils.condensed(() -> validSlots.stream().map(Slot::func_75211_c).filter(st -> !st.func_190926_b()).iterator());
                stacks.sort(Utils.FALLBACK_COMPARATOR);
                Iterator slotIt = validSlots.iterator();
                for (ItemStack stack : stacks) {
                    cur = null;
                    while (slotIt.hasNext() && !(cur = (Slot)slotIt.next()).func_75214_a(stack)) {
                    }
                    if (cur != null && cur.func_75214_a(stack)) continue;
                    return;
                }
                validSlots.forEach(slot -> slot.func_75215_d(ItemStack.field_190927_a));
                slotIt = validSlots.iterator();
                for (ItemStack stack : stacks) {
                    cur = null;
                    while (slotIt.hasNext() && !(cur = (Slot)slotIt.next()).func_75214_a(stack)) {
                    }
                    assert (cur != null);
                    cur.func_75215_d(stack);
                }
            }
        }
    }

    static class Client {
        Client() {
        }

        static void processCategoryClient(PlayerEntity player, PlayerController pc, Map<Equivalence.Wrapper<ItemStack>, Set<Slot>> gatheredSlots, List<Equivalence.Wrapper<ItemStack>> stackWs, InvTweaksConfig.Category cat, ListIterator<Slot> toIt) {
            ArrayList<Equivalence.Wrapper<ItemStack>> subStackWs = cat == null ? new ArrayList<Equivalence.Wrapper<ItemStack>>(stackWs) : stackWs.stream().filter(stackW -> cat.checkStack((ItemStack)stackW.get()) >= 0).sorted(Comparator.comparingInt(stackW -> cat.checkStack((ItemStack)stackW.get()))).collect(Collectors.toList());
            for (Equivalence.Wrapper wrapper : subStackWs) {
                if (cat != null && cat.checkStack((ItemStack)wrapper.get()) < 0) continue;
                HashBiMap displaced = HashBiMap.create();
                ListIterator fromIt = (ListIterator)gatheredSlots.get(wrapper).iterator();
                boolean fullInserted = Client.clientPushToSlots(player, pc, fromIt, toIt, (BiMap<Slot, Slot>)displaced);
                for (Map.Entry displacedPair : displaced.entrySet()) {
                    Equivalence.Wrapper displacedW = Utils.STACKABLE.wrap((Object)((Slot)displacedPair.getValue()).func_75211_c());
                    Set<Slot> toModify = gatheredSlots.get(displacedW);
                    toModify.remove(displacedPair.getKey());
                    toModify.add((Slot)displacedPair.getValue());
                }
            }
            stackWs.removeIf(sw -> ((Set)gatheredSlots.get(sw)).isEmpty());
            gatheredSlots.values().removeIf(Set::isEmpty);
        }

        static boolean clientPushToSlots(PlayerEntity player, PlayerController playerController, Iterator<Slot> OriginIter, ListIterator<Slot> destinationIter, BiMap<Slot, Slot> displaced) {
            if (!destinationIter.hasNext()) {
                return true;
            }
            boolean completedCurrentItemSwap = true;
            while (OriginIter.hasNext()) {
                completedCurrentItemSwap = false;
                Slot originSlot = OriginIter.next();
                playerController.func_187098_a(player.field_71070_bA.field_75152_c, originSlot.field_75222_d, 0, ClickType.PICKUP, player);
                Slot destinationSlot = null;
                while (destinationIter.hasNext()) {
                    if (destinationIter.hasPrevious() && ((destinationSlot = destinationIter.previous()).func_75211_c().func_190916_E() == Math.max(destinationSlot.func_75219_a(), destinationSlot.func_75211_c().func_77976_d()) || !Utils.STACKABLE.equivalent((Object)destinationSlot.func_75211_c(), (Object)player.field_71071_by.func_70445_o()))) {
                        destinationIter.next();
                    }
                    destinationSlot = destinationIter.next();
                    playerController.func_187098_a(player.field_71070_bA.field_75152_c, destinationSlot.field_75222_d, 0, ClickType.PICKUP, player);
                    if (player.field_71071_by.func_70445_o().func_190926_b()) {
                        completedCurrentItemSwap = true;
                        break;
                    }
                    if (Utils.STACKABLE.equivalent((Object)destinationSlot.func_75211_c(), (Object)player.field_71071_by.func_70445_o())) continue;
                    playerController.func_187098_a(player.field_71070_bA.field_75152_c, originSlot.field_75222_d, 0, ClickType.PICKUP, player);
                    if (!originSlot.func_75216_d() || ItemHandlerHelper.canItemStacksStack((ItemStack)originSlot.func_75211_c(), (ItemStack)destinationSlot.func_75211_c())) continue;
                    completedCurrentItemSwap = true;
                    displaced.put((Object)destinationSlot, (Object)originSlot);
                    break;
                }
                if (destinationIter.hasNext() || !Optional.ofNullable(destinationSlot).filter(s -> s.func_75211_c().func_190916_E() >= Math.min(s.func_75219_a(), s.func_75211_c().func_77976_d())).isPresent()) continue;
                break;
            }
            return completedCurrentItemSwap;
        }
    }
}

