/*
 * Decompiled with CFR 0.152.
 */
package gd.rf.acro.ate.init;

import gd.rf.acro.ate.ATE;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="ate", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final CommonGeneral GENERAL = new CommonGeneral(BUILDER);
    public static final ForgeConfigSpec SPEC = BUILDER.build();

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading event) {
        ATE.LOGGER.debug("loaded Iron TNT config");
    }

    public static class CommonGeneral {
        public final ForgeConfigSpec.DoubleValue cobble;
        public final ForgeConfigSpec.DoubleValue iron;
        public final ForgeConfigSpec.DoubleValue gold;
        public final ForgeConfigSpec.DoubleValue diamond;
        public final ForgeConfigSpec.DoubleValue ender;
        public final ForgeConfigSpec.DoubleValue radiating;
        public final ForgeConfigSpec.DoubleValue gravity;
        public final ForgeConfigSpec.DoubleValue brit;
        public final ForgeConfigSpec.DoubleValue fire;
        public final ForgeConfigSpec.IntValue delay;
        public final ForgeConfigSpec.DoubleValue throwScale;
        public final ForgeConfigSpec.BooleanValue showTooltip;

        CommonGeneral(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.cobble = builder.comment("RE factor of Cobble TNT: ").defineInRange("cobble", 1.5, 0.0, Double.MAX_VALUE);
            this.iron = builder.comment("RE factor of Iron TNT: ").defineInRange("iron", 2.0, 0.0, Double.MAX_VALUE);
            this.gold = builder.comment("RE factor of Golden TNT: ").defineInRange("gold", 3.0, 0.0, Double.MAX_VALUE);
            this.diamond = builder.comment("RE factor of Diamond TNT: ").defineInRange("diamond", 4.5, 0.0, Double.MAX_VALUE);
            this.ender = builder.comment("RE factor of Ender TNT: ").defineInRange("ender", 6.5, 0.0, Double.MAX_VALUE);
            this.radiating = builder.comment("RE factor of Radiating TNT: ").defineInRange("radiating", 3.5, 0.0, Double.MAX_VALUE);
            this.gravity = builder.comment("RE factor of Gravitational TNT: ").defineInRange("gravity", 1.5, 0.0, Double.MAX_VALUE);
            this.brit = builder.comment("RE factor of British TNT: ").defineInRange("brit", 0.5, 0.0, Double.MAX_VALUE);
            this.fire = builder.comment("RE factor of Incendiary TNT: ").defineInRange("fire", 1.5, 0.0, Double.MAX_VALUE);
            this.throwScale = builder.comment("The speed multiplier of throwable tnt when thrown: ").defineInRange("throwScale", 1.5, 0.0, Double.MAX_VALUE);
            this.delay = builder.comment("The delay before a throwable explodes: ").defineInRange("throwScale", 100, 5, Integer.MAX_VALUE);
            this.showTooltip = builder.comment("Should the information tooltip be shown: ").define("showTooltip", true);
            builder.pop();
        }
    }
}

