/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysic.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.ICreativeLoader;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.itemphysic.ItemPhysic;
import team.creative.itemphysic.common.CommonPhysic;
import team.creative.itemphysic.common.ItemEntityPhysic;
import team.creative.itemphysic.common.packet.DropPacket;
import team.creative.itemphysic.common.packet.PickupPacket;
import team.creative.itemphysic.mixin.EntityAccessor;

@OnlyIn(value=Dist.CLIENT)
public class ItemPhysicClient {
    public static final KeyMapping PICKUP = new KeyMapping("key.pickup.item", InputConstants.f_84822_.m_84873_(), "key.categories.gameplay");
    public static final Minecraft mc = Minecraft.m_91087_();
    public static int throwingPower;
    public static long lastTickTime;

    public static void init() {
        ICreativeLoader loader = CreativeCore.loader();
        loader.registerKeybind(() -> PICKUP);
        loader.registerClientTick(ItemPhysicClient::gameTick);
        loader.registerClientRender(ItemPhysicClient::renderTick);
        CreativeCoreClient.registerClientConfig((String)"itemphysic");
    }

    public static void gameTick() {
        if (ItemPhysicClient.mc.f_91074_ != null && ItemPhysicClient.mc.f_91074_.m_21205_() != null && ItemPhysic.CONFIG.general.customThrow) {
            if (ItemPhysicClient.mc.f_91066_.f_92094_.m_90857_()) {
                ++throwingPower;
            } else {
                if (throwingPower > 0) {
                    if ((throwingPower /= 6) < 1) {
                        throwingPower = 1;
                    }
                    if (throwingPower > 6) {
                        throwingPower = 6;
                    }
                    boolean dropAll = Screen.m_96637_();
                    ItemPhysic.NETWORK.sendToServer((CreativePacket)new DropPacket(throwingPower));
                    ServerboundPlayerActionPacket.Action cplayerdiggingpacket$action = dropAll ? ServerboundPlayerActionPacket.Action.DROP_ALL_ITEMS : ServerboundPlayerActionPacket.Action.DROP_ITEM;
                    ItemPhysicClient.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundPlayerActionPacket(cplayerdiggingpacket$action, BlockPos.f_121853_, Direction.DOWN));
                    if (ItemPhysicClient.mc.f_91074_.m_150109_().m_7407_(ItemPhysicClient.mc.f_91074_.m_150109_().f_35977_, dropAll && !ItemPhysicClient.mc.f_91074_.m_150109_().m_36056_().m_41619_() ? ItemPhysicClient.mc.f_91074_.m_150109_().m_36056_().m_41613_() : 1) != ItemStack.f_41583_) {
                        ItemPhysicClient.mc.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
                    }
                }
                throwingPower = 0;
            }
        }
    }

    public static void renderTick() {
        lastTickTime = System.nanoTime();
        if (ItemPhysicClient.mc.f_91080_ == null) {
            ItemPhysicClient.renderTooltip();
        }
    }

    public static void renderTooltip() {
        if (mc != null && ItemPhysicClient.mc.f_91074_ != null && !mc.m_91104_()) {
            HitResult result;
            if (ItemPhysic.CONFIG.pickup.customPickup && (result = ItemPhysicClient.getEntityItem((Player)ItemPhysicClient.mc.f_91074_)) != null && result.m_6662_() == HitResult.Type.ENTITY) {
                ItemEntity entity;
                if (PICKUP.m_90857_()) {
                    ItemPhysicClient.onPlayerInteractClient((Level)ItemPhysicClient.mc.f_91073_, (Player)ItemPhysicClient.mc.f_91074_, false);
                }
                if ((entity = (ItemEntity)((EntityHitResult)result).m_82443_()) != null && ItemPhysic.CONFIG.rendering.showPickupTooltip) {
                    String text;
                    int i;
                    int space = 15;
                    ArrayList<Object> list = new ArrayList<Object>();
                    try {
                        entity.m_32055_().m_41720_().m_7373_(entity.m_32055_(), ItemPhysicClient.mc.f_91074_.f_19853_, list, (TooltipFlag)TooltipFlag.Default.NORMAL);
                        list.add(entity.m_32055_().m_41611_());
                    }
                    catch (Exception e) {
                        list = new ArrayList();
                        list.add(Component.m_237113_((String)"ERRORED"));
                    }
                    if (ItemPhysic.CONFIG.rendering.showPickupTooltipKeybind) {
                        list.add(Component.m_237110_((String)"item.tooltip.pickup.keybind", (Object[])new Object[]{PICKUP.m_90862_() ? ItemPhysicClient.mc.f_91066_.f_92095_.m_90863_() : PICKUP.m_90863_()}));
                    }
                    int width = 0;
                    for (i = 0; i < list.size(); ++i) {
                        text = ((Component)list.get(i)).getString();
                        width = Math.max(width, ItemPhysicClient.mc.f_91062_.m_92895_(text) + 10);
                    }
                    RenderSystem.m_69461_();
                    RenderSystem.m_69493_();
                    for (i = 0; i < list.size(); ++i) {
                        text = ((Component)list.get(i)).getString();
                        ItemPhysicClient.mc.f_91062_.m_92750_(new PoseStack(), text, (float)(mc.m_91268_().m_85445_() / 2 - ItemPhysicClient.mc.f_91062_.m_92895_(text) / 2), (float)(mc.m_91268_().m_85446_() / 2 + (list.size() / 2 * space - space * (i + 1))), 0xFCFCFC);
                    }
                }
            }
            if (ItemPhysic.CONFIG.general.customThrow && !ItemPhysic.CONFIG.rendering.disableThrowHUD && throwingPower > 0) {
                int renderPower = throwingPower;
                if ((renderPower /= 6) < 1) {
                    renderPower = 1;
                }
                if (renderPower > 6) {
                    renderPower = 6;
                }
                ItemPhysicClient.mc.f_91074_.m_5661_((Component)Component.m_237110_((String)"item.throw", (Object[])new Object[]{renderPower}), true);
            }
        }
    }

    public static boolean render(ItemEntity entity, float entityYaw, float partialTicks, PoseStack pose, MultiBufferSource buffer, int packedLight, ItemRenderer itemRenderer, RandomSource rand) {
        boolean applyEffects;
        Vec3 motionMultiplier;
        if (entity.m_32059_() == 0 || ((ItemEntityPhysic)entity).skipRendering() || ItemPhysic.CONFIG.rendering.vanillaRendering) {
            return false;
        }
        pose.m_85836_();
        ItemStack itemstack = entity.m_32055_();
        rand.m_188584_(itemstack.m_41619_() ? 187L : (long)(Item.m_41393_((Item)itemstack.m_41720_()) + itemstack.m_41773_()));
        BakedModel bakedmodel = itemRenderer.m_174264_(itemstack, entity.f_19853_, (LivingEntity)null, entity.m_19879_());
        boolean flag = bakedmodel.m_7539_();
        int j = ItemPhysicClient.getModelCount(itemstack);
        float rotateBy = (float)(System.nanoTime() - lastTickTime) / 2.0E8f * ItemPhysic.CONFIG.rendering.rotateSpeed;
        if (mc.m_91104_()) {
            rotateBy = 0.0f;
        }
        if ((motionMultiplier = ((EntityAccessor)entity).getStuckSpeedMultiplier()) != null && motionMultiplier.m_82556_() > 0.0) {
            rotateBy = (float)((double)rotateBy * (motionMultiplier.f_82479_ * 0.2));
        }
        pose.m_85845_(Vector3f.f_122223_.m_122270_(1.5707964f));
        pose.m_85845_(Vector3f.f_122227_.m_122270_(entity.m_146908_()));
        boolean bl = applyEffects = entity.m_32059_() != 0 && (flag || ItemPhysicClient.mc.f_91066_ != null);
        if (applyEffects) {
            if (flag) {
                if (!entity.m_20096_()) {
                    rotateBy *= 2.0f;
                    Fluid fluid = CommonPhysic.getFluid(entity);
                    if (fluid == null) {
                        fluid = CommonPhysic.getFluid(entity, true);
                    }
                    if (fluid != null) {
                        rotateBy /= 1.0f + CommonPhysic.getViscosity(fluid, entity.m_9236_());
                    }
                    entity.m_146926_(entity.m_146909_() + rotateBy);
                } else if (ItemPhysic.CONFIG.rendering.oldRotation) {
                    for (int side = 0; side < 4; ++side) {
                        double rotation = side * 90;
                        double range = 5.0;
                        if (!((double)entity.m_146909_() > rotation - range) || !((double)entity.m_146909_() < rotation + range)) continue;
                        entity.m_146926_((float)rotation);
                    }
                    if (entity.m_146909_() != 0.0f && entity.m_146909_() != 90.0f && entity.m_146909_() != 180.0f && entity.m_146909_() != 270.0f) {
                        double Abstand0 = Math.abs(entity.m_146909_());
                        double Abstand90 = Math.abs(entity.m_146909_() - 90.0f);
                        double Abstand180 = Math.abs(entity.m_146909_() - 180.0f);
                        double Abstand270 = Math.abs(entity.m_146909_() - 270.0f);
                        if (Abstand0 <= Abstand90 && Abstand0 <= Abstand180 && Abstand0 <= Abstand270) {
                            if (entity.m_146909_() < 0.0f) {
                                entity.m_146926_(entity.m_146909_() + rotateBy);
                            } else {
                                entity.m_146926_(entity.m_146909_() - rotateBy);
                            }
                        }
                        if (Abstand90 < Abstand0 && Abstand90 <= Abstand180 && Abstand90 <= Abstand270) {
                            if (entity.m_146909_() - 90.0f < 0.0f) {
                                entity.m_146926_(entity.m_146909_() + rotateBy);
                            } else {
                                entity.m_146926_(entity.m_146909_() - rotateBy);
                            }
                        }
                        if (Abstand180 < Abstand90 && Abstand180 < Abstand0 && Abstand180 <= Abstand270) {
                            if (entity.m_146909_() - 180.0f < 0.0f) {
                                entity.m_146926_(entity.m_146909_() + rotateBy);
                            } else {
                                entity.m_146926_(entity.m_146909_() - rotateBy);
                            }
                        }
                        if (Abstand270 < Abstand90 && Abstand270 < Abstand180 && Abstand270 < Abstand0) {
                            if (entity.m_146909_() - 270.0f < 0.0f) {
                                entity.m_146926_(entity.m_146909_() + rotateBy);
                            } else {
                                entity.m_146926_(entity.m_146909_() - rotateBy);
                            }
                        }
                    }
                }
            } else if (!(entity == null || Double.isNaN(entity.m_20185_()) || Double.isNaN(entity.m_20186_()) || Double.isNaN(entity.m_20189_()) || entity.f_19853_ == null)) {
                if (entity.m_20096_()) {
                    if (!flag) {
                        entity.m_146926_(0.0f);
                    }
                } else {
                    rotateBy *= 2.0f;
                    Fluid fluid = CommonPhysic.getFluid(entity);
                    if (fluid != null) {
                        rotateBy /= 1.0f + CommonPhysic.getViscosity(fluid, entity.m_9236_());
                    }
                    entity.m_146926_(entity.m_146909_() + rotateBy);
                }
            }
            if (flag) {
                pose.m_85837_(0.0, -0.2, -0.08);
            } else if (entity.f_19853_.m_8055_(entity.m_20183_()).m_60734_() == Blocks.f_50125_ || entity.f_19853_.m_8055_(entity.m_20183_().m_7495_()).m_60734_() == Blocks.f_50135_) {
                pose.m_85837_(0.0, 0.0, -0.14);
            } else {
                pose.m_85837_(0.0, 0.0, -0.04);
            }
            double height = 0.2;
            if (flag) {
                pose.m_85837_(0.0, height, 0.0);
            }
            pose.m_85845_(Vector3f.f_122225_.m_122270_(entity.m_146909_()));
            if (flag) {
                pose.m_85837_(0.0, -height, 0.0);
            }
        }
        if (!flag) {
            float f7 = -0.0f * (float)(j - 1) * 0.5f;
            float f8 = -0.0f * (float)(j - 1) * 0.5f;
            float f9 = -0.09375f * (float)(j - 1) * 0.5f;
            pose.m_85837_((double)f7, (double)f8, (double)f9);
        }
        for (int k = 0; k < j; ++k) {
            pose.m_85836_();
            if (k > 0 && flag) {
                float f11 = (rand.m_188501_() * 2.0f - 1.0f) * 0.15f;
                float f13 = (rand.m_188501_() * 2.0f - 1.0f) * 0.15f;
                float f10 = (rand.m_188501_() * 2.0f - 1.0f) * 0.15f;
                pose.m_85837_((double)f11, (double)f13, (double)f10);
            }
            itemRenderer.m_115143_(itemstack, ItemTransforms.TransformType.GROUND, false, pose, buffer, packedLight, OverlayTexture.f_118083_, bakedmodel);
            pose.m_85849_();
            if (flag) continue;
            pose.m_85837_(0.0, 0.0, 0.09375);
        }
        pose.m_85849_();
        return true;
    }

    public static int getModelCount(ItemStack stack) {
        if (stack.m_41613_() > 48) {
            return 5;
        }
        if (stack.m_41613_() > 32) {
            return 4;
        }
        if (stack.m_41613_() > 16) {
            return 3;
        }
        if (stack.m_41613_() > 1) {
            return 2;
        }
        return 1;
    }

    public static boolean onPlayerInteractClient(Level level, Player player, boolean rightClick) {
        HitResult result = ItemPhysicClient.getEntityItem((Player)ItemPhysicClient.mc.f_91074_);
        if (result != null && result.m_6662_() == HitResult.Type.ENTITY) {
            ItemEntity entity = (ItemEntity)((EntityHitResult)result).m_82443_();
            if (level.f_46443_ && entity != null) {
                player.m_6674_(InteractionHand.MAIN_HAND);
                ItemPhysic.NETWORK.sendToServer((CreativePacket)new PickupPacket(entity.m_20148_(), rightClick));
                return true;
            }
        }
        return false;
    }

    public static boolean onPlayerInteract(Player player) {
        if (ItemPhysic.CONFIG.pickup.customPickup) {
            if (!PICKUP.m_90862_()) {
                return false;
            }
            return ItemPhysicClient.onPlayerInteractClient(player.f_19853_, player, true);
        }
        return false;
    }

    public static HitResult getEntityItem(Player player) {
        double distance = CommonPhysic.getReachDistance(player);
        float partialTicks = mc.m_91297_();
        Vec3 position = player.m_20299_(partialTicks);
        Vec3 view = player.m_20252_(partialTicks);
        if (ItemPhysicClient.mc.f_91077_ != null && ItemPhysicClient.mc.f_91077_.m_6662_() != HitResult.Type.MISS) {
            distance = ItemPhysicClient.mc.f_91077_.m_82450_().m_82554_(position);
        }
        return CommonPhysic.getEntityItem(player, position, position.m_82520_(view.f_82479_ * distance, view.f_82480_ * distance, view.f_82481_ * distance));
    }
}

