/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysic.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import team.creative.itemphysic.common.ItemEntityPhysic;
import team.creative.itemphysic.server.ItemPhysicServer;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity
implements ItemEntityPhysic {
    @Shadow
    public int f_31985_;
    @Shadow
    public int f_31987_;
    public boolean skipPhysicRenderer;

    private ItemEntityMixin(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Override
    public boolean skipRendering() {
        return this.skipPhysicRenderer;
    }

    @Override
    public int age() {
        return this.f_31985_;
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, cancellable=true)
    public void hurtInject(DamageSource source, float amount, CallbackInfoReturnable<Boolean> callback) {
        if (!ItemPhysicServer.hurt((ItemEntity)this, source, amount)) {
            callback.setReturnValue((Object)false);
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        return ItemPhysicServer.interact((ItemEntity)this, player, hand);
    }

    protected void m_7840_(double height, boolean fall, BlockState state, BlockPos pos) {
        ItemPhysicServer.checkFallDamage((ItemEntity)this, height, fall, state, pos);
        super.m_7840_(height, fall, state, pos);
    }

    public boolean m_204031_(TagKey<Fluid> fluid, double p_204033_) {
        return ItemPhysicServer.updateFluidHeightAndDoFluidPushing((ItemEntity)this, fluid, p_204033_);
    }

    @Inject(method={"playerTouch(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    public void playerTouchInject(Player player, CallbackInfo info) {
        if (ItemPhysicServer.playerTouch((ItemEntity)this, player)) {
            info.cancel();
        }
    }

    @Inject(method={"fireImmune()Z"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    public void fireImmuneInject(CallbackInfoReturnable<Boolean> info) {
        if (ItemPhysicServer.fireImmune((ItemEntity)this)) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;isInWater()Z")}, require=1)
    public void updatePre(CallbackInfo info) {
        ItemPhysicServer.updatePre((ItemEntity)this, this.f_19796_);
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;isInWater()Z"), require=1)
    public boolean isInWaterRedirect(ItemEntity entity) {
        return false;
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;isInLava()Z"), require=1)
    public boolean isInLavaRedirect(ItemEntity entity) {
        return false;
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;isNoGravity()Z"), require=1)
    public boolean isNoGravityRedirect(ItemEntity entity) {
        return true;
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V", ordinal=1)}, require=1)
    public void update(CallbackInfo info) {
        ItemPhysicServer.update((ItemEntity)this);
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V"), require=3)
    public void setDeltaMovementRedirect(ItemEntity entity, Vec3 vec) {
    }
}

