/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.gui.PageNavigation;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeCategoryTab;
import mezz.jei.gui.recipes.RecipeGuiTab;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.IPaged;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.text.ITextComponent;

public class RecipeGuiTabs
implements IMouseHandler,
IPaged {
    private final IRecipeGuiLogic recipeGuiLogic;
    private final List<RecipeGuiTab> tabs = new ArrayList<RecipeGuiTab>();
    private final PageNavigation pageNavigation;
    private Rectangle2d area = new Rectangle2d(0, 0, 0, 0);
    private int pageCount = 1;
    private int pageNumber = 0;
    private int categoriesPerPage = 1;

    public RecipeGuiTabs(IRecipeGuiLogic recipeGuiLogic) {
        this.recipeGuiLogic = recipeGuiLogic;
        this.pageNavigation = new PageNavigation(this, true);
    }

    public void initLayout(RecipesGui recipesGui) {
        ImmutableList<IRecipeCategory<?>> categories = this.recipeGuiLogic.getRecipeCategories();
        if (!categories.isEmpty()) {
            int totalWidth = 0;
            this.categoriesPerPage = 0;
            for (int i = 0; i < categories.size() && totalWidth + 24 <= recipesGui.getXSize() - 4; ++i) {
                totalWidth += 24;
                ++this.categoriesPerPage;
            }
            this.area = new Rectangle2d(recipesGui.getGuiLeft() + 2, recipesGui.getGuiTop() - 24 + 3, totalWidth, 24);
            this.pageCount = MathUtil.divideCeil(categories.size(), this.categoriesPerPage);
            IRecipeCategory<?> currentCategory = this.recipeGuiLogic.getSelectedRecipeCategory();
            int categoryIndex = categories.indexOf(currentCategory);
            this.pageNumber = categoryIndex / this.categoriesPerPage;
            int navHeight = 20;
            Rectangle2d navigationArea = new Rectangle2d(this.area.func_199318_a(), this.area.func_199319_b() - (2 + navHeight), this.area.func_199316_c(), navHeight);
            this.pageNavigation.updateBounds(navigationArea);
            this.updateLayout();
        }
    }

    private void updateLayout() {
        int index;
        this.tabs.clear();
        ImmutableList<IRecipeCategory<?>> categories = this.recipeGuiLogic.getRecipeCategories();
        int tabX = this.area.func_199318_a();
        int startIndex = this.pageNumber * this.categoriesPerPage;
        for (int i = 0; i < this.categoriesPerPage && (index = i + startIndex) < categories.size(); ++i) {
            IRecipeCategory category = (IRecipeCategory)categories.get(index);
            RecipeCategoryTab tab = new RecipeCategoryTab(this.recipeGuiLogic, category, tabX, this.area.func_199319_b());
            this.tabs.add(tab);
            tabX += 24;
        }
        this.pageNavigation.updatePageState();
    }

    public void draw(Minecraft minecraft, MatrixStack matrixStack, int mouseX, int mouseY) {
        IRecipeCategory<?> selectedCategory = this.recipeGuiLogic.getSelectedRecipeCategory();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RecipeGuiTab hovered = null;
        RenderSystem.disableDepthTest();
        RenderSystem.enableAlphaTest();
        for (RecipeGuiTab tab : this.tabs) {
            boolean selected = tab.isSelected(selectedCategory);
            tab.draw(selected, matrixStack, mouseX, mouseY);
            if (!tab.isMouseOver(mouseX, mouseY)) continue;
            hovered = tab;
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.enableDepthTest();
        this.pageNavigation.draw(minecraft, matrixStack, mouseX, mouseY, minecraft.func_184121_ak());
        if (hovered != null) {
            List<ITextComponent> tooltip = hovered.getTooltip();
            TooltipRenderer.drawHoveringText(tooltip, mouseX, mouseY, matrixStack);
        }
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return MathUtil.contains(this.area, mouseX, mouseY) || this.pageNavigation.isMouseOver(mouseX, mouseY);
    }

    @Override
    public boolean handleMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            for (RecipeGuiTab tab : this.tabs) {
                if (!tab.isMouseOver(mouseX, mouseY)) continue;
                tab.handleMouseClicked(mouseX, mouseY, mouseButton);
                return true;
            }
            if (this.pageNavigation.isMouseOver(mouseX, mouseY)) {
                return this.pageNavigation.handleMouseClickedButtons(mouseX, mouseY, mouseButton);
            }
        }
        return false;
    }

    @Override
    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        return false;
    }

    @Override
    public boolean nextPage() {
        this.pageNumber = this.hasNext() ? ++this.pageNumber : 0;
        this.updateLayout();
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.pageNumber + 1 < this.pageCount;
    }

    @Override
    public boolean previousPage() {
        this.pageNumber = this.hasPrevious() ? --this.pageNumber : this.pageCount - 1;
        this.updateLayout();
        return true;
    }

    @Override
    public boolean hasPrevious() {
        return this.pageNumber > 0;
    }

    @Override
    public int getPageCount() {
        return this.pageCount;
    }

    @Override
    public int getPageNumber() {
        return this.pageNumber;
    }
}

