/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.jei.info;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;

public class IngredientInfoRecipe<T> {
    private static final int lineSpacing = 2;
    private final List<ITextProperties> description;
    private final List<T> ingredients;
    private final IIngredientType<T> ingredientType;

    public static <T> List<IngredientInfoRecipe<T>> create(List<T> ingredients, IIngredientType<T> ingredientType, String ... descriptionKeys) {
        ArrayList<IngredientInfoRecipe<T>> recipes = new ArrayList<IngredientInfoRecipe<T>>();
        List<ITextProperties> descriptionLines = IngredientInfoRecipe.translateDescriptionLines(descriptionKeys);
        descriptionLines = IngredientInfoRecipe.expandNewlines(descriptionLines);
        descriptionLines = IngredientInfoRecipe.wrapDescriptionLines(descriptionLines);
        int lineCount = descriptionLines.size();
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.field_71466_p.getClass();
        int maxLinesPerPage = 105 / (9 + 2);
        int pageCount = MathUtil.divideCeil(lineCount, maxLinesPerPage);
        for (int i = 0; i < pageCount; ++i) {
            int startLine = i * maxLinesPerPage;
            int endLine = Math.min((i + 1) * maxLinesPerPage, lineCount);
            List<ITextProperties> description = descriptionLines.subList(startLine, endLine);
            IngredientInfoRecipe<T> recipe = new IngredientInfoRecipe<T>(ingredients, ingredientType, description);
            recipes.add(recipe);
        }
        return recipes;
    }

    private static List<ITextProperties> translateDescriptionLines(String ... descriptionKeys) {
        ArrayList<ITextProperties> descriptionLines = new ArrayList<ITextProperties>();
        for (String descriptionKey : descriptionKeys) {
            TranslationTextComponent translatedLine = new TranslationTextComponent(descriptionKey);
            descriptionLines.add((ITextProperties)translatedLine);
        }
        return descriptionLines;
    }

    private static List<ITextProperties> expandNewlines(List<ITextProperties> descriptionLines) {
        ArrayList<ITextProperties> descriptionLinesExpanded = new ArrayList<ITextProperties>();
        for (ITextProperties descriptionLine : descriptionLines) {
            Optional optionalExpandedLines = descriptionLine.func_230438_a_(line -> Optional.of(line.split("\\\\n")));
            optionalExpandedLines.ifPresent(descriptionLineExpanded -> {
                for (String s : descriptionLineExpanded) {
                    descriptionLinesExpanded.add((ITextProperties)new StringTextComponent(s));
                }
            });
        }
        return descriptionLinesExpanded;
    }

    private static List<ITextProperties> wrapDescriptionLines(List<ITextProperties> descriptionLines) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ArrayList<ITextProperties> descriptionLinesWrapped = new ArrayList<ITextProperties>();
        for (ITextProperties descriptionLine : descriptionLines) {
            List textLines = minecraft.field_71466_p.func_238420_b_().func_238362_b_(descriptionLine, 160, Style.field_240709_b_);
            descriptionLinesWrapped.addAll(textLines);
        }
        return descriptionLinesWrapped;
    }

    private IngredientInfoRecipe(List<T> ingredients, IIngredientType<T> ingredientType, List<ITextProperties> description) {
        this.description = description;
        this.ingredients = ingredients;
        this.ingredientType = ingredientType;
    }

    public List<ITextProperties> getDescription() {
        return this.description;
    }

    public IIngredientType<T> getIngredientType() {
        return this.ingredientType;
    }

    public List<T> getIngredients() {
        return this.ingredients;
    }
}

