/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.config.NameMap;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.color.ColorGetter;
import mezz.jei.color.ColorNamer;
import mezz.jei.config.ConfigValues;
import mezz.jei.config.IJEIConfig;
import mezz.jei.util.GiveMode;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ClientConfig
implements IJEIConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private static ClientConfig instance;
    public static final int smallestNumColumns = 4;
    public static final int largestNumColumns = 100;
    public static final int minRecipeGuiHeight = 175;
    private final ConfigValues values;
    private List<String> searchColors = Arrays.asList(ColorGetter.getColorDefaults());
    private final ForgeConfigSpec.BooleanValue debugModeEnabled;
    private final ForgeConfigSpec.BooleanValue centerSearchBarEnabled;
    private final ForgeConfigSpec.EnumValue<GiveMode> giveMode;
    private final ForgeConfigSpec.IntValue maxColumns;
    private final ForgeConfigSpec.IntValue maxRecipeGuiHeight;
    private final ForgeConfigSpec.ConfigValue<List<?>> searchColorsCfg;

    public ClientConfig(ForgeConfigSpec.Builder builder) {
        instance = this;
        this.values = new ConfigValues();
        ConfigValues defaultVals = new ConfigValues();
        builder.push("advanced");
        builder.comment("Debug mode enabled");
        this.debugModeEnabled = builder.define("DebugMode", defaultVals.debugModeEnabled);
        builder.comment("Display search bar in the center");
        this.centerSearchBarEnabled = builder.define("CenterSearch", defaultVals.centerSearchBarEnabled);
        builder.comment("How items should be handed to you");
        this.giveMode = builder.defineEnum("GiveMode", (Enum)defaultVals.giveMode);
        builder.comment("Max number of columns shown");
        this.maxColumns = builder.defineInRange("MaxColumns", defaultVals.maxColumns, 1, Integer.MAX_VALUE);
        builder.comment("Max. recipe gui height");
        this.maxRecipeGuiHeight = builder.defineInRange("RecipeGuiHeight", defaultVals.maxRecipeGuiHeight, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("colors");
        builder.comment("Color values to search for");
        this.searchColorsCfg = builder.defineList("SearchColors", Arrays.asList(ColorGetter.getColorDefaults()), obj -> true);
        builder.pop();
    }

    @Deprecated
    public static ClientConfig getInstance() {
        Preconditions.checkNotNull((Object)instance);
        return instance;
    }

    @Override
    public void buildSettingsGUI(ConfigGroup group) {
        ConfigValues defaultVals = new ConfigValues();
        group.addBool(this.cfgTranslation("centerSearchBarEnabled"), this.values.centerSearchBarEnabled, v -> {
            this.centerSearchBarEnabled.set(v);
            this.values.centerSearchBarEnabled = v;
        }, defaultVals.centerSearchBarEnabled);
        group.addEnum(this.cfgTranslation("giveMode"), (Object)this.values.giveMode, v -> {
            this.giveMode.set((Object)v);
            this.values.giveMode = v;
        }, NameMap.of((Object)((Object)defaultVals.giveMode), (Object[])GiveMode.values()).create());
        group.addInt(this.cfgTranslation("maxColumns"), this.values.maxColumns, v -> {
            this.maxColumns.set(v);
            this.values.maxColumns = v;
        }, defaultVals.maxColumns, 1, Integer.MAX_VALUE);
        group.addInt(this.cfgTranslation("maxRecipeGuiHeight"), this.values.maxRecipeGuiHeight, v -> {
            this.maxRecipeGuiHeight.set(v);
            this.values.maxRecipeGuiHeight = v;
        }, defaultVals.maxRecipeGuiHeight, 1, Integer.MAX_VALUE);
    }

    private String cfgTranslation(String name) {
        return "advanced." + name;
    }

    @Override
    public void reload() {
        this.values.debugModeEnabled = (Boolean)this.debugModeEnabled.get();
        this.values.centerSearchBarEnabled = (Boolean)this.centerSearchBarEnabled.get();
        this.values.giveMode = (GiveMode)((Object)this.giveMode.get());
        this.values.maxColumns = (Integer)this.maxColumns.get();
        this.values.maxRecipeGuiHeight = (Integer)this.maxRecipeGuiHeight.get();
        this.searchColors = (List)this.searchColorsCfg.get();
        this.syncSearchColorsConfig();
    }

    public boolean isDebugModeEnabled() {
        return this.values.debugModeEnabled;
    }

    public boolean isCenterSearchBarEnabled() {
        return this.values.centerSearchBarEnabled;
    }

    public GiveMode getGiveMode() {
        return this.values.giveMode;
    }

    public int getMaxColumns() {
        return this.values.maxColumns;
    }

    public int getMaxRecipeGuiHeight() {
        return this.values.maxRecipeGuiHeight;
    }

    private void syncSearchColorsConfig() {
        ImmutableMap.Builder searchColorsMapBuilder = ImmutableMap.builder();
        for (String entry : this.searchColors) {
            String[] values = entry.split(":");
            if (values.length != 2) {
                LOGGER.error("Invalid format for searchColor entry: {}", (Object)entry);
                continue;
            }
            try {
                String name = values[0];
                Integer colorValue = Integer.decode("0x" + values[1]);
                searchColorsMapBuilder.put((Object)colorValue, (Object)name);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Invalid number format for searchColor entry: {}", (Object)entry, (Object)e);
            }
        }
        ColorNamer colorNamer = new ColorNamer((ImmutableMap<Integer, String>)searchColorsMapBuilder.build());
        Internal.setColorNamer(colorNamer);
    }
}

