/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import javax.annotation.Nullable;
import mezz.jei.config.ClientConfig;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IIngredientFilterConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.GuiIngredientProperties;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.GridAlignment;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.input.MouseUtil;
import mezz.jei.network.Network;
import mezz.jei.network.packets.PacketDeletePlayerItem;
import mezz.jei.render.IngredientListBatchRenderer;
import mezz.jei.render.IngredientListElementRenderer;
import mezz.jei.render.IngredientListSlot;
import mezz.jei.util.GiveMode;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.ItemHandlerHelper;

public class IngredientGrid
implements IShowsRecipeFocuses {
    private static final int INGREDIENT_PADDING = 1;
    public static final int INGREDIENT_WIDTH = GuiIngredientProperties.getWidth(1);
    public static final int INGREDIENT_HEIGHT = GuiIngredientProperties.getHeight(1);
    private final GridAlignment alignment;
    private final RecipesGui recipesGui;
    private final GuiScreenHelper guiScreenHelper;
    private Rectangle2d area = new Rectangle2d(0, 0, 0, 0);
    protected final IngredientListBatchRenderer guiIngredientSlots;
    private final IIngredientFilterConfig ingredientFilterConfig;
    private final ClientConfig clientConfig;
    private final IWorldConfig worldConfig;

    public IngredientGrid(GridAlignment alignment, IEditModeConfig editModeConfig, IIngredientFilterConfig ingredientFilterConfig, ClientConfig clientConfig, IWorldConfig worldConfig, GuiScreenHelper guiScreenHelper, RecipesGui recipesGui) {
        this.alignment = alignment;
        this.recipesGui = recipesGui;
        this.guiIngredientSlots = new IngredientListBatchRenderer(editModeConfig, worldConfig);
        this.ingredientFilterConfig = ingredientFilterConfig;
        this.clientConfig = clientConfig;
        this.worldConfig = worldConfig;
        this.guiScreenHelper = guiScreenHelper;
    }

    public int size() {
        return this.guiIngredientSlots.size();
    }

    public boolean updateBounds(Rectangle2d availableArea, int minWidth, Collection<Rectangle2d> exclusionAreas) {
        int columns = Math.min(availableArea.func_199316_c() / INGREDIENT_WIDTH, this.clientConfig.getMaxColumns());
        int rows = availableArea.func_199317_d() / INGREDIENT_HEIGHT;
        int ingredientsWidth = columns * INGREDIENT_WIDTH;
        int width = Math.max(ingredientsWidth, minWidth);
        int height = rows * INGREDIENT_HEIGHT;
        int x = this.alignment == GridAlignment.LEFT ? availableArea.func_199318_a() + (availableArea.func_199316_c() - width) : availableArea.func_199318_a();
        int y = availableArea.func_199319_b() + (availableArea.func_199317_d() - height) / 2;
        int xOffset = x + Math.max(0, (width - ingredientsWidth) / 2);
        this.area = new Rectangle2d(x, y, width, height);
        this.guiIngredientSlots.clear();
        if (rows == 0 || columns < 4) {
            return false;
        }
        for (int row = 0; row < rows; ++row) {
            int y1 = y + row * INGREDIENT_HEIGHT;
            for (int column = 0; column < columns; ++column) {
                int x1 = xOffset + column * INGREDIENT_WIDTH;
                IngredientListSlot ingredientListSlot = new IngredientListSlot(x1, y1, 1);
                Rectangle2d stackArea = ingredientListSlot.getArea();
                boolean blocked = MathUtil.intersects(exclusionAreas, stackArea);
                ingredientListSlot.setBlocked(blocked);
                this.guiIngredientSlots.add(ingredientListSlot);
            }
        }
        return true;
    }

    public Rectangle2d getArea() {
        return this.area;
    }

    public void draw(Minecraft minecraft, MatrixStack matrixStack, int mouseX, int mouseY) {
        IngredientListElementRenderer<?> hovered;
        RenderSystem.disableBlend();
        this.guiIngredientSlots.render(minecraft, matrixStack);
        if (!this.shouldDeleteItemOnClick(minecraft, mouseX, mouseY) && this.isMouseOver(mouseX, mouseY) && (hovered = this.guiIngredientSlots.getHovered(mouseX, mouseY)) != null) {
            hovered.drawHighlight(matrixStack);
        }
        RenderSystem.enableAlphaTest();
    }

    public void drawTooltips(Minecraft minecraft, MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (this.shouldDeleteItemOnClick(minecraft, mouseX, mouseY)) {
                TranslationTextComponent deleteItem = new TranslationTextComponent("jei.tooltip.delete.item");
                TooltipRenderer.drawHoveringText((ITextProperties)deleteItem, mouseX, mouseY, matrixStack);
            } else {
                IngredientListElementRenderer<?> hovered = this.guiIngredientSlots.getHovered(mouseX, mouseY);
                if (hovered != null) {
                    hovered.drawTooltip(matrixStack, mouseX, mouseY, this.ingredientFilterConfig, this.worldConfig);
                }
            }
        }
    }

    private boolean shouldDeleteItemOnClick(Minecraft minecraft, double mouseX, double mouseY) {
        ItemStack itemStack;
        ClientPlayerEntity player;
        if (this.worldConfig.isDeleteItemsInCheatModeActive() && (player = minecraft.field_71439_g) != null && !(itemStack = player.field_71071_by.func_70445_o()).func_190926_b() && !this.recipesGui.isOpen()) {
            ItemStack value;
            IClickedIngredient<?> ingredientUnderMouse;
            GiveMode giveMode = this.clientConfig.getGiveMode();
            return giveMode != GiveMode.MOUSE_PICKUP || (ingredientUnderMouse = this.getIngredientUnderMouse(mouseX, mouseY)) == null || !(ingredientUnderMouse.getValue() instanceof ItemStack) || !ItemHandlerHelper.canItemStacksStack((ItemStack)itemStack, (ItemStack)(value = (ItemStack)ingredientUnderMouse.getValue()));
        }
        return false;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return MathUtil.contains(this.area, mouseX, mouseY) && !this.guiScreenHelper.isInGuiExclusionArea(mouseX, mouseY);
    }

    public boolean handleMouseClicked(double mouseX, double mouseY) {
        ItemStack itemStack;
        ClientPlayerEntity player;
        Minecraft minecraft;
        if (this.isMouseOver(mouseX, mouseY) && this.shouldDeleteItemOnClick(minecraft = Minecraft.func_71410_x(), mouseX, mouseY) && (player = minecraft.field_71439_g) != null && !(itemStack = player.field_71071_by.func_70445_o()).func_190926_b()) {
            player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
            PacketDeletePlayerItem packet = new PacketDeletePlayerItem(itemStack);
            Network.sendPacketToServer(packet);
            return true;
        }
        return false;
    }

    @Nullable
    public IIngredientListElement<?> getElementUnderMouse() {
        IngredientListElementRenderer<?> hovered = this.guiIngredientSlots.getHovered(MouseUtil.getX(), MouseUtil.getY());
        if (hovered != null) {
            return hovered.getElement();
        }
        return null;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            ClickedIngredient<?> clicked = this.guiIngredientSlots.getIngredientUnderMouse(mouseX, mouseY);
            if (clicked != null) {
                clicked.setAllowsCheating();
            }
            return clicked;
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return true;
    }
}

