/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.api.runtime.IBookmarkOverlay;
import mezz.jei.bookmarks.BookmarkList;
import mezz.jei.config.ClientConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IngredientGrid;
import mezz.jei.gui.overlay.IngredientGridWithNavigation;
import mezz.jei.gui.overlay.bookmarks.BookmarkButton;
import mezz.jei.gui.overlay.bookmarks.ILeftAreaContent;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.gui.textures.Textures;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.util.CommandUtil;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.ItemStack;

public class BookmarkOverlay
implements IShowsRecipeFocuses,
ILeftAreaContent,
IBookmarkOverlay {
    private static final int BUTTON_SIZE = 20;
    private Rectangle2d parentArea = new Rectangle2d(0, 0, 0, 0);
    private Rectangle2d displayArea = new Rectangle2d(0, 0, 0, 0);
    private final IngredientGridWithNavigation contents;
    private final GuiIconToggleButton bookmarkButton;
    private boolean hasRoom = false;
    private final BookmarkList bookmarkList;
    private final ClientConfig clientConfig;
    private final IWorldConfig worldConfig;

    public BookmarkOverlay(BookmarkList bookmarkList, Textures textures, IngredientGridWithNavigation contents, ClientConfig clientConfig, IWorldConfig worldConfig) {
        this.bookmarkList = bookmarkList;
        this.clientConfig = clientConfig;
        this.worldConfig = worldConfig;
        this.bookmarkButton = BookmarkButton.create(this, bookmarkList, textures, worldConfig);
        this.contents = contents;
        bookmarkList.addListener(() -> contents.updateLayout(false));
    }

    public boolean isListDisplayed() {
        return this.worldConfig.isBookmarkOverlayEnabled() && this.hasRoom && !this.bookmarkList.isEmpty();
    }

    public boolean hasRoom() {
        return this.hasRoom;
    }

    @Override
    public void updateBounds(Rectangle2d area, Set<Rectangle2d> guiExclusionAreas) {
        this.parentArea = area;
        this.hasRoom = this.updateBounds(guiExclusionAreas);
    }

    @Override
    public void drawScreen(Minecraft minecraft, MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isListDisplayed()) {
            this.contents.draw(minecraft, matrixStack, mouseX, mouseY, partialTicks);
        }
        this.bookmarkButton.draw(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void drawOnForeground(ContainerScreen<?> gui, int mouseX, int mouseY) {
    }

    @Override
    public void drawTooltips(Minecraft minecraft, MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            this.contents.drawTooltips(minecraft, matrixStack, mouseX, mouseY);
        }
        this.bookmarkButton.drawTooltips(matrixStack, mouseX, mouseY);
    }

    private static int getMinWidth() {
        return Math.max(80, 4 * IngredientGrid.INGREDIENT_WIDTH);
    }

    public boolean updateBounds(Set<Rectangle2d> guiExclusionAreas) {
        this.displayArea = this.parentArea;
        int minWidth = BookmarkOverlay.getMinWidth();
        if (this.displayArea.func_199316_c() < minWidth) {
            return false;
        }
        Rectangle2d availableContentsArea = new Rectangle2d(this.displayArea.func_199318_a(), this.displayArea.func_199319_b(), this.displayArea.func_199316_c(), this.displayArea.func_199317_d() - 24);
        boolean contentsHasRoom = this.contents.updateBounds(availableContentsArea, guiExclusionAreas, minWidth);
        Rectangle2d contentsArea = this.contents.getArea();
        this.displayArea = new Rectangle2d(contentsArea.func_199318_a(), this.displayArea.func_199319_b(), contentsArea.func_199316_c(), this.displayArea.func_199317_d());
        this.bookmarkButton.updateBounds(new Rectangle2d(this.displayArea.func_199318_a(), (int)Math.floor(this.displayArea.func_199319_b() + this.displayArea.func_199317_d()) - 20 - 2, 20, 20));
        this.contents.updateLayout(false);
        return contentsHasRoom;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isListDisplayed()) {
            return this.contents.getIngredientUnderMouse(mouseX, mouseY);
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return this.isListDisplayed() && this.contents.canSetFocusWithMouse();
    }

    @Override
    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        return this.isListDisplayed() && this.contents.isMouseOver(mouseX, mouseY) && this.contents.handleMouseScrolled(mouseX, mouseY, scrollDelta);
    }

    @Override
    public boolean handleMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.isListDisplayed()) {
            if (MathUtil.contains(this.displayArea, mouseX, mouseY)) {
                IClickedIngredient<?> clicked;
                Minecraft minecraft = Minecraft.func_71410_x();
                Screen currentScreen = minecraft.field_71462_r;
                InputMappings.Input input = InputMappings.Type.MOUSE.func_197944_a(mouseButton);
                if (currentScreen != null && !(currentScreen instanceof RecipesGui) && (mouseButton == 0 || mouseButton == 1 || minecraft.field_71474_y.field_74322_I.isActiveAndMatches(input)) && (clicked = this.getIngredientUnderMouse(mouseX, mouseY)) != null && this.worldConfig.isCheatItemsEnabled()) {
                    ItemStack itemStack = clicked.getCheatItemStack();
                    if (!itemStack.func_190926_b()) {
                        CommandUtil.giveStack(itemStack, input, this.clientConfig);
                    }
                    clicked.onClickHandled();
                    return true;
                }
            }
            if (this.contents.isMouseOver(mouseX, mouseY)) {
                this.contents.handleMouseClicked(mouseX, mouseY, mouseButton);
            }
        }
        if (this.bookmarkButton.isMouseOver(mouseX, mouseY)) {
            return this.bookmarkButton.handleMouseClick(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse() {
        IIngredientListElement<?> elementUnderMouse;
        if (this.isListDisplayed() && (elementUnderMouse = this.contents.getElementUnderMouse()) != null) {
            return elementUnderMouse.getIngredient();
        }
        return null;
    }
}

