/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.config.ClientConfig;
import mezz.jei.config.ModIdFormattingConfig;
import mezz.jei.ingredients.AbstractModIdHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.StringUtils;

public class ForgeModIdHelper
extends AbstractModIdHelper {
    private final ClientConfig config;
    private final ModIdFormattingConfig modIdFormattingConfig;

    public ForgeModIdHelper(ClientConfig config, ModIdFormattingConfig modIdFormattingConfig) {
        this.config = config;
        this.modIdFormattingConfig = modIdFormattingConfig;
    }

    @Override
    public String getModNameForModId(String modId) {
        return ModList.get().getModContainerById(modId).map(modContainer -> modContainer.getModInfo().getDisplayName()).orElse(StringUtils.capitalize((String)modId));
    }

    @Override
    public boolean isDisplayingModNameEnabled() {
        String modNameFormat = this.modIdFormattingConfig.getModNameFormat();
        return !modNameFormat.isEmpty();
    }

    @Override
    public String getFormattedModNameForModId(String modId) {
        String modName = this.getModNameForModId(modId);
        modName = ForgeModIdHelper.removeChatFormatting(modName);
        String modNameFormat = this.modIdFormattingConfig.getModNameFormat();
        if (!modNameFormat.isEmpty()) {
            if (modNameFormat.contains("%MODNAME%")) {
                return StringUtils.replaceOnce((String)modNameFormat, (String)"%MODNAME%", (String)modName);
            }
            return modNameFormat + modName;
        }
        return modName;
    }

    private static String removeChatFormatting(String string) {
        String withoutFormattingCodes = TextFormatting.func_110646_a((String)string);
        return withoutFormattingCodes == null ? "" : withoutFormattingCodes;
    }

    @Override
    public <T> List<ITextComponent> addModNameToIngredientTooltip(List<ITextComponent> tooltip, T ingredient, IIngredientHelper<T> ingredientHelper) {
        if (this.config.isDebugModeEnabled() && Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            tooltip = this.addDebugInfo(tooltip, ingredient, ingredientHelper);
        }
        if (this.modIdFormattingConfig.isModNameFormatOverrideActive() && ingredient instanceof ItemStack) {
            return tooltip;
        }
        String modNameFormat = this.modIdFormattingConfig.getModNameFormat();
        if (modNameFormat.isEmpty()) {
            return tooltip;
        }
        return super.addModNameToIngredientTooltip(tooltip, ingredient, ingredientHelper);
    }

    private <T> List<ITextComponent> addDebugInfo(List<ITextComponent> tooltip, T ingredient, IIngredientHelper<T> ingredientHelper) {
        tooltip = new ArrayList<ITextComponent>(tooltip);
        StringTextComponent jeiDebug = new StringTextComponent("JEI Debug:");
        StringTextComponent info = new StringTextComponent("info: " + ingredientHelper.getErrorInfo(ingredient));
        StringTextComponent uid = new StringTextComponent("uid: " + ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient));
        tooltip.add((ITextComponent)jeiDebug.func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)info.func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)uid.func_240699_a_(TextFormatting.GRAY));
        return tooltip;
    }
}

