/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import mezz.jei.config.ClientConfig;
import mezz.jei.config.ServerInfo;
import mezz.jei.network.Network;
import mezz.jei.network.packets.PacketGiveItemStack;
import mezz.jei.network.packets.PacketSetHotbarItemStack;
import mezz.jei.util.CommandUtilServer;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.GiveMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CommandUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private CommandUtil() {
    }

    public static void giveStack(ItemStack itemStack, InputMappings.Input input, ClientConfig clientConfig) {
        GiveMode giveMode = clientConfig.getGiveMode();
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEntity player = minecraft.field_71439_g;
        if (player == null) {
            LOGGER.error("Can't give stack, there is no player");
            return;
        }
        if (minecraft.field_71462_r instanceof CreativeScreen && giveMode == GiveMode.MOUSE_PICKUP) {
            int amount = GiveMode.getStackSize(giveMode, itemStack, input);
            ItemStack sendStack = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)amount);
            CommandUtilServer.mousePickupItemStack((PlayerEntity)player, sendStack);
        } else if (ServerInfo.isJeiOnServer()) {
            int amount = GiveMode.getStackSize(giveMode, itemStack, input);
            ItemStack sendStack = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)amount);
            PacketGiveItemStack packet = new PacketGiveItemStack(sendStack, giveMode);
            Network.sendPacketToServer(packet);
        } else {
            int amount = GiveMode.getStackSize(GiveMode.INVENTORY, itemStack, input);
            CommandUtil.giveStackVanilla(itemStack, amount);
        }
    }

    public static void setHotbarStack(ItemStack itemStack, int hotbarSlot) {
        if (ServerInfo.isJeiOnServer()) {
            ItemStack sendStack = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)itemStack.func_77976_d());
            PacketSetHotbarItemStack packet = new PacketSetHotbarItemStack(sendStack, hotbarSlot);
            Network.sendPacketToServer(packet);
        }
    }

    private static void giveStackVanilla(ItemStack itemStack, int amount) {
        if (itemStack.func_190926_b()) {
            String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.error("Empty itemStack: {}", (Object)stackInfo, (Object)new IllegalArgumentException());
            return;
        }
        Item item = itemStack.func_77973_b();
        ResourceLocation itemResourceLocation = item.getRegistryName();
        ErrorUtil.checkNotNull(itemResourceLocation, "itemStack.getItem().getRegistryName()");
        ClientPlayerEntity sender = Minecraft.func_71410_x().field_71439_g;
        if (sender != null) {
            if (sender.func_195051_bN().func_197034_c(2)) {
                CommandUtil.sendGiveAction(sender, itemStack, amount);
            } else if (sender.func_184812_l_()) {
                CommandUtil.sendCreativeInventoryActions(sender, itemStack, amount);
            } else {
                CommandUtil.sendGiveAction(sender, itemStack, amount);
            }
        }
    }

    private static void sendGiveAction(ClientPlayerEntity sender, ItemStack itemStack, int amount) {
        Object[] commandParameters = CommandUtilServer.getGiveCommandParameters((PlayerEntity)sender, itemStack, amount);
        String fullCommand = "/give " + StringUtils.join((Object[])commandParameters, (String)" ");
        CommandUtil.sendChatMessage(sender, fullCommand);
    }

    private static void sendChatMessage(ClientPlayerEntity sender, String chatMessage) {
        if (chatMessage.length() <= 256) {
            sender.func_71165_d(chatMessage);
        } else {
            TranslationTextComponent errorMessage = new TranslationTextComponent("jei.chat.error.command.too.long");
            errorMessage.func_150256_b().func_240721_b_(TextFormatting.RED);
            sender.func_146105_b((ITextComponent)errorMessage, false);
            StringTextComponent chatMessageComponent = new StringTextComponent(chatMessage);
            chatMessageComponent.func_150256_b().func_240721_b_(TextFormatting.RED);
            sender.func_146105_b((ITextComponent)chatMessageComponent, false);
        }
    }

    private static void sendCreativeInventoryActions(ClientPlayerEntity sender, ItemStack stack, int amount) {
        for (int i = 0; i < sender.field_71071_by.field_70462_a.size() && amount > 0; ++i) {
            ItemStack currentStack = (ItemStack)sender.field_71071_by.field_70462_a.get(i);
            if (currentStack.func_190926_b()) {
                ItemStack sendAllRemaining = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)amount);
                CommandUtil.sendSlotPacket(sendAllRemaining, i);
                amount = 0;
                continue;
            }
            if (!currentStack.func_77969_a(stack) || currentStack.func_77976_d() <= currentStack.func_190916_E()) continue;
            int canAdd = Math.min(currentStack.func_77976_d() - currentStack.func_190916_E(), amount);
            ItemStack fillRemainingSpace = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(canAdd + currentStack.func_190916_E()));
            CommandUtil.sendSlotPacket(fillRemainingSpace, i);
            amount -= canAdd;
        }
        if (amount > 0) {
            ItemStack toDrop = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)amount);
            CommandUtil.sendSlotPacket(toDrop, -1);
        }
    }

    private static void sendSlotPacket(ItemStack stack, int mainInventorySlot) {
        if (mainInventorySlot < 9 && mainInventorySlot != -1) {
            mainInventorySlot += 36;
        }
        Minecraft.func_71410_x().field_71442_b.func_78761_a(stack, mainInventorySlot);
    }
}

