/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.vote;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ConfirmOpenLinkScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WorldSelectionScreen;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="jei", value={Dist.CLIENT})
public class GoVoteHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String BRAND = "mezz's mods";
    private static final String MARKER_PATH = ".vote2020_marker";
    private static final LocalDate ELECTION_DAY = LocalDate.of(2020, Month.NOVEMBER, 3);
    public static final String VOTE_ORG_LINK = "https://vote.org/";
    private static final int HEADER_COLOR = -3140034;
    private static final int BG_COLOR = -14658413;
    private static boolean shownThisSession = false;
    private static final List<String> commonUsaLanguages = Arrays.asList(Locale.ENGLISH.getLanguage(), "es", Locale.SIMPLIFIED_CHINESE.getLanguage(), "tl", "vi", Locale.FRENCH.getLanguage());
    private static boolean markerAlreadyExists = false;

    public static void init() {
        if (GoVoteHandler.isAfterElectionDay()) {
            return;
        }
        try {
            Path path = Paths.get(MARKER_PATH, new String[0]);
            Files.createFile(path, new FileAttribute[0]);
            Files.setAttribute(path, "dos:hidden", true, new LinkOption[0]);
        }
        catch (FileAlreadyExistsException ex) {
            LOGGER.debug("Go vote handler: Marker already exists");
            markerAlreadyExists = true;
        }
        catch (IOException e) {
            LOGGER.warn("IO exception when trying to create marker", (Throwable)e);
        }
    }

    public static boolean isAfterElectionDay() {
        return LocalDate.now().isAfter(ELECTION_DAY);
    }

    public static boolean isProbablyUsaLocale() {
        Locale locale = Locale.getDefault();
        if (locale == null) {
            return false;
        }
        String usaCountry = Locale.US.getCountry();
        if (!usaCountry.equals(locale.getCountry())) {
            return false;
        }
        return commonUsaLanguages.stream().anyMatch(language -> language.equals(locale.getLanguage()));
    }

    @SubscribeEvent
    public static void clientTick(GuiOpenEvent event) {
        Screen curr = event.getGui();
        if ((curr instanceof WorldSelectionScreen || curr instanceof MultiplayerScreen) && GoVoteHandler.shouldShow()) {
            event.setGui((Screen)new GoVoteScreen(curr));
            shownThisSession = true;
        }
    }

    private static boolean shouldShow() {
        return !shownThisSession && !GoVoteHandler.isAfterElectionDay() && !markerAlreadyExists && GoVoteHandler.isProbablyUsaLocale();
    }

    public static void displayOpenLinkScreen(String url, Minecraft minecraft, Screen currentScreen) {
        minecraft.func_147108_a((Screen)new ConfirmOpenLinkScreen(doIt -> GoVoteHandler.consume(doIt, minecraft, currentScreen, url), url, true));
    }

    private static void consume(boolean doIt, Minecraft minecraft, Screen currentScreen, String url) {
        minecraft.func_147108_a(currentScreen);
        if (doIt) {
            Util.func_110647_a().func_195640_a(url);
        }
    }

    private static class GoVoteScreen
    extends Screen {
        private static final int TICKS_PER_GROUP = 50;
        private static final int LINE_SPACING = 3;
        private final Screen parent;
        private int ticksElapsed = 0;
        private final List<List<ITextComponent>> message = new ArrayList<List<ITextComponent>>();
        private int ticksForFullMessage = 0;

        protected GoVoteScreen(Screen parent) {
            super((ITextComponent)new StringTextComponent(""));
            this.parent = parent;
            this.addGroup(new ITextComponent[]{GoVoteScreen.s("Please read the following message from mezz's mods.")});
            this.addGroup(new ITextComponent[]{StringTextComponent.field_240750_d_, GoVoteScreen.s("We are at a unique crossroads in the history of our country.")});
            this.addGroup(new ITextComponent[]{StringTextComponent.field_240750_d_, GoVoteScreen.s("In this time of heightened polarization,"), GoVoteScreen.s("breakdown of political decorum, and fear,")});
            this.addGroup(new ITextComponent[]{GoVoteScreen.s("it is tempting to succumb to apathy,"), GoVoteScreen.s("to think that nothing you do will matter.")});
            this.addGroup(new ITextComponent[]{StringTextComponent.field_240750_d_, GoVoteScreen.s("But power is still in the hands of We, the People.")});
            this.addGroup(new ITextComponent[]{GoVoteScreen.s("The Constitution and its amendments guarantee every citizen the right to vote.")});
            this.addGroup(new ITextComponent[]{GoVoteScreen.s("And it is not only our right, but our ").func_230529_a_((ITextComponent)GoVoteScreen.s("responsibility").func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GOLD})).func_240702_b_(" to do so.")});
            this.addGroup(new ITextComponent[]{GoVoteScreen.s("Your vote matters. Always.")});
            this.addGroup(new ITextComponent[]{StringTextComponent.field_240750_d_, GoVoteScreen.s("If you are eligible to vote, please take 2 minutes and click anywhere"), GoVoteScreen.s("to check your registration status and register at ").func_230529_a_((ITextComponent)GoVoteScreen.s(GoVoteHandler.VOTE_ORG_LINK).func_240699_a_(TextFormatting.GOLD))});
            this.addGroup(new ITextComponent[]{StringTextComponent.field_240750_d_, GoVoteScreen.s("Press ESC to exit. (This screen will not show up again.)")});
        }

        private void addGroup(ITextComponent ... lines) {
            this.message.add(Arrays.asList(lines));
            this.ticksForFullMessage += 50;
        }

        private static StringTextComponent s(String txt) {
            return new StringTextComponent(txt);
        }

        public void func_231023_e_() {
            super.func_231023_e_();
            ++this.ticksElapsed;
        }

        public void func_230430_a_(MatrixStack mstack, int mx, int my, float pticks) {
            super.func_230430_a_(mstack, mx, my, pticks);
            int xMiddle = this.field_230708_k_ / 2;
            int yMiddle = this.field_230709_l_ / 2;
            this.field_230712_o_.getClass();
            int lineHeight = 9 + 3;
            int lineCount = this.message.stream().mapToInt(Collection::size).sum();
            int totalTextHeight = lineHeight * lineCount;
            int y = yMiddle - totalTextHeight / 2;
            int headerHeight = y + lineHeight;
            GoVoteScreen.func_238467_a_((MatrixStack)mstack, (int)0, (int)0, (int)this.field_230708_k_, (int)headerHeight, (int)-3140034);
            GoVoteScreen.func_238467_a_((MatrixStack)mstack, (int)0, (int)headerHeight, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-14658413);
            for (int groupIdx = 0; groupIdx < this.message.size(); ++groupIdx) {
                List<ITextComponent> group = this.message.get(groupIdx);
                if (this.ticksElapsed <= groupIdx * 50) continue;
                for (ITextComponent line : group) {
                    GoVoteScreen.func_238472_a_((MatrixStack)mstack, (FontRenderer)this.field_230712_o_, (ITextComponent)line, (int)xMiddle, (int)y, (int)0xFFFFFF);
                    y += lineHeight;
                }
            }
        }

        private boolean isMessageComplete() {
            return this.ticksElapsed >= this.ticksForFullMessage;
        }

        @Nonnull
        public String func_231167_h_() {
            StringBuilder builder = new StringBuilder();
            for (List<ITextComponent> group : this.message) {
                for (ITextComponent line : group) {
                    builder.append(line.getString());
                }
            }
            return builder.toString();
        }

        public boolean func_231046_a_(int keycode, int scanCode, int modifiers) {
            if (!this.isMessageComplete()) {
                return false;
            }
            if (keycode == 256 && this.field_230706_i_ != null) {
                this.field_230706_i_.func_147108_a(this.parent);
            }
            return super.func_231046_a_(keycode, scanCode, modifiers);
        }

        public boolean func_231044_a_(double x, double y, int modifiers) {
            if (modifiers == 0 && this.field_230706_i_ != null) {
                GoVoteHandler.displayOpenLinkScreen(GoVoteHandler.VOTE_ORG_LINK, this.field_230706_i_, this);
                return true;
            }
            return super.func_231044_a_(x, y, modifiers);
        }
    }
}

