/*
 * Decompiled with CFR 0.152.
 */
package com.eleksploded.lavadynamics;

import com.eleksploded.lavadynamics.LavaDynamics;
import com.eleksploded.lavadynamics.cap.CheckedCap;
import com.eleksploded.lavadynamics.cap.IChecked;
import com.eleksploded.lavadynamics.generator.ConeVolcanoGen;
import com.eleksploded.lavadynamics.generator.VolcanoGenerator;
import com.eleksploded.lavadynamics.utils.Utils;
import com.eleksploded.lavadynamics.utils.VolcanoCache;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod.EventBusSubscriber(modid="lavadynamics")
public class VolcanoManager {
    static Random rand = new Random();
    public static boolean worldLoaded;

    @SubscribeEvent
    public static void chunkGen(ChunkEvent.Load e) {
        if (!e.getWorld().func_201670_d()) {
            if (!worldLoaded) {
                return;
            }
            String dimKey = ((ServerWorld)e.getWorld()).func_234923_W_().func_240901_a_().toString();
            List validDims = (List)LavaDynamics.LavaConfig.getValue("validDims");
            if (!validDims.contains(dimKey)) {
                return;
            }
            boolean debug = LavaDynamics.LavaConfig.getBool("debug");
            Chunk chunk = (Chunk)e.getChunk();
            IChecked checked = (IChecked)chunk.getCapability(CheckedCap.checkedCap).orElseThrow(() -> new RuntimeException("Error getting Checked Capability, Please report on the github page"));
            if (debug) {
                LavaDynamics.Logger.debug("Checking Chunk: " + chunk.func_76632_l().field_77276_a + "|" + chunk.func_76632_l().field_77275_b);
            }
            if (VolcanoCache.getCacheResult(chunk) != VolcanoCache.CacheResult.NON_CACHED) {
                return;
            }
            if (!checked.isChecked()) {
                checked.check();
                if (debug) {
                    LavaDynamics.Logger.debug("Checked Chunk: " + chunk.func_76632_l().field_77276_a + "|" + chunk.func_76632_l().field_77275_b);
                }
                if (!LavaDynamics.LavaConfig.getBool("tile_protect") || chunk.func_203066_o().isEmpty()) {
                    if (debug) {
                        LavaDynamics.Logger.debug("Tile Check Passed");
                    }
                    chunk.func_177412_p().func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(1, () -> {
                        if (!Utils.isVolcanoInRange((ServerWorld)e.getWorld(), chunk)) {
                            if (debug) {
                                LavaDynamics.Logger.debug("No Volcano In Range");
                            }
                            if (LavaDynamics.LavaConfig.getInt("chance") > rand.nextInt(1000) + 1) {
                                if (debug) {
                                    LavaDynamics.Logger.debug("Spawning volcanp at Chunk: " + chunk.func_76632_l().field_77276_a + "|" + chunk.func_76632_l().field_77275_b);
                                }
                                VolcanoManager.spawnVolcano(chunk.func_177412_p(), chunk);
                                return;
                            }
                            if (debug) {
                                LavaDynamics.Logger.debug("Chance Test failed");
                            }
                        }
                        VolcanoCache.addCachedChunk(chunk, false);
                    }));
                }
            }
        }
    }

    public static void spawnVolcano(World worldIn, Chunk chunk) {
        int height;
        if (worldIn.field_72995_K) {
            return;
        }
        ServerWorld world = (ServerWorld)worldIn;
        VolcanoCache.addCachedChunk(chunk, true);
        boolean debug = LavaDynamics.LavaConfig.getBool("debug");
        Random rand = world.func_201674_k();
        if (debug && world.func_72863_F().func_222865_a(chunk.func_76632_l())) {
            LavaDynamics.Logger.info("Chunk isnt loaded? Probably going to fail.");
        }
        int x = (chunk.func_76632_l().func_180332_e() - chunk.func_76632_l().func_180334_c()) / 2 + chunk.func_76632_l().func_180334_c();
        int z = (chunk.func_76632_l().func_180330_f() - chunk.func_76632_l().func_180333_d()) / 2 + chunk.func_76632_l().func_180333_d();
        int y = LavaDynamics.LavaConfig.getInt("volcanoYLevel") + (rand.nextInt(5) - 2);
        BlockPos center = new BlockPos(x, y, z);
        if (debug) {
            LavaDynamics.Logger.info("Center Location is " + center);
        }
        if (debug) {
            // empty if block
        }
        if (debug) {
            LavaDynamics.Logger.info("Generating Lava Pillar");
        }
        if ((height = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, x, z) - center.func_177956_o()) <= 0) {
            height = 1;
        }
        if (debug) {
            LavaDynamics.Logger.info("Height for Generation is: " + height);
        }
        int topY = 70;
        for (int i = 0; i <= height; ++i) {
            int j = i + center.func_177956_o();
            ChunkPos cPos = new ChunkPos(new BlockPos(x, j, z));
            if (!world.func_72863_F().func_222865_a(cPos)) {
                if (debug) {
                    LavaDynamics.Logger.info("Chunk is unloaded, trying to load");
                }
                world.func_217458_b(cPos.field_77276_a, cPos.field_77275_b, true);
            }
            if (debug) {
                LavaDynamics.Logger.info("Placing Lava at y=" + j);
            }
            world.func_180501_a(new BlockPos(x, j, z), Blocks.field_150353_l.func_176223_P(), 3);
            topY = j;
        }
        if (debug) {
            LavaDynamics.Logger.info("Lava Pillar Done");
        }
        if (debug) {
            LavaDynamics.Logger.info("Generate Volcano");
        }
        VolcanoGenerator gen = VolcanoManager.getGenerator((World)world, new BlockPos(x, topY, z));
        if (debug) {
            LavaDynamics.Logger.debug("Running Generator");
        }
        gen.generate((World)world, rand, new BlockPos(x, topY, z));
        if (debug) {
            LavaDynamics.Logger.info("Done Generating. Filling with " + Blocks.field_150353_l);
        }
        BlockPos fill = new BlockPos(x, topY, z);
        int top = 0;
        while (world.func_180495_p(fill).func_177230_c() != Blocks.field_150353_l || world.func_180495_p(fill).func_177230_c() != Blocks.field_150350_a || world.func_180495_p(fill).func_177230_c() != Blocks.field_150353_l) {
            if (debug) {
                LavaDynamics.Logger.info("Block at " + fill + " is " + world.func_180495_p(fill).func_177230_c());
                LavaDynamics.Logger.info("Setting " + fill + " to lava");
            }
            world.func_175656_a(fill, Blocks.field_150353_l.func_176223_P());
            fill = fill.func_177984_a();
            if (world.func_180495_p(fill).func_177230_c() == Blocks.field_150350_a || world.func_180495_p(fill).func_177230_c() == Blocks.field_150355_j || fill.func_177956_o() >= 255 || fill.func_177956_o() <= 3) break;
            top = fill.func_177956_o();
        }
        IChecked ch = (IChecked)chunk.getCapability(CheckedCap.checkedCap).orElseThrow(() -> new RuntimeException("Error getting Checked Capability, Please report on the github page"));
        ch.setVolcano(top);
        ch.setCooldown(15);
        if (debug) {
            LavaDynamics.Logger.info("Done filling, Spawning crater");
        }
        BlockPos fill1 = fill.func_177979_c(4);
        for (int radius = 3; radius != 0; --radius) {
            int x1 = fill1.func_177958_n();
            int y1 = fill1.func_177956_o() - 1;
            int z1 = fill1.func_177952_p();
            float i1 = 0.0f;
            while (i1 < (float)radius) {
                float j1 = 0.0f;
                while ((double)j1 < Math.PI * 2 * (double)i1) {
                    world.func_175656_a(new BlockPos((int)Math.floor((double)x1 + Math.sin(j1) * (double)i1), y1 + radius, (int)Math.floor((double)z1 + Math.cos(j1) * (double)i1)), Blocks.field_150353_l.func_176223_P());
                    j1 = (float)((double)j1 + 0.5);
                }
                i1 = (float)((double)i1 + 0.5);
            }
            fill1 = fill1.func_177977_b();
        }
        world.func_217398_a(null, (double)fill.func_177958_n(), (double)(fill.func_177956_o() + 3), (double)fill.func_177952_p(), (float)LavaDynamics.LavaConfig.getInt("craterSize").intValue(), LavaDynamics.LavaConfig.getBool("initialFire"), Explosion.Mode.DESTROY);
        if (debug) {
            LavaDynamics.Logger.info("Done with crater");
        }
    }

    public static VolcanoGenerator getGenerator(World world, BlockPos pos) {
        VolcanoGenerator cone = null;
        Biome biome = world.func_226691_t_(pos);
        boolean debug = LavaDynamics.LavaConfig.getBool("debug");
        for (VolcanoGenerator generator : GameRegistry.findRegistry(VolcanoGenerator.class)) {
            if (generator.getRegistryName().equals((Object)ConeVolcanoGen.regName)) {
                if (debug) {
                    LavaDynamics.Logger.debug("Found Cone Generator");
                }
                cone = generator;
                continue;
            }
            if (debug) {
                LavaDynamics.Logger.debug("Checking Generator " + generator.getRegistryName() + " for biome " + biome.getRegistryName());
            }
            if (!generator.getValidBiomes().contains(biome.getRegistryName().toString())) continue;
            if (debug) {
                LavaDynamics.Logger.debug("Matched Generator to Biome!");
            }
            return generator;
        }
        return cone;
    }
}

