/*
 * Decompiled with CFR 0.152.
 */
package com.eleksploded.lavadynamics.generator;

import com.eleksploded.lavadynamics.LavaDynamics;
import com.eleksploded.lavadynamics.generator.VolcanoGenerator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ConeVolcanoGen
extends VolcanoGenerator {
    public static ResourceLocation regName = new ResourceLocation("lavadynamics", "cone_generator");

    public ConeVolcanoGen() {
        this.setRegistryName(regName);
    }

    @Override
    public void generate(World world, Random random, BlockPos position) {
        BlockPos pos1;
        int height;
        boolean debug = LavaDynamics.LavaConfig.getBool("debug");
        Random rand = new Random();
        if (debug) {
            LavaDynamics.Logger.debug("Get Height for Volcano");
        }
        if ((height = rand.nextInt(LavaDynamics.LavaConfig.getInt("heightMax") - LavaDynamics.LavaConfig.getInt("heightMin") + 1) + LavaDynamics.LavaConfig.getInt("heightMin")) <= 0) {
            return;
        }
        if (debug) {
            LavaDynamics.Logger.debug("Volcano height is " + height);
        }
        if (debug) {
            LavaDynamics.Logger.debug("Get Caldera for volcano");
        }
        int caldera = rand.nextInt(LavaDynamics.LavaConfig.getInt("calderaMax") - LavaDynamics.LavaConfig.getInt("calderaMin") + 1) + LavaDynamics.LavaConfig.getInt("calderaMin");
        BlockPos pos = new BlockPos(position.func_177958_n(), position.func_177956_o() + height, position.func_177952_p());
        int i = caldera;
        int j = pos.func_177956_o();
        if (debug) {
            LavaDynamics.Logger.debug("Generate Volcano Cone");
        }
        while (j < 255 && j > 3 && (this.isCornerAir(world, pos1 = new BlockPos(pos.func_177958_n(), j, pos.func_177952_p()), i) || pos1.func_177956_o() >= 255 || pos.func_177956_o() <= 3)) {
            this.circle(i, world, pos1, j);
            this.setBlockWithOre(world, pos1, false, this.ores);
            ++i;
            --j;
        }
        if (debug) {
            LavaDynamics.Logger.debug("Offsetting for caldera");
        }
        BlockPos fill1 = position.func_177981_b(height);
        while (!world.func_175623_d(fill1) && !world.func_175623_d(fill1 = fill1.func_177977_b()) && fill1.func_177956_o() > 0) {
        }
        if (debug) {
            LavaDynamics.Logger.debug("Filling caldera");
        }
        for (int radius = caldera - 1; radius != 0; --radius) {
            int x1 = fill1.func_177958_n();
            int y1 = fill1.func_177956_o() - 1;
            int z1 = fill1.func_177952_p();
            float i1 = 0.0f;
            while (i1 < (float)radius) {
                float j1 = 0.0f;
                while ((double)j1 < Math.PI * 2 * (double)i1) {
                    world.func_175656_a(new BlockPos((int)Math.floor((double)x1 + Math.sin(j1) * (double)i1), y1 + radius, (int)Math.floor((double)z1 + Math.cos(j1) * (double)i1)), Blocks.field_150353_l.func_176223_P());
                    j1 = (float)((double)j1 + 0.5);
                }
                i1 = (float)((double)i1 + 0.5);
            }
            fill1 = fill1.func_177977_b();
        }
        if (debug) {
            LavaDynamics.Logger.debug("Done with Generator");
        }
    }

    private boolean isCornerAir(World world, BlockPos pos, int radius) {
        if (world.func_180495_p(pos.func_177965_g(radius)).func_177230_c() == Blocks.field_150350_a) {
            return true;
        }
        if (world.func_180495_p(pos.func_177985_f(radius)).func_177230_c() == Blocks.field_150350_a) {
            return true;
        }
        if (world.func_180495_p(pos.func_177964_d(radius)).func_177230_c() == Blocks.field_150350_a) {
            return true;
        }
        return world.func_180495_p(pos.func_177970_e(radius)).func_177230_c() == Blocks.field_150350_a;
    }

    public void circle(int radius, World world, BlockPos fill1, int j) {
        int x1 = fill1.func_177958_n();
        int y1 = fill1.func_177956_o();
        int z1 = fill1.func_177952_p();
        float i1 = 0.0f;
        while (i1 < (float)radius) {
            float j1 = 0.0f;
            while ((double)j1 < Math.PI * 2 * (double)i1) {
                if (LavaDynamics.LavaConfig.getBool("useBiome") && (double)i1 == (double)radius - 0.5 && radius > LavaDynamics.LavaConfig.getInt("biomeStart")) {
                    if (radius == LavaDynamics.LavaConfig.getInt("biomeStart") && world.field_73012_v.nextBoolean()) {
                        this.setBlockWithOre(world, new BlockPos((int)Math.floor((double)x1 + Math.sin(j1) * (double)i1), y1, (int)Math.floor((double)z1 + Math.cos(j1) * (double)i1)), false, this.ores);
                    } else {
                        this.setBlockWithBiomeTop(world, new BlockPos((int)Math.floor((double)x1 + Math.sin(j1) * (double)i1), y1, (int)Math.floor((double)z1 + Math.cos(j1) * (double)i1)));
                    }
                } else {
                    this.setBlockWithOre(world, new BlockPos((int)Math.floor((double)x1 + Math.sin(j1) * (double)i1), y1, (int)Math.floor((double)z1 + Math.cos(j1) * (double)i1)), LavaDynamics.LavaConfig.getBool("useBiome") && i1 >= (float)radius - ((float)LavaDynamics.LavaConfig.getInt("fillerSize").intValue() + 0.5f), this.ores);
                }
                j1 = (float)((double)j1 + 0.5);
            }
            i1 = (float)((double)i1 + 0.5);
        }
    }

    @Override
    public List<String> getValidBiomes() {
        return null;
    }
}

