/*
 * Decompiled with CFR 0.152.
 */
package com.eleksploded.lavadynamics.utils;

import com.eleksploded.lavadynamics.LavaDynamics;
import com.eleksploded.lavadynamics.utils.IndexedMap;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import org.apache.commons.lang3.tuple.Pair;

public class VolcanoCache {
    private static IndexedMap<ChunkPos, Boolean> CACHE = new IndexedMap();

    public static boolean isCached(Chunk chunk) {
        return CACHE.containsKey(chunk.func_76632_l());
    }

    public static boolean isCached(ChunkPos pos) {
        return CACHE.containsKey(pos);
    }

    public static CacheResult getCacheResult(Chunk chunkIn) {
        for (Pair<ChunkPos, Boolean> e : CACHE.pairSet()) {
            if (e.getLeft() != chunkIn.func_76632_l()) continue;
            return (Boolean)e.getRight() != false ? CacheResult.VOLCANO : CacheResult.NO_VOLCANO;
        }
        return CacheResult.NON_CACHED;
    }

    public static void addCachedChunk(ChunkPos pos, boolean volcano) {
        int size = LavaDynamics.LavaConfig.getInt("cacheSize");
        if (size == 0) {
            if (CACHE != null) {
                CACHE = null;
            }
            return;
        }
        if (CACHE.containsKey(pos)) {
            return;
        }
        if (CACHE.size() >= size) {
            CACHE.remove(CACHE.size() - 1);
        }
        CACHE.add(0, pos, volcano);
    }

    public static void addCachedChunk(Chunk chunk, boolean volcano) {
        VolcanoCache.addCachedChunk(chunk.func_76632_l(), volcano);
    }

    public static CacheResult getCacheResult(ChunkPos pos) {
        for (Pair<ChunkPos, Boolean> e : CACHE.pairSet()) {
            if (e.getLeft() != pos) continue;
            return (Boolean)e.getRight() != false ? CacheResult.VOLCANO : CacheResult.NO_VOLCANO;
        }
        return CacheResult.NON_CACHED;
    }

    public static enum CacheResult {
        VOLCANO,
        NO_VOLCANO,
        NON_CACHED;

    }
}

