/*
 * Decompiled with CFR 0.152.
 */
package com.eleksploded.eleklib.item;

import com.eleksploded.eleklib.ElekLib;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ArmorUtils {
    public static <T extends ArmorItem> T[] createFullArmorSet(Class<T> c, ArmorMaterial mat) {
        try {
            Constructor<T> con = c.getConstructor(ArmorMaterial.class, EquipmentSlotType.class);
            ArmorItem head = (ArmorItem)con.newInstance(mat, EquipmentSlotType.HEAD);
            ArmorItem chest = (ArmorItem)con.newInstance(mat, EquipmentSlotType.CHEST);
            ArmorItem legs = (ArmorItem)con.newInstance(mat, EquipmentSlotType.LEGS);
            ArmorItem boots = (ArmorItem)con.newInstance(mat, EquipmentSlotType.FEET);
            ArrayList<ArmorItem> l = new ArrayList<ArmorItem>();
            l.add(head);
            l.add(chest);
            l.add(legs);
            l.add(boots);
            return (ArmorItem[])l.toArray();
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            ElekLib.LOGGER.error("Failed to make isntances of " + c.getName() + ". Please check on the contructor. Returning null");
            return null;
        }
    }

    public static boolean isFullSet(PlayerEntity player, Item headIn, Item chestIn, Item legsIn, Item bootsIn) {
        ItemStack boots = (ItemStack)player.field_71071_by.field_70460_b.get(0);
        ItemStack pants = (ItemStack)player.field_71071_by.field_70460_b.get(1);
        ItemStack chest = (ItemStack)player.field_71071_by.field_70460_b.get(2);
        ItemStack head = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        if (ArmorUtils.isFullArmor(player)) {
            Item Itemboots = boots.func_77973_b();
            Item Itempants = pants.func_77973_b();
            Item Itemchest = chest.func_77973_b();
            Item Itemhead = head.func_77973_b();
            return Itemboots == bootsIn && Itempants == legsIn && Itemchest == chestIn && Itemhead == headIn;
        }
        return false;
    }

    public static boolean isFullSet(PlayerEntity player, Item[] set) {
        return ArmorUtils.isFullSet(player, set[0], set[1], set[2], set[3]);
    }

    public static boolean isFullArmor(PlayerEntity player) {
        ItemStack boots = (ItemStack)player.field_71071_by.field_70460_b.get(0);
        ItemStack pants = (ItemStack)player.field_71071_by.field_70460_b.get(1);
        ItemStack chest = (ItemStack)player.field_71071_by.field_70460_b.get(2);
        ItemStack head = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        return boots != ItemStack.field_190927_a && pants != ItemStack.field_190927_a && chest != ItemStack.field_190927_a && head != ItemStack.field_190927_a;
    }
}

