/*
 * Decompiled with CFR 0.152.
 */
package com.eleksploded.eleklib.updatecheck;

import com.eleksploded.eleklib.ElekLib;
import com.eleksploded.eleklib.updatecheck.UpdateChecker;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;

public class UpdateCheckThread
implements Runnable {
    private final ModContainer container;

    public UpdateCheckThread(ModContainer c) {
        this.container = c;
    }

    @Override
    public void run() {
        VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)this.container.getModInfo());
        switch (result.status) {
            case BETA_OUTDATED: {
                ElekLib.LOGGER.info(ElekLib.ElekLibConfig.getString("betaOutdatedMessage"));
                UpdateChecker.sendMessage(ElekLib.ElekLibConfig.getString("betaOutdatedMessage"), this.container.getModInfo().getDisplayName(), result.target.getCanonical());
                break;
            }
            case FAILED: {
                ElekLib.LOGGER.info(ElekLib.ElekLibConfig.getString("failedMessage"));
                UpdateChecker.sendMessage(ElekLib.ElekLibConfig.getString("failedMessage"), this.container.getModInfo().getDisplayName());
                break;
            }
            case OUTDATED: {
                ElekLib.LOGGER.info(ElekLib.ElekLibConfig.getString("outdatedMessage"));
                UpdateChecker.sendMessage(ElekLib.ElekLibConfig.getString("outdatedMessage"), this.container.getModInfo().getDisplayName(), result.target.getCanonical());
                break;
            }
            case PENDING: {
                try {
                    Thread.sleep(1000L);
                    this.run();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }
}

