/*
 * Decompiled with CFR 0.152.
 */
package com.eleksploded.lavadynamics;

import com.eleksploded.eleklib.config.Config;
import com.eleksploded.eleklib.config.ConfigBuilder;
import com.eleksploded.lavadynamics.cap.CheckedHandler;
import com.eleksploded.lavadynamics.cap.CheckedStorage;
import com.eleksploded.lavadynamics.cap.IChecked;
import com.eleksploded.lavadynamics.command.CheckedCommand;
import com.eleksploded.lavadynamics.command.SpawnVolcano;
import com.eleksploded.lavadynamics.generator.ConeVolcanoGen;
import com.eleksploded.lavadynamics.generator.MountianVolcanoGen;
import com.eleksploded.lavadynamics.generator.VolcanoGenerator;
import com.eleksploded.lavadynamics.hardernether.cap.HarderNetherHandler;
import com.eleksploded.lavadynamics.hardernether.cap.HarderNetherStorage;
import com.eleksploded.lavadynamics.hardernether.cap.IHarderNether;
import com.eleksploded.lavadynamics.postgen.PostGenEffect;
import com.eleksploded.lavadynamics.postgen.effects.EruptEffect;
import com.eleksploded.lavadynamics.postgen.effects.RumbleEffect;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.command.CommandSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lavadynamics")
public class LavaDynamics {
    public static final String ModId = "lavadynamics";
    public static final Logger Logger = LogManager.getLogger();
    public static Config LavaConfig;

    public LavaDynamics() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onComplete);
        MinecraftForge.EVENT_BUS.register((Object)this);
        LavaConfig = ConfigBuilder.builder().category("General", "General Settings", b -> {
            b.addBool("debug", false, "Enable debug mode. Will result in console spam");
            b.addBool("postgendebug", false, "Enable debug mode for postgen. Will result in console spam");
            b.addBool("regDump", false, "Causes the mod to print all PostGenEffect registry contents to the console");
        }).category("Generator", "Generation Settings", b -> {
            b.category("Restrictions", "Chances/restrictions of where to spawn", c -> {
                c.addInt("chance", Integer.valueOf(5), "Chance for a volcano to spawn. x in 1000", Integer.valueOf(0), Integer.valueOf(1000));
                c.addBool("tile_protect", true, "Protect chunks containing tile entities");
                c.addBool("spawnChunks", false, "Should Volcanoes spawn in spawn chunks");
                c.addInt("spawnDistance", Integer.valueOf(500), "Block distance from spawn needed to spawn a volcano", Integer.valueOf(0), Integer.valueOf(10000));
                c.addInt("playerDistance", Integer.valueOf(100), "Distance from a player needed before spawning a volcano", Integer.valueOf(0), Integer.valueOf(10000));
                c.addInt("volcanoDistance", Integer.valueOf(16), "Distance from other volcanoes to spawn a volcano (in chunks, multiply by 16 for blocks). Scans a square of radius this.", Integer.valueOf(0), Integer.valueOf(128));
                c.addList("validDims", Arrays.asList("minecraft:overworld"), "Valid dimensions for volcanoes to spawn in", o -> ((String)o).contains(":"));
            });
            b.category("Biome", "Options for volcanoes using biomes", c -> {
                c.addBool("useBiome", true, "Should the volcano use the biome blocks");
                c.addInt("fillerSize", Integer.valueOf(2), "How far in should biome filler blocks go? Set to 0 to disable use of filler blocks", Integer.valueOf(0), Integer.valueOf(64));
                c.addInt("biomeStart", Integer.valueOf(3), "How far down should biome meshing start?", Integer.valueOf(0), Integer.valueOf(128));
                c.addList("mountainBiomes", Arrays.asList(Biomes.field_185443_S.func_240901_a_().toString(), Biomes.field_185434_af.func_240901_a_().toString(), Biomes.field_76783_v.func_240901_a_().toString(), Biomes.field_76770_e.func_240901_a_().toString(), Biomes.field_76775_o.func_240901_a_().toString(), Biomes.field_185431_ac.func_240901_a_().toString(), Biomes.field_150590_f.func_240901_a_().toString(), Biomes.field_150580_W.func_240901_a_().toString()), "Biomes that use the Mountain Generation for Volcanoes", o -> ((String)o).contains(":"));
            });
            b.addInt("volcanoYLevel", Integer.valueOf(10), "Approximate Y level of underground volcano lake", Integer.valueOf(0), Integer.valueOf(64));
            b.addInt("heightMin", Integer.valueOf(3), "Minimum Height of the volcano", Integer.valueOf(3), Integer.valueOf(100));
            b.addInt("heightMax", Integer.valueOf(20), "Maximum Height of the volcano", Integer.valueOf(4), Integer.valueOf(101));
            b.addInt("calderaMin", Integer.valueOf(2), "Minimum size of the calderas", Integer.valueOf(2), Integer.valueOf(20));
            b.addInt("calderaMax", Integer.valueOf(6), "Maximum size of the calderas", Integer.valueOf(2), Integer.valueOf(20));
            b.addInt("craterSize", Integer.valueOf(15), "Power of Initial Eruption", Integer.valueOf(0), Integer.valueOf(128));
            b.addBool("initialFire", true, "Should the initial eruption cause fire");
            b.addInt("oreChance", Integer.valueOf(50), "Chance an ore spawns. x in 1000", Integer.valueOf(0), Integer.valueOf(1000));
            b.addList("ores", Arrays.asList("minecraft:coal_ore|15"), "Ores to spawn in volcano. Format should be 'modid:block|chances' ", o -> ((String)o).contains(":"));
        }).category("PostGenEffects", "Options for PostGen Effects", b -> {
            b.addBool("enablePostGenEffects", true, "Should postgen effects occur");
            b.addInt("PostGenEffectCooldown", Integer.valueOf(3), "Minumum ticks between effects (Set super low due to chance being super low. WIP)", Integer.valueOf(0), Integer.valueOf(1728000));
            b.addList("blacklistEffects", Arrays.asList(new String[0]), "List of effects to blacklist (modid:effect). Built in effects are lavadynamics:erupt and lavadynamics:rumble", o -> ((String)o).contains(":"));
        }).category("WorldSmelting", "Options to do with world smelting", b -> {
            b.addBool("worldSmeltingEnabled", true, "Is world smelting enabled");
            b.addList("blacklistedBlocks", Arrays.asList(new String[0]), "Block IDs to ignore smelting (modid:block)", o -> ((String)o).contains(":"));
        }).category("HarderNether", "Options to do with making the nether harder", b -> {
            b.addBool("hardNetherEnabled", false, "Should the Harder Nether be enabled");
            b.addList("harderNetherDims", Arrays.asList("minecraft:the_nether"), "World to enable Harder Nether Effects in", o -> ((String)o).contains(":"));
            b.addInt("timeForFire", Integer.valueOf(1200), "Time (in ticks) before a player gets lit on fire in a Hard Nether Dim", Integer.valueOf(20), Integer.valueOf(2400));
            b.addInt("fireProtRequire", Integer.valueOf(4), "Level of fire protection needed to negate fire in Hard Nether Dim", Integer.valueOf(1), Integer.valueOf(16));
        }).category("Performance", "Options that have impact on performance", b -> b.addInt("cacheSize", Integer.valueOf(256), "Size of the cache of chunks. Larger Caches will speed up world gen time, at the cost of RAM usage. Set to 0 to disable caching.", Integer.valueOf(0), Integer.valueOf(65536))).build(ModId, ModConfig.Type.COMMON);
    }

    private void setup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(IChecked.class, (Capability.IStorage)new CheckedStorage(), CheckedHandler::new);
        CapabilityManager.INSTANCE.register(IHarderNether.class, (Capability.IStorage)new HarderNetherStorage(), HarderNetherHandler::new);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(RegisterCommandsEvent e) {
        CheckedCommand.register((CommandDispatcher<CommandSource>)e.getDispatcher());
        SpawnVolcano.register((CommandDispatcher<CommandSource>)e.getDispatcher());
    }

    public void onComplete(FMLLoadCompleteEvent e) {
        if (LavaConfig.getBool("regDump")) {
            Logger.info("Dumping PostGenEffect Registry...");
            IForgeRegistry reg = GameRegistry.findRegistry(PostGenEffect.class);
            reg.forEach(effect -> Logger.info("\t" + effect.getRegistryName()));
            Logger.info("Dump Complete");
            Logger.info("Dumping VolcanoGenerator Registry...");
            IForgeRegistry reg2 = GameRegistry.findRegistry(VolcanoGenerator.class);
            reg2.forEach(effect -> Logger.info("\t" + effect.getRegistryName()));
            Logger.info("Dump Complete");
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onRegRegistry(RegistryEvent.NewRegistry reg) {
            new RegistryBuilder().setName(new ResourceLocation(LavaDynamics.ModId, "postgeneffects")).setType(PostGenEffect.class).setDefaultKey(new ResourceLocation(LavaDynamics.ModId, "invalid")).create();
            new RegistryBuilder().setName(new ResourceLocation(LavaDynamics.ModId, "volcanogenerator")).setType(VolcanoGenerator.class).setDefaultKey(new ResourceLocation(LavaDynamics.ModId, "invalid")).create();
        }

        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
        }

        @SubscribeEvent
        public static void onPostGenRegistry(RegistryEvent.Register<PostGenEffect> pge) {
            IForgeRegistry reg = pge.getRegistry();
            reg.register((IForgeRegistryEntry)LDPostGenEffects.erupt);
            reg.register((IForgeRegistryEntry)LDPostGenEffects.rumble);
        }

        @SubscribeEvent
        public static void onGeneratorRegistry(RegistryEvent.Register<VolcanoGenerator> vg) {
            IForgeRegistry reg = vg.getRegistry();
            reg.register((IForgeRegistryEntry)new ConeVolcanoGen());
            reg.register((IForgeRegistryEntry)new MountianVolcanoGen());
        }
    }

    public static class LDPostGenEffects {
        public static PostGenEffect erupt = new EruptEffect();
        public static PostGenEffect rumble = new RumbleEffect();
    }
}

