/*
 * Decompiled with CFR 0.152.
 */
package com.eleksploded.lavadynamics;

import com.eleksploded.lavadynamics.LavaDynamics;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class WorldSmelting {
    @SubscribeEvent
    public static void onBlockUpdate(BlockEvent.NeighborNotifyEvent e) {
        if (!e.getWorld().func_201670_d() && LavaDynamics.LavaConfig.getBool("worldSmeltingEnabled")) {
            World world = (World)e.getWorld();
            if (e.getState().func_177230_c().isAir(e.getState(), (IBlockReader)world, e.getPos())) {
                return;
            }
            if (WorldSmelting.isByLava(world, e.getPos())) {
                WorldSmelting.doSmelt(e.getPos(), world, e.getState());
            }
        }
    }

    public static void fluidSpread(BlockPos posIn, World world, Fluid fluid) {
        if (!world.field_72995_K && LavaDynamics.LavaConfig.getBool("worldSmeltingEnabled") && (fluid == Fluids.field_204547_b || fluid == Fluids.field_207213_d)) {
            for (Direction dir : Direction.values()) {
                BlockPos pos = posIn.func_177967_a(dir, 1);
                BlockState state = world.func_180495_p(pos);
                WorldSmelting.doSmelt(pos, world, state);
            }
        }
    }

    public static void doSmelt(BlockPos pos, World world, BlockState state) {
        Block output;
        if (state.isAir((IBlockReader)world, pos)) {
            return;
        }
        List blacklist = LavaDynamics.LavaConfig.getList("blacklistedBlocks");
        if (blacklist.contains(state.func_177230_c().getRegistryName().toString())) {
            return;
        }
        ItemStack stack = new ItemStack((IItemProvider)state.func_177230_c().func_199767_j(), 1);
        Inventory fakeInv = new Inventory(1);
        fakeInv.func_174894_a(stack);
        IRecipe r = world.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)fakeInv, world).orElse(null);
        if (r != null && r.func_222127_g() == IRecipeType.field_222150_b && (output = Block.func_149634_a((Item)r.func_77571_b().func_77973_b())) != Blocks.field_150350_a) {
            world.func_175656_a(pos, output.func_176223_P());
            world.func_184133_a(null, pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static boolean isByLava(World world, BlockPos pos) {
        for (Direction dir : (Direction[])Direction.class.getEnumConstants()) {
            Block b = world.func_180495_p(pos.func_177967_a(dir, 1)).func_177230_c();
            if (b != Blocks.field_150353_l) continue;
            return true;
        }
        return false;
    }

    public static IRecipe<?> getRecipeFromBlock(RecipeManager manager, Block block) {
        for (IRecipe recipe : manager.func_199510_b()) {
            Ingredient i = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)block.func_199767_j())});
            if (!recipe.func_192400_c().contains((Object)i)) continue;
            return recipe;
        }
        return null;
    }
}

